use strict;
use warnings;

use Module::Build;

my $builder = Module::Build->new(
    module_name         => 'Module::Mask',
    license             => 'perl',
    dist_author         => 'Matt Lawrence <mattlaw@cpan.org>',
    add_to_cleanup      => [ 'Module-Mask-*' ],
    create_makefile_pl  => 'passthrough',

    requires => {
        'perl' => '5.8.0',
        'Module::Util' => 0,
        'Scalar::Util' => '1.01',
    },
    build_requires => {
        'Test::More' => 0,
    },
    recommends => {
        'Test::Pod' => '1.14',
        'Test::Pod::Coverage' => '1.04',
    },
);

$builder->create_build_script;
