package WWW::Bund::CLI::Cmd::Bundestag;
our $VERSION = '0.002';
# ABSTRACT: Bundestag API commands

use Moo;
use MooX::Cmd;
use MooX::Options protect_argv => 0;


with 'WWW::Bund::CLI::Role::APICommand';

sub api_id { 'bundestag' }

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WWW::Bund::CLI::Cmd::Bundestag - Bundestag API commands

=head1 VERSION

version 0.002

=head1 SYNOPSIS

    bund bundestag speaker          # Speaker info
    bund bundestag mdb-index        # List all MdB
    bund bundestag ausschuesse      # List committees

=head1 DESCRIPTION

CLI commands for Bundestag API (German Federal Parliament data). Uses L<WWW::Bund::CLI::Role::APICommand>. See L<WWW::Bund::API::Bundestag>.

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/Getty/p5-www-bund/issues>.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
