/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.StringTokenizer;
import org.apache.qpid.jms.util.InvalidContentTypeException;

public final class ContentTypeSupport {
    private static final String UTF_8 = "UTF-8";
    private static final String CHARSET = "charset";
    private static final String TEXT = "text";
    private static final String APPLICATION = "application";
    private static final String JAVASCRIPT = "javascript";
    private static final String XML = "xml";
    private static final String XML_VARIANT = "+xml";
    private static final String JSON = "json";
    private static final String JSON_VARIANT = "+json";
    private static final String XML_DTD = "xml-dtd";
    private static final String ECMASCRIPT = "ecmascript";

    public static Charset parseContentTypeForTextualCharset(String contentType) throws InvalidContentTypeException {
        if (contentType == null || contentType.trim().isEmpty()) {
            throw new InvalidContentTypeException("Content type can't be null or empty");
        }
        int subTypeSeparator = contentType.indexOf("/");
        if (subTypeSeparator == -1) {
            throw new InvalidContentTypeException("Content type has no '/' separator: " + contentType);
        }
        String type = contentType.substring(0, subTypeSeparator).toLowerCase().trim();
        String subTypePart = contentType.substring(subTypeSeparator + 1).toLowerCase().trim();
        String parameterPart = null;
        int parameterSeparator = subTypePart.indexOf(";");
        if (parameterSeparator != -1) {
            if (parameterSeparator < subTypePart.length() - 1) {
                parameterPart = contentType.substring(subTypeSeparator + 1).toLowerCase().trim();
            }
            subTypePart = subTypePart.substring(0, parameterSeparator).trim();
        }
        if (subTypePart.isEmpty()) {
            throw new InvalidContentTypeException("Content type has no subtype after '/'" + contentType);
        }
        String subType = subTypePart;
        if (ContentTypeSupport.isTextual(type, subType)) {
            String charset = ContentTypeSupport.findCharset(parameterPart);
            if (charset == null) {
                charset = UTF_8;
            }
            if (UTF_8.equals(charset)) {
                return StandardCharsets.UTF_8;
            }
            try {
                return Charset.forName(charset);
            }
            catch (IllegalCharsetNameException icne) {
                throw new InvalidContentTypeException("Illegal charset: " + charset);
            }
            catch (UnsupportedCharsetException uce) {
                throw new InvalidContentTypeException("Unsupported charset: " + charset);
            }
        }
        return null;
    }

    private static boolean isTextual(String type, String subType) {
        if (TEXT.equals(type)) {
            return true;
        }
        return APPLICATION.equals(type) && (XML.equals(subType) || JSON.equals(subType) || JAVASCRIPT.equals(subType) || subType.endsWith(XML_VARIANT) || subType.endsWith(JSON_VARIANT) || XML_DTD.equals(subType) || ECMASCRIPT.equals(subType));
    }

    private static String findCharset(String paramaterPart) {
        String charset = null;
        if (paramaterPart != null) {
            StringTokenizer tokenizer = new StringTokenizer(paramaterPart, ";");
            while (tokenizer.hasMoreTokens()) {
                String name;
                String parameter = tokenizer.nextToken().trim();
                int eqIndex = parameter.indexOf(61);
                if (eqIndex == -1 || !CHARSET.equalsIgnoreCase((name = parameter.substring(0, eqIndex)).trim())) continue;
                String value = ContentTypeSupport.unquote(parameter.substring(eqIndex + 1));
                charset = value.toUpperCase();
                break;
            }
        }
        return charset;
    }

    private static String unquote(String s) {
        if (s.length() > 1 && s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

