/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.List;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenAPIConfig {
    @Bean
    public GroupedOpenApi publicApi() {
        return GroupedOpenApi.builder().group("public").pathsToMatch(new String[]{"/api/**"}).build();
    }

    @Bean
    public OpenAPI custosOpenAPI() {
        return new OpenAPI().info(new Info().title("CUSTOS API").version("1.0.0")).addSecurityItem(new SecurityRequirement().addList("oauth2-pkce")).components(new Components().addSecuritySchemes("oauth2-pkce", new SecurityScheme().type(SecurityScheme.Type.OAUTH2).flows(new OAuthFlows().authorizationCode(new OAuthFlow().authorizationUrl("/api/v1/identity-management/authorize").tokenUrl("/api/v1/identity-management/token").scopes(new Scopes().addString("openid", "openid").addString("email", "email")))))).servers(List.of(new Server().url("http://127.0.0.1:8081"), new Server().url("https://api.usecustos.org")));
    }
}

