/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.AuthenticationSteps;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.AuthenticationUtil;
import org.springframework.vault.authentication.AwsIamAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.authentication.VaultLoginException;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public class AwsIamAuthentication
implements ClientAuthentication,
AuthenticationStepsFactory {
    private static final Log logger = LogFactory.getLog(AwsIamAuthentication.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String REQUEST_BODY = "Action=GetCallerIdentity&Version=2011-06-15";
    private static final String REQUEST_BODY_BASE64_ENCODED = Base64Utils.encodeToString((byte[])"Action=GetCallerIdentity&Version=2011-06-15".getBytes());
    private final AwsIamAuthenticationOptions options;
    private final RestOperations vaultRestOperations;

    public AwsIamAuthentication(AwsIamAuthenticationOptions options, RestOperations vaultRestOperations) {
        Assert.notNull((Object)options, (String)"AwsIamAuthenticationOptions must not be null");
        Assert.notNull((Object)vaultRestOperations, (String)"Vault RestOperations must not be null");
        this.options = options;
        this.vaultRestOperations = vaultRestOperations;
    }

    public static AuthenticationSteps createAuthenticationSteps(AwsIamAuthenticationOptions options) {
        Assert.notNull((Object)options, (String)"AwsIamAuthenticationOptions must not be null");
        AwsCredentials credentials = options.getCredentialsProvider().resolveCredentials();
        Region region = options.getRegionProvider().getRegion();
        return AwsIamAuthentication.createAuthenticationSteps(options, credentials, region);
    }

    protected static AuthenticationSteps createAuthenticationSteps(AwsIamAuthenticationOptions options, AwsCredentials credentials, Region region) {
        return AuthenticationSteps.fromSupplier(() -> AwsIamAuthentication.createRequestBody(options, credentials, region)).login(AuthenticationUtil.getLoginPath(options.getPath()), new String[0]);
    }

    @Override
    public VaultToken login() throws VaultException {
        return this.createTokenUsingAwsIam();
    }

    @Override
    public AuthenticationSteps getAuthenticationSteps() {
        return AwsIamAuthentication.createAuthenticationSteps(this.options, this.options.getCredentialsProvider().resolveCredentials(), this.options.getRegionProvider().getRegion());
    }

    private VaultToken createTokenUsingAwsIam() {
        Map<String, String> login = AwsIamAuthentication.createRequestBody(this.options);
        try {
            VaultResponse response = (VaultResponse)this.vaultRestOperations.postForObject(AuthenticationUtil.getLoginPath(this.options.getPath()), login, VaultResponse.class, new Object[0]);
            Assert.state((response != null && response.getAuth() != null ? 1 : 0) != 0, (String)"Auth field must not be null");
            if (logger.isDebugEnabled()) {
                if (response.getAuth().get("metadata") instanceof Map) {
                    Map metadata = (Map)response.getAuth().get("metadata");
                    logger.debug((Object)String.format("Login successful using AWS-IAM authentication for user id %s, ARN %s", metadata.get("client_user_id"), metadata.get("canonical_arn")));
                } else {
                    logger.debug((Object)"Login successful using AWS-IAM authentication");
                }
            }
            return LoginTokenUtil.from(response.getAuth());
        }
        catch (RestClientException e) {
            throw VaultLoginException.create("AWS-IAM", e);
        }
    }

    protected static Map<String, String> createRequestBody(AwsIamAuthenticationOptions options) {
        return AwsIamAuthentication.createRequestBody(options, options.getCredentialsProvider().resolveCredentials(), options.getRegionProvider().getRegion());
    }

    private static Map<String, String> createRequestBody(AwsIamAuthenticationOptions options, AwsCredentials credentials, Region region) {
        HashMap<String, String> login = new HashMap<String, String>();
        login.put("iam_http_request_method", "POST");
        login.put("iam_request_url", Base64Utils.encodeToString((byte[])options.getEndpointUri().toString().getBytes()));
        login.put("iam_request_body", REQUEST_BODY_BASE64_ENCODED);
        String headerJson = AwsIamAuthentication.getSignedHeaders(options, credentials, region);
        login.put("iam_request_headers", Base64Utils.encodeToString((byte[])headerJson.getBytes()));
        if (!ObjectUtils.isEmpty((Object)options.getRole())) {
            login.put("role", options.getRole());
        }
        return login;
    }

    private static String getSignedHeaders(AwsIamAuthenticationOptions options, AwsCredentials credentials, Region region) {
        Map<String, List<String>> headers = AwsIamAuthentication.createIamRequestHeaders(options);
        SdkHttpFullRequest.Builder builder = SdkHttpFullRequest.builder().contentStreamProvider(() -> new ByteArrayInputStream(REQUEST_BODY.getBytes())).headers(headers).method(SdkHttpMethod.POST).uri(options.getEndpointUri());
        SdkHttpFullRequest request = builder.build();
        Aws4Signer signer = Aws4Signer.create();
        Aws4SignerParams signerParams = Aws4SignerParams.builder().awsCredentials(credentials).signingName("sts").signingRegion(region).build();
        SdkHttpFullRequest signedRequest = signer.sign(request, signerParams);
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry entry : signedRequest.headers().entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize headers to JSON", e);
        }
    }

    private static Map<String, List<String>> createIamRequestHeaders(AwsIamAuthenticationOptions options) {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        headers.put("Content-Length", Collections.singletonList("" + REQUEST_BODY.length()));
        headers.put("Content-Type", Collections.singletonList("application/x-www-form-urlencoded"));
        if (StringUtils.hasText((String)options.getServerId())) {
            headers.put("X-Vault-AWS-IAM-Server-ID", Collections.singletonList(options.getServerId()));
        }
        return headers;
    }
}

