/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.support.Hmac;
import org.springframework.vault.support.Plaintext;
import org.springframework.vault.support.Signature;

public class VaultSignatureVerificationRequest {
    private final Plaintext plaintext;
    @Nullable
    private final Signature signature;
    @Nullable
    private final Hmac hmac;
    @Nullable
    private final String hashAlgorithm;
    @Nullable
    private final String signatureAlgorithm;

    private VaultSignatureVerificationRequest(Plaintext plaintext, @Nullable Signature signature, @Nullable Hmac hmac, @Nullable String hashAlgorithm, @Nullable String signatureAlgorithm) {
        this.plaintext = plaintext;
        this.signature = signature;
        this.hmac = hmac;
        this.hashAlgorithm = hashAlgorithm;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public static VaultSignatureVerificationRequestBuilder builder() {
        return new VaultSignatureVerificationRequestBuilder();
    }

    public static VaultSignatureVerificationRequest create(Plaintext plaintext, Signature signature) {
        return VaultSignatureVerificationRequest.builder().plaintext(plaintext).signature(signature).build();
    }

    public static VaultSignatureVerificationRequest create(Plaintext plaintext, Hmac hmac) {
        return VaultSignatureVerificationRequest.builder().plaintext(plaintext).hmac(hmac).build();
    }

    public Plaintext getPlaintext() {
        return this.plaintext;
    }

    @Nullable
    public Signature getSignature() {
        return this.signature;
    }

    @Nullable
    public Hmac getHmac() {
        return this.hmac;
    }

    @Nullable
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Nullable
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Nullable
    @Deprecated(since="2.4")
    public String getAlgorithm() {
        return this.getSignatureAlgorithm();
    }

    public static class VaultSignatureVerificationRequestBuilder {
        @Nullable
        private Plaintext input;
        @Nullable
        private Signature signature;
        @Nullable
        private Hmac hmac;
        @Nullable
        private String hashAlgorithm;
        @Nullable
        private String signatureAlgorithm;

        public VaultSignatureVerificationRequestBuilder plaintext(Plaintext input) {
            Assert.notNull((Object)input, (String)"Plaintext must not be null");
            this.input = input;
            return this;
        }

        public VaultSignatureVerificationRequestBuilder signature(Signature signature) {
            Assert.notNull((Object)signature, (String)"Signature must not be null");
            this.hmac = null;
            this.signature = signature;
            return this;
        }

        public VaultSignatureVerificationRequestBuilder hmac(Hmac hmac) {
            Assert.notNull((Object)hmac, (String)"HMAC must not be null");
            this.signature = null;
            this.hmac = hmac;
            return this;
        }

        public VaultSignatureVerificationRequestBuilder hashAlgorithm(String hashAlgorithm) {
            Assert.hasText((String)hashAlgorithm, (String)"Hash algorithm must not be null or empty");
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public VaultSignatureVerificationRequestBuilder signatureAlgorithm(String signatureAlgorithm) {
            Assert.hasText((String)signatureAlgorithm, (String)"Signature algorithm must not be null or empty");
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        @Deprecated(since="2.4")
        public VaultSignatureVerificationRequestBuilder algorithm(String algorithm) {
            return this.signatureAlgorithm(algorithm);
        }

        public VaultSignatureVerificationRequest build() {
            Assert.notNull((Object)this.input, (String)"Plaintext input must not be null");
            Assert.isTrue((this.hmac != null || this.signature != null ? 1 : 0) != 0, (String)"Either Signature or Hmac must not be null");
            return new VaultSignatureVerificationRequest(this.input, this.signature, this.hmac, this.hashAlgorithm, this.signatureAlgorithm);
        }
    }
}

