/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.DerbySqlAstTranslator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.function.CaseLeastGreatestEmulation;
import org.hibernate.dialect.function.CastingConcatFunction;
import org.hibernate.dialect.function.ChrLiteralEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.DerbyLpadEmulation;
import org.hibernate.dialect.function.DerbyRpadEmulation;
import org.hibernate.dialect.function.InsertSubstringOverlayEmulation;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.DerbyLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DerbySequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDerbyDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.BigDecimalJavaType;
import org.hibernate.type.descriptor.jdbc.DecimalJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullResolvingJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DerbyDialect
extends Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(10, 15, 2);
    private final LimitHandler limitHandler = new DerbyLimitHandler(true);
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate(this);

    public DerbyDialect() {
        this(MINIMUM_VERSION);
    }

    public DerbyDialect(DatabaseVersion version) {
        super(version);
    }

    public DerbyDialect(DialectResolutionInfo info) {
        super(info);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case 2: {
                return this.columnType(3);
            }
            case -3: {
                return "varchar($l) for bit data";
            }
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
            case 2004: {
                return "blob";
            }
            case 2005: 
            case 2011: {
                return "clob";
            }
            case 92: 
            case 2013: {
                return "time";
            }
            case 93: 
            case 2014: {
                return "timestamp";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        int varcharDdlTypeCapacity = 32672;
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-3, this.isLob(4003) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE, this.columnType(4003), this.columnType(-3), (Dialect)this).withTypeCapacity(varcharDdlTypeCapacity, this.columnType(-3)).build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(12, this.isLob(4001) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE, this.columnType(4001), this.columnType(12), (Dialect)this).withTypeCapacity(varcharDdlTypeCapacity, this.columnType(12)).build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-9, this.isLob(4002) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE, this.columnType(4001), this.columnType(-9), (Dialect)this).withTypeCapacity(varcharDdlTypeCapacity, this.columnType(-9)).build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-2, this.isLob(4003) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE, this.columnType(4003), this.columnType(-3), (Dialect)this).withTypeCapacity(254L, "char($l) for bit data").withTypeCapacity(varcharDdlTypeCapacity, this.columnType(-3)).build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(1, this.isLob(4001) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE, this.columnType(4001), this.columnType(1), (Dialect)this).withTypeCapacity(254L, this.columnType(1)).withTypeCapacity(this.getMaxVarcharLength(), this.columnType(12)).build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-15, this.isLob(4002) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE, this.columnType(4002), this.columnType(-15), (Dialect)this).withTypeCapacity(254L, this.columnType(-15)).withTypeCapacity(this.getMaxVarcharLength(), this.columnType(-9)).build());
    }

    @Override
    public int getMaxVarcharLength() {
        return 32672;
    }

    @Override
    public int getMaxVarcharCapacity() {
        return 32700;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 31;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    @Override
    public int getFloatPrecision() {
        return 23;
    }

    @Override
    public int getDoublePrecision() {
        return 52;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType<String> stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        DdlTypeRegistry ddlTypeRegistry = functionContributions.getTypeConfiguration().getDdlTypeRegistry();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.aggregates(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionContributions.getFunctionRegistry().register("count", new CountFunction(this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, "||", ddlTypeRegistry.getDescriptor(12).getCastTypeName(Size.nil(), stringType, ddlTypeRegistry), true));
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.DEFAULT);
        functionContributions.getFunctionRegistry().register("chr", new ChrLiteralEmulation(functionContributions.getTypeConfiguration()));
        functionFactory.concat_pipeOperator();
        functionFactory.cot();
        functionFactory.degrees();
        functionFactory.radians();
        functionFactory.log10();
        functionFactory.sinh();
        functionFactory.cosh();
        functionFactory.tanh();
        functionFactory.pi();
        functionFactory.rand();
        functionFactory.trim1();
        functionFactory.hourMinuteSecond();
        functionFactory.yearMonthDay();
        functionFactory.varPopSamp();
        functionFactory.stddevPopSamp();
        functionFactory.substring_substr();
        functionFactory.leftRight_substrLength();
        functionFactory.characterLength_length(SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.power_expLn();
        functionFactory.round_floor();
        functionFactory.trunc_floor();
        functionFactory.octetLength_pattern("length(?1)");
        functionFactory.bitLength_pattern("length(?1)*8");
        functionContributions.getFunctionRegistry().register("concat", new CastingConcatFunction(this, "||", true, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("lpad", new DerbyLpadEmulation(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("rpad", new DerbyRpadEmulation(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("least", new CaseLeastGreatestEmulation(true));
        functionContributions.getFunctionRegistry().register("greatest", new CaseLeastGreatestEmulation(false));
        functionContributions.getFunctionRegistry().register("overlay", new InsertSubstringOverlayEmulation(functionContributions.getTypeConfiguration(), true));
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DerbySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
            case DAY_OF_YEAR: {
                return "({fn timestampdiff(sql_tsi_day,date(char(year(?2),4)||'-01-01'),?2)}+1)";
            }
            case DAY_OF_WEEK: {
                return "(mod(mod({fn timestampdiff(sql_tsi_day,{d '1970-01-01'},?2)}+4,7)+7,7)+1)";
            }
            case WEEK: {
                return "(({fn timestampdiff(sql_tsi_day,date(char(year(?2),4)||'-01-01'),{fn timestampadd(sql_tsi_day,{fn timestampdiff(sql_tsi_day,{d '1753-01-01'},?2)}/7*7,{d '1753-01-04'})})}+7)/7)";
            }
            case QUARTER: {
                return "((month(?2)+2)/3)";
            }
            case EPOCH: {
                return "{fn timestampdiff(sql_tsi_second,{ts '1970-01-01 00:00:00'},?2)}";
            }
        }
        return "?1(?2)";
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: 
            case WEEK: {
                throw new UnsupportedOperationException("field type not supported on Derby: " + unit);
            }
            case DAY_OF_MONTH: {
                return "day";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case FLOAT: {
                return "cast(double(?1) as real)";
            }
            case DOUBLE: {
                return "double(?1)";
            }
            case STRING: {
                switch (from) {
                    case FLOAT: 
                    case DOUBLE: {
                        return "cast(trim(cast(cast(?1 as decimal(" + this.getDefaultDecimalPrecision() + "," + BigDecimalJavaType.INSTANCE.getDefaultSqlScale(this, null) + ")) as char(254))) as ?2)";
                    }
                    case INTEGER: 
                    case LONG: 
                    case FIXED: {
                        return "cast(trim(cast(?1 as char(254))) as ?2)";
                    }
                    case DATE: {
                        return "cast(?1 as varchar(10))";
                    }
                    case TIME: {
                        return "cast(?1 as varchar(8))";
                    }
                    case TIMESTAMP: {
                        return "cast(?1 as varchar(30))";
                    }
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "{fn timestampadd(sql_tsi_frac_second,mod(bigint(?2),1000000000),{fn timestampadd(sql_tsi_second,bigint((?2)/1000000000),?3)})}";
            }
        }
        return "{fn timestampadd(sql_tsi_?1,bigint(?2),?3)}";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "{fn timestampdiff(sql_tsi_frac_second,?2,?3)}";
            }
        }
        return "{fn timestampdiff(sql_tsi_?1,?2,?3)}";
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return DerbySequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select sys.sysschemas.schemaname as sequence_schema,sys.syssequences.* from sys.syssequences left join sys.sysschemas on sys.syssequences.schemaid=sys.sysschemas.schemaid";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorDerbyDatabaseImpl.INSTANCE;
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName + " restrict"};
    }

    @Override
    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return DB2Dialect.selectNullString(sqlType);
    }

    @Override
    public boolean supportsCommentOn() {
        return false;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.NONE;
    }

    @Override
    public RowLockStrategy getReadRowLockStrategy() {
        return RowLockStrategy.NONE;
    }

    @Override
    public String getForUpdateString() {
        return " for update with rs";
    }

    @Override
    public String getWriteLockString(int timeout) {
        return " for update with rs";
    }

    @Override
    public String getReadLockString(int timeout) {
        return " for read only with rs";
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return DB2IdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public boolean supportsOrderByInSubquery() {
        return true;
    }

    @Override
    public boolean requiresCastForConcatenatingNonStrings() {
        return true;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2, DecimalJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2014, TimestampJdbcType.INSTANCE);
        typeContributions.contributeJdbcType(ObjectNullResolvingJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullResolvingJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 512;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "40XL1": 
                    case "40XL2": {
                        throw new LockTimeoutException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("format() function not supported on Derby");
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("ADD");
        this.registerKeyword("ALL");
        this.registerKeyword("ALLOCATE");
        this.registerKeyword("ALTER");
        this.registerKeyword("AND");
        this.registerKeyword("ANY");
        this.registerKeyword("ARE");
        this.registerKeyword("AS");
        this.registerKeyword("ASC");
        this.registerKeyword("ASSERTION");
        this.registerKeyword("AT");
        this.registerKeyword("AUTHORIZATION");
        this.registerKeyword("AVG");
        this.registerKeyword("BEGIN");
        this.registerKeyword("BETWEEN");
        this.registerKeyword("BIT");
        this.registerKeyword("BOOLEAN");
        this.registerKeyword("BOTH");
        this.registerKeyword("BY");
        this.registerKeyword("CALL");
        this.registerKeyword("CASCADE");
        this.registerKeyword("CASCADED");
        this.registerKeyword("CASE");
        this.registerKeyword("CAST");
        this.registerKeyword("CHAR");
        this.registerKeyword("CHARACTER");
        this.registerKeyword("CHECK");
        this.registerKeyword("CLOSE");
        this.registerKeyword("COLLATE");
        this.registerKeyword("COLLATION");
        this.registerKeyword("COLUMN");
        this.registerKeyword("COMMIT");
        this.registerKeyword("CONNECT");
        this.registerKeyword("CONNECTION");
        this.registerKeyword("CONSTRAINT");
        this.registerKeyword("CONSTRAINTS");
        this.registerKeyword("CONTINUE");
        this.registerKeyword("CONVERT");
        this.registerKeyword("CORRESPONDING");
        this.registerKeyword("COUNT");
        this.registerKeyword("CREATE");
        this.registerKeyword("CURRENT");
        this.registerKeyword("CURRENT_DATE");
        this.registerKeyword("CURRENT_TIME");
        this.registerKeyword("CURRENT_TIMESTAMP");
        this.registerKeyword("CURRENT_USER");
        this.registerKeyword("CURSOR");
        this.registerKeyword("DEALLOCATE");
        this.registerKeyword("DEC");
        this.registerKeyword("DECIMAL");
        this.registerKeyword("DECLARE");
        this.registerKeyword("DEFERRABLE");
        this.registerKeyword("DEFERRED");
        this.registerKeyword("DELETE");
        this.registerKeyword("DESC");
        this.registerKeyword("DESCRIBE");
        this.registerKeyword("DIAGNOSTICS");
        this.registerKeyword("DISCONNECT");
        this.registerKeyword("DISTINCT");
        this.registerKeyword("DOUBLE");
        this.registerKeyword("DROP");
        this.registerKeyword("ELSE");
        this.registerKeyword("END");
        this.registerKeyword("ENDEXEC");
        this.registerKeyword("ESCAPE");
        this.registerKeyword("EXCEPT");
        this.registerKeyword("EXCEPTION");
        this.registerKeyword("EXEC");
        this.registerKeyword("EXECUTE");
        this.registerKeyword("EXISTS");
        this.registerKeyword("EXPLAIN");
        this.registerKeyword("EXTERNAL");
        this.registerKeyword("FALSE");
        this.registerKeyword("FETCH");
        this.registerKeyword("FIRST");
        this.registerKeyword("FLOAT");
        this.registerKeyword("FOR");
        this.registerKeyword("FOREIGN");
        this.registerKeyword("FOUND");
        this.registerKeyword("FROM");
        this.registerKeyword("FULL");
        this.registerKeyword("FUNCTION");
        this.registerKeyword("GET");
        this.registerKeyword("GET_CURRENT_CONNECTION");
        this.registerKeyword("GLOBAL");
        this.registerKeyword("GO");
        this.registerKeyword("GOTO");
        this.registerKeyword("GRANT");
        this.registerKeyword("GROUP");
        this.registerKeyword("HAVING");
        this.registerKeyword("HOUR");
        this.registerKeyword("IDENTITY");
        this.registerKeyword("IMMEDIATE");
        this.registerKeyword("IN");
        this.registerKeyword("INDICATOR");
        this.registerKeyword("INITIALLY");
        this.registerKeyword("INNER");
        this.registerKeyword("INOUT");
        this.registerKeyword("INPUT");
        this.registerKeyword("INSENSITIVE");
        this.registerKeyword("INSERT");
        this.registerKeyword("INT");
        this.registerKeyword("INTEGER");
        this.registerKeyword("INTERSECT");
        this.registerKeyword("INTO");
        this.registerKeyword("IS");
        this.registerKeyword("ISOLATION");
        this.registerKeyword("JOIN");
        this.registerKeyword("KEY");
        this.registerKeyword("LAST");
        this.registerKeyword("LEFT");
        this.registerKeyword("LIKE");
        this.registerKeyword("LONGINT");
        this.registerKeyword("LOWER");
        this.registerKeyword("LTRIM");
        this.registerKeyword("MATCH");
        this.registerKeyword("MAX");
        this.registerKeyword("MIN");
        this.registerKeyword("MINUTE");
        this.registerKeyword("NATIONAL");
        this.registerKeyword("NATURAL");
        this.registerKeyword("NCHAR");
        this.registerKeyword("NVARCHAR");
        this.registerKeyword("NEXT");
        this.registerKeyword("NO");
        this.registerKeyword("NOT");
        this.registerKeyword("NULL");
        this.registerKeyword("NULLIF");
        this.registerKeyword("NUMERIC");
        this.registerKeyword("OF");
        this.registerKeyword("ON");
        this.registerKeyword("ONLY");
        this.registerKeyword("OPEN");
        this.registerKeyword("OPTION");
        this.registerKeyword("OR");
        this.registerKeyword("ORDER");
        this.registerKeyword("OUT");
        this.registerKeyword("OUTER");
        this.registerKeyword("OUTPUT");
        this.registerKeyword("OVERLAPS");
        this.registerKeyword("PAD");
        this.registerKeyword("PARTIAL");
        this.registerKeyword("PREPARE");
        this.registerKeyword("PRESERVE");
        this.registerKeyword("PRIMARY");
        this.registerKeyword("PRIOR");
        this.registerKeyword("PRIVILEGES");
        this.registerKeyword("PROCEDURE");
        this.registerKeyword("PUBLIC");
        this.registerKeyword("READ");
        this.registerKeyword("REAL");
        this.registerKeyword("REFERENCES");
        this.registerKeyword("RELATIVE");
        this.registerKeyword("RESTRICT");
        this.registerKeyword("REVOKE");
        this.registerKeyword("RIGHT");
        this.registerKeyword("ROLLBACK");
        this.registerKeyword("ROWS");
        this.registerKeyword("RTRIM");
        this.registerKeyword("SCHEMA");
        this.registerKeyword("SCROLL");
        this.registerKeyword("SECOND");
        this.registerKeyword("SELECT");
        this.registerKeyword("SESSION_USER");
        this.registerKeyword("SET");
        this.registerKeyword("SMALLINT");
        this.registerKeyword("SOME");
        this.registerKeyword("SPACE");
        this.registerKeyword("SQL");
        this.registerKeyword("SQLCODE");
        this.registerKeyword("SQLERROR");
        this.registerKeyword("SQLSTATE");
        this.registerKeyword("SUBSTR");
        this.registerKeyword("SUBSTRING");
        this.registerKeyword("SUM");
        this.registerKeyword("SYSTEM_USER");
        this.registerKeyword("TABLE");
        this.registerKeyword("TEMPORARY");
        this.registerKeyword("TIMEZONE_HOUR");
        this.registerKeyword("TIMEZONE_MINUTE");
        this.registerKeyword("TO");
        this.registerKeyword("TRAILING");
        this.registerKeyword("TRANSACTION");
        this.registerKeyword("TRANSLATE");
        this.registerKeyword("TRANSLATION");
        this.registerKeyword("TRUE");
        this.registerKeyword("UNION");
        this.registerKeyword("UNIQUE");
        this.registerKeyword("UNKNOWN");
        this.registerKeyword("UPDATE");
        this.registerKeyword("UPPER");
        this.registerKeyword("USER");
        this.registerKeyword("USING");
        this.registerKeyword("VALUES");
        this.registerKeyword("VARCHAR");
        this.registerKeyword("VARYING");
        this.registerKeyword("VIEW");
        this.registerKeyword("WHENEVER");
        this.registerKeyword("WHERE");
        this.registerKeyword("WITH");
        this.registerKeyword("WORK");
        this.registerKeyword("WRITE");
        this.registerKeyword("XML");
        this.registerKeyword("XMLEXISTS");
        this.registerKeyword("XMLPARSE");
        this.registerKeyword("XMLSERIALIZE");
        this.registerKeyword("YEAR");
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(rootEntityDescriptor, basename -> "session.HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(rootEntityDescriptor, name -> "session.HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public String getTemporaryTableCreateOptions() {
        return "not logged";
    }

    @Override
    public boolean supportsTemporaryTablePrimaryKey() {
        return false;
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return "declare global temporary table";
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public boolean supportsPartitionBy() {
        return false;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }
}

