/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformResolver;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class JtaPlatformInitiator
implements StandardServiceInitiator<JtaPlatform> {
    public static final @UnknownKeyFor @NonNull @Initialized JtaPlatformInitiator INSTANCE = new JtaPlatformInitiator();
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JtaPlatformInitiator.class.getName());

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized JtaPlatform> getServiceInitiated() {
        return JtaPlatform.class;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JtaPlatform initiateService(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> configurationValues, @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor registry) {
        Object setting = configurationValues.get("hibernate.transaction.jta.platform");
        JtaPlatform platform = NullnessUtil.castNonNull(registry.getService(StrategySelector.class)).resolveStrategy(JtaPlatform.class, setting);
        if (platform == null) {
            LOG.debug("No JtaPlatform was specified, checking resolver");
            platform = NullnessUtil.castNonNull(registry.getService(JtaPlatformResolver.class)).resolveJtaPlatform(configurationValues, registry);
        }
        if (platform == null) {
            LOG.debug("No JtaPlatform was specified, checking resolver");
            platform = this.getFallbackProvider(configurationValues, registry);
        }
        if (platform != null && !(platform instanceof NoJtaPlatform)) {
            LOG.usingJtaPlatform(platform.getClass().getName());
        } else {
            LOG.noJtaPlatform();
        }
        return platform;
    }

    protected @Nullable @UnknownKeyFor @Initialized JtaPlatform getFallbackProvider(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> configurationValues, @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor registry) {
        return null;
    }
}

