/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPath;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;

public class AnyDiscriminatorPathInterpretation<T>
extends AbstractSqmPathInterpretation<T> {
    private final Expression expression;

    public static <T> AnyDiscriminatorPathInterpretation<T> from(AnyDiscriminatorSqmPath<?> sqmPath, SqmToSqlAstConverter converter) {
        DiscriminatedAssociationModelPart mapping;
        JpaPath lhs = sqmPath.getLhs();
        TableGroup tableGroup = converter.getFromClauseAccess().findTableGroup(lhs.getNavigablePath());
        ModelPartContainer subPart = tableGroup.getModelPart();
        if (subPart instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)subPart;
            mapping = (DiscriminatedAssociationModelPart)((Object)pluralAttributeMapping.getElementDescriptor());
        } else {
            mapping = (DiscriminatedAssociationModelPart)subPart;
        }
        TableReference tableReference = tableGroup.getPrimaryTableReference();
        Expression expression = converter.getSqlExpressionResolver().resolveSqlExpression(tableReference, mapping.getDiscriminatorPart());
        return new AnyDiscriminatorPathInterpretation<T>(sqmPath.getNavigablePath(), mapping.getDiscriminatorMapping(), tableGroup, expression);
    }

    public AnyDiscriminatorPathInterpretation(NavigablePath navigablePath, ModelPart mapping, TableGroup tableGroup, Expression expression) {
        super(navigablePath, mapping, tableGroup);
        this.expression = expression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.expression.accept(sqlTreeWalker);
    }
}

