/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmSummarization<T>
extends AbstractSqmExpression<T> {
    private final Kind kind;
    private final List<SqmExpression<?>> groupings;

    public SqmSummarization(Kind kind, List<SqmExpression<?>> groupings, NodeBuilder criteriaBuilder) {
        super(null, criteriaBuilder);
        this.kind = kind;
        this.groupings = groupings;
    }

    @Override
    public SqmSummarization<T> copy(SqmCopyContext context) {
        SqmSummarization existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList groupings = new ArrayList(this.groupings.size());
        for (SqmExpression<?> grouping : this.groupings) {
            groupings.add((SqmExpression<?>)grouping.copy(context));
        }
        SqmSummarization<T> expression = context.registerCopy(this, new SqmSummarization<T>(this.kind, groupings, this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    public Kind getKind() {
        return this.kind;
    }

    public List<SqmExpression<?>> getGroupings() {
        return this.groupings;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitSummarization(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append((Object)this.kind);
        sb.append(" (");
        this.groupings.get(0).appendHqlString(sb);
        for (int i = 1; i < this.groupings.size(); ++i) {
            sb.append(", ");
            this.groupings.get(i).appendHqlString(sb);
        }
        sb.append(')');
    }

    public static enum Kind {
        ROLLUP,
        CUBE;

    }
}

