/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;

public abstract class AbstractNonLazyEntityFetch
extends AbstractFetchParent
implements EntityFetch {
    private final FetchParent fetchParent;
    private final EntityValuedFetchable fetchContainer;

    public AbstractNonLazyEntityFetch(FetchParent fetchParent, EntityValuedFetchable fetchedPart, NavigablePath navigablePath) {
        super(navigablePath);
        this.fetchContainer = fetchedPart;
        this.fetchParent = fetchParent;
    }

    @Override
    public EntityValuedFetchable getEntityValuedModelPart() {
        return this.fetchContainer;
    }

    @Override
    public FetchableContainer getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public EntityValuedFetchable getReferencedModePart() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public EntityValuedFetchable getReferencedMappingType() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public EntityMappingType getReferencedMappingContainer() {
        return this.getEntityValuedModelPart().getEntityMappingType();
    }

    @Override
    public EntityValuedFetchable getFetchedMapping() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public DomainResultAssembler<?> createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EntityInitializer entityInitializer = this.getEntityInitializer(parentAccess, creationState);
        return this.buildEntityAssembler(entityInitializer);
    }

    protected EntityAssembler buildEntityAssembler(EntityInitializer entityInitializer) {
        return new EntityAssembler(this.getFetchedMapping().getJavaType(), entityInitializer);
    }

    protected abstract EntityInitializer getEntityInitializer(FetchParentAccess var1, AssemblerCreationState var2);
}

