/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class StringJavaType
extends AbstractClassJavaType<String> {
    public static final StringJavaType INSTANCE = new StringJavaType();

    public StringJavaType() {
        super(String.class);
    }

    @Override
    public String toString(String value) {
        return value;
    }

    @Override
    public String fromString(CharSequence string) {
        return string.toString();
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators stdIndicators) {
        TypeConfiguration typeConfiguration = stdIndicators.getTypeConfiguration();
        JdbcTypeRegistry stdRegistry = typeConfiguration.getJdbcTypeRegistry();
        if (stdIndicators.isLob()) {
            return stdIndicators.isNationalized() ? stdRegistry.getDescriptor(2011) : stdRegistry.getDescriptor(2005);
        }
        if (stdIndicators.isNationalized()) {
            return stdRegistry.getDescriptor(-9);
        }
        return super.getRecommendedJdbcType(stdIndicators);
    }

    @Override
    public <X> X unwrap(String value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Reader.class.isAssignableFrom(type)) {
            return (X)new StringReader(value);
        }
        if (CharacterStream.class.isAssignableFrom(type)) {
            return (X)new CharacterStreamImpl(value);
        }
        if (DataHelper.isNClob(type)) {
            return (X)options.getLobCreator().createNClob(value);
        }
        if (Clob.class.isAssignableFrom(type)) {
            return (X)options.getLobCreator().createClob(value);
        }
        if (Integer.class.isAssignableFrom(type)) {
            Integer parsed = Integer.parseInt(value);
            return (X)parsed;
        }
        if (Long.class.isAssignableFrom(type)) {
            Long parsed = Long.parseLong(value);
            return (X)parsed;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> String wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof char[]) {
            return new String((char[])value);
        }
        if (value instanceof Reader) {
            return DataHelper.extractString((Reader)value);
        }
        if (value instanceof Clob) {
            return DataHelper.extractString((Clob)value);
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value.toString();
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        switch (javaType.getJavaType().getTypeName()) {
            case "char": 
            case "char[]": 
            case "java.lang.Character": 
            case "java.lang.Character[]": {
                return true;
            }
        }
        return false;
    }

    @Override
    public <X> String coerce(X value, JavaType.CoercionContext coercionContext) {
        return this.wrap((Object)value, (WrapperOptions)null);
    }
}

