/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.core.io.InputStreamSource;
import org.springframework.util.Assert;

public class FileSystemGeneratedFiles
implements GeneratedFiles {
    private final Function<GeneratedFiles.Kind, Path> roots;

    public FileSystemGeneratedFiles(Path root) {
        this(FileSystemGeneratedFiles.conventionRoots(root));
    }

    public FileSystemGeneratedFiles(Function<GeneratedFiles.Kind, Path> roots) {
        Assert.notNull(roots, "'roots' must not be null");
        Assert.isTrue(Arrays.stream(GeneratedFiles.Kind.values()).map(roots).noneMatch(Objects::isNull), "'roots' must return a value for all file kinds");
        this.roots = roots;
    }

    private static Function<GeneratedFiles.Kind, Path> conventionRoots(Path root) {
        Assert.notNull((Object)root, "'root' must not be null");
        return kind -> switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case GeneratedFiles.Kind.SOURCE -> root.resolve("sources");
            case GeneratedFiles.Kind.RESOURCE -> root.resolve("resources");
            case GeneratedFiles.Kind.CLASS -> root.resolve("classes");
        };
    }

    @Override
    public void addFile(GeneratedFiles.Kind kind, String path, InputStreamSource content) {
        Assert.notNull((Object)kind, "'kind' must not be null");
        Assert.hasLength(path, "'path' must not be empty");
        Assert.notNull((Object)content, "'content' must not be null");
        Path root = this.roots.apply(kind).toAbsolutePath().normalize();
        Path relativePath = root.resolve(path).toAbsolutePath().normalize();
        Assert.isTrue(relativePath.startsWith(root), "'path' must be relative");
        try (InputStream inputStream = content.getInputStream();){
            Files.createDirectories(relativePath.getParent(), new FileAttribute[0]);
            Files.copy(inputStream, relativePath, new CopyOption[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

