/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.regex.Pattern;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

class ExpressionBasedStringQuery
extends StringQuery {
    private static final String EXPRESSION_PARAMETER = "$1#{";
    private static final String QUOTED_EXPRESSION_PARAMETER = "$1__HASH__{";
    private static final Pattern EXPRESSION_PARAMETER_QUOTING = Pattern.compile("([:?])#\\{");
    private static final Pattern EXPRESSION_PARAMETER_UNQUOTING = Pattern.compile("([:?])__HASH__\\{");
    private static final String ENTITY_NAME = "entityName";
    private static final String ENTITY_NAME_VARIABLE = "#entityName";
    private static final String ENTITY_NAME_VARIABLE_EXPRESSION = "#{#entityName";

    public ExpressionBasedStringQuery(String query, JpaEntityMetadata<?> metadata, SpelExpressionParser parser, boolean nativeQuery) {
        super(ExpressionBasedStringQuery.renderQueryIfExpressionOrReturnQuery(query, metadata, parser), nativeQuery && !ExpressionBasedStringQuery.containsExpression(query));
    }

    static ExpressionBasedStringQuery from(DeclaredQuery query, JpaEntityMetadata<?> metadata, SpelExpressionParser parser, boolean nativeQuery) {
        return new ExpressionBasedStringQuery(query.getQueryString(), metadata, parser, nativeQuery);
    }

    private static String renderQueryIfExpressionOrReturnQuery(String query, JpaEntityMetadata<?> metadata, SpelExpressionParser parser) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(metadata, (String)"metadata must not be null");
        Assert.notNull((Object)parser, (String)"parser must not be null");
        if (!ExpressionBasedStringQuery.containsExpression(query)) {
            return query;
        }
        StandardEvaluationContext evalContext = new StandardEvaluationContext();
        evalContext.setVariable(ENTITY_NAME, (Object)metadata.getEntityName());
        query = ExpressionBasedStringQuery.potentiallyQuoteExpressionsParameter(query);
        Expression expr = parser.parseExpression(query, ParserContext.TEMPLATE_EXPRESSION);
        String result = (String)expr.getValue((EvaluationContext)evalContext, String.class);
        if (result == null) {
            return query;
        }
        return ExpressionBasedStringQuery.potentiallyUnquoteParameterExpressions(result);
    }

    private static String potentiallyUnquoteParameterExpressions(String result) {
        return EXPRESSION_PARAMETER_UNQUOTING.matcher(result).replaceAll(EXPRESSION_PARAMETER);
    }

    private static String potentiallyQuoteExpressionsParameter(String query) {
        return EXPRESSION_PARAMETER_QUOTING.matcher(query).replaceAll(QUOTED_EXPRESSION_PARAMETER);
    }

    private static boolean containsExpression(String query) {
        return query.contains(ENTITY_NAME_VARIABLE_EXPRESSION);
    }
}

