/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.Query;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.jpa.repository.query.CollectionUtils;
import org.springframework.data.jpa.repository.query.KeysetScrollDelegate;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.util.Assert;

public class ScrollDelegate<T> {
    private final JpaEntityInformation<T, ?> entity;

    protected ScrollDelegate(JpaEntityInformation<T, ?> entity) {
        this.entity = entity;
    }

    /*
     * WARNING - void declaration
     */
    public Window<T> scroll(Query query, Sort sort, ScrollPosition scrollPosition) {
        Assert.notNull((Object)scrollPosition, (String)"ScrollPosition must not be null");
        int limit = query.getMaxResults();
        if (limit > 0 && limit != Integer.MAX_VALUE) {
            query = query.setMaxResults(limit + 1);
        }
        List result = query.getResultList();
        ScrollPosition scrollPosition2 = scrollPosition;
        if (scrollPosition2 instanceof KeysetScrollPosition) {
            void keyset;
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)scrollPosition2;
            KeysetScrollPosition cfr_ignored_0 = (KeysetScrollPosition)scrollPosition2;
            return ScrollDelegate.createWindow(sort, limit, keyset.getDirection(), this.entity, result);
        }
        ScrollPosition scrollPosition3 = scrollPosition;
        if (scrollPosition3 instanceof OffsetScrollPosition) {
            void offset;
            OffsetScrollPosition offsetScrollPosition = (OffsetScrollPosition)scrollPosition3;
            OffsetScrollPosition cfr_ignored_1 = (OffsetScrollPosition)scrollPosition3;
            return ScrollDelegate.createWindow(result, limit, OffsetScrollPosition.positionFunction((long)offset.getOffset()));
        }
        throw new UnsupportedOperationException("ScrollPosition " + String.valueOf(scrollPosition) + " not supported");
    }

    private static <T> Window<T> createWindow(Sort sort, int limit, ScrollPosition.Direction direction, JpaEntityInformation<T, ?> entity, List<T> result) {
        KeysetScrollDelegate delegate = KeysetScrollDelegate.of(direction);
        List resultsToUse = delegate.getResultWindow(delegate.postProcessResults(result), limit);
        IntFunction<ScrollPosition> positionFunction = value -> {
            Object object = resultsToUse.get(value);
            Map<String, Object> keys = entity.getKeyset(sort.stream().map(Sort.Order::getProperty).toList(), object);
            return ScrollPosition.of(keys, (ScrollPosition.Direction)direction);
        };
        return Window.from(resultsToUse, positionFunction, (boolean)ScrollDelegate.hasMoreElements(result, limit));
    }

    private static <T> Window<T> createWindow(List<T> result, int limit, IntFunction<? extends ScrollPosition> positionFunction) {
        return Window.from(CollectionUtils.getFirst(limit, result), positionFunction, (boolean)ScrollDelegate.hasMoreElements(result, limit));
    }

    private static boolean hasMoreElements(List<?> result, int limit) {
        return !result.isEmpty() && result.size() > limit;
    }
}

