/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import jakarta.persistence.EntityManagerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public final class BeanDefinitionUtils {
    private static final String JNDI_OBJECT_FACTORY_BEAN = "org.springframework.jndi.JndiObjectFactoryBean";
    private static final List<Class<?>> EMF_TYPES;

    static {
        ArrayList<Class<JndiObjectFactoryBean>> types = new ArrayList<Class<JndiObjectFactoryBean>>();
        types.add(EntityManagerFactory.class);
        types.add(AbstractEntityManagerFactoryBean.class);
        if (ClassUtils.isPresent((String)JNDI_OBJECT_FACTORY_BEAN, (ClassLoader)ClassUtils.getDefaultClassLoader())) {
            types.add(JndiObjectFactoryBean.class);
        }
        EMF_TYPES = Collections.unmodifiableList(types);
    }

    private BeanDefinitionUtils() {
    }

    public static Iterable<String> getEntityManagerFactoryBeanNames(ListableBeanFactory beanFactory) {
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, EntityManagerFactory.class, (boolean)true, (boolean)false);
        HashSet<String> names = new HashSet<String>(Arrays.asList(beanNames));
        String[] stringArray = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, AbstractEntityManagerFactoryBean.class, (boolean)true, (boolean)false);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String factoryBeanName = stringArray[n2];
            names.add(BeanFactoryUtils.transformedBeanName((String)factoryBeanName));
            ++n2;
        }
        return names;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<EntityManagerFactoryBeanDefinition> getEntityManagerFactoryBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        HashSet<EntityManagerFactoryBeanDefinition> definitions = new HashSet<EntityManagerFactoryBeanDefinition>();
        for (Class<?> type : EMF_TYPES) {
            String[] stringArray = beanFactory.getBeanNamesForType(type, true, false);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                BeanDefinitionUtils.registerEntityManagerFactoryBeanDefinition(BeanFactoryUtils.transformedBeanName((String)name), beanFactory, definitions);
                ++n2;
            }
        }
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        BeanFactory beanFactory2 = parentBeanFactory;
        if (beanFactory2 instanceof ConfigurableListableBeanFactory) {
            void parentConfigurableListableBeanFactory;
            ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory2;
            ConfigurableListableBeanFactory cfr_ignored_0 = (ConfigurableListableBeanFactory)beanFactory2;
            definitions.addAll(BeanDefinitionUtils.getEntityManagerFactoryBeanDefinitions((ConfigurableListableBeanFactory)parentConfigurableListableBeanFactory));
        }
        return definitions;
    }

    private static void registerEntityManagerFactoryBeanDefinition(String name, ConfigurableListableBeanFactory beanFactory, Collection<EntityManagerFactoryBeanDefinition> definitions) {
        BeanDefinition definition = beanFactory.getBeanDefinition(name);
        if (JNDI_OBJECT_FACTORY_BEAN.equals(definition.getBeanClassName()) && !EntityManagerFactory.class.getName().equals(definition.getPropertyValues().get("expectedType"))) {
            return;
        }
        Class type = beanFactory.getType(name);
        if (type == null || !EntityManagerFactory.class.isAssignableFrom(type)) {
            return;
        }
        definitions.add(new EntityManagerFactoryBeanDefinition(name, beanFactory));
    }

    /*
     * WARNING - void declaration
     */
    public static BeanDefinition getBeanDefinition(String name, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(name);
        }
        catch (NoSuchBeanDefinitionException o_O) {
            BeanFactory parentBeanFactory;
            BeanFactory beanFactory2 = parentBeanFactory = beanFactory.getParentBeanFactory();
            if (beanFactory2 instanceof ConfigurableListableBeanFactory) {
                void parentConfigurableListableBeanFactory;
                ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory2;
                ConfigurableListableBeanFactory cfr_ignored_0 = (ConfigurableListableBeanFactory)beanFactory2;
                return BeanDefinitionUtils.getBeanDefinition(name, (ConfigurableListableBeanFactory)parentConfigurableListableBeanFactory);
            }
            throw o_O;
        }
    }

    public static class EntityManagerFactoryBeanDefinition {
        private final String beanName;
        private final ConfigurableListableBeanFactory beanFactory;

        public EntityManagerFactoryBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
            this.beanName = beanName;
            this.beanFactory = beanFactory;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public BeanFactory getBeanFactory() {
            return this.beanFactory;
        }

        public BeanDefinition getBeanDefinition() {
            return this.beanFactory.getBeanDefinition(this.beanName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EntityManagerFactoryBeanDefinition)) {
                return false;
            }
            EntityManagerFactoryBeanDefinition that = (EntityManagerFactoryBeanDefinition)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.beanName, (Object)that.beanName)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.beanFactory, (Object)that.beanFactory);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.beanName);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.beanFactory);
            return result;
        }
    }
}

