% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{csv_parse_options}
\alias{csv_parse_options}
\title{CSV Parsing Options}
\usage{
csv_parse_options(
  delimiter = ",",
  quoting = TRUE,
  quote_char = "\\"",
  double_quote = TRUE,
  escaping = FALSE,
  escape_char = "\\\\",
  newlines_in_values = FALSE,
  ignore_empty_lines = TRUE
)
}
\arguments{
\item{delimiter}{Field delimiting character}

\item{quoting}{Logical: are strings quoted?}

\item{quote_char}{Quoting character, if \code{quoting} is \code{TRUE}}

\item{double_quote}{Logical: are quotes inside values double-quoted?}

\item{escaping}{Logical: whether escaping is used}

\item{escape_char}{Escaping character, if \code{escaping} is \code{TRUE}}

\item{newlines_in_values}{Logical: are values allowed to contain CR (\code{0x0d})
and LF (\code{0x0a}) characters?}

\item{ignore_empty_lines}{Logical: should empty lines be ignored (default) or
generate a row of missing values (if \code{FALSE})?}
}
\description{
CSV Parsing Options
}
\examples{
\dontshow{if (arrow_with_dataset()) withAutoprint(\{ # examplesIf}
tf <- tempfile()
on.exit(unlink(tf))
writeLines("x\n1\n\n2", tf)
read_csv_arrow(tf, parse_options = csv_parse_options(ignore_empty_lines = FALSE))
open_csv_dataset(tf, parse_options = csv_parse_options(ignore_empty_lines = FALSE))
\dontshow{\}) # examplesIf}
}
