/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.dlog;

import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.common.BKCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.tools.perf.dlog.PerfReader;
import org.apache.bookkeeper.tools.perf.dlog.PerfReaderBase;
import org.apache.commons.configuration.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCommand
extends BKCommand<PerfReaderBase.Flags> {
    private static final Logger log = LoggerFactory.getLogger(ReadCommand.class);
    private static final String NAME = "read";
    private static final String DESC = "Read log records from distributedlog streams";

    public ReadCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new PerfReaderBase.Flags()).build());
    }

    protected boolean apply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags globalFlags, PerfReaderBase.Flags cmdFlags) {
        if (serviceURI == null) {
            log.warn("No service uri is provided. Use default 'distributedlog://localhost/distributedlog'.");
            serviceURI = ServiceURI.create((String)"distributedlog://localhost/distributedlog");
        }
        PerfReader reader = new PerfReader(serviceURI, cmdFlags);
        reader.run();
        return true;
    }
}

