/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.csm.observability;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.ExperimentalApi;
import io.grpc.InternalConfigurator;
import io.grpc.InternalConfiguratorRegistry;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ServerBuilder;
import io.grpc.gcp.csm.observability.MetadataExchanger;
import io.grpc.opentelemetry.GrpcOpenTelemetry;
import io.grpc.opentelemetry.InternalGrpcOpenTelemetry;
import io.grpc.opentelemetry.InternalOpenTelemetryPlugin;
import io.opentelemetry.api.OpenTelemetry;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11249")
public final class CsmObservability
implements Closeable {
    private final GrpcOpenTelemetry delegate;
    private final MetadataExchanger exchanger;

    public static Builder newBuilder() {
        return new Builder();
    }

    private CsmObservability(Builder builder) {
        this.delegate = builder.delegate.build();
        this.exchanger = builder.exchanger;
    }

    public void registerGlobal() {
        InternalConfiguratorRegistry.setConfigurators(Collections.singletonList(new InternalConfigurator(){

            public void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
                CsmObservability.this.configureChannelBuilder(channelBuilder);
            }

            public void configureServerBuilder(ServerBuilder<?> serverBuilder) {
                CsmObservability.this.configureServerBuilder(serverBuilder);
            }
        }));
    }

    @VisibleForTesting
    void configureChannelBuilder(ManagedChannelBuilder<?> builder) {
        this.delegate.configureChannelBuilder(builder);
    }

    @VisibleForTesting
    void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        this.delegate.configureServerBuilder(serverBuilder);
        this.exchanger.configureServerBuilder(serverBuilder);
    }

    @Override
    public void close() {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11249")
    public static final class Builder {
        private final GrpcOpenTelemetry.Builder delegate = GrpcOpenTelemetry.newBuilder();
        private final MetadataExchanger exchanger;

        private Builder() {
            this(new MetadataExchanger());
        }

        @VisibleForTesting
        Builder(MetadataExchanger exchanger) {
            this.exchanger = exchanger;
            InternalGrpcOpenTelemetry.builderPlugin((GrpcOpenTelemetry.Builder)this.delegate, (InternalOpenTelemetryPlugin)exchanger);
        }

        public Builder sdk(OpenTelemetry sdk) {
            this.delegate.sdk(sdk);
            return this;
        }

        public Builder addOptionalLabel(String optionalLabelKey) {
            this.delegate.addOptionalLabel(optionalLabelKey);
            return this;
        }

        public Builder enableMetrics(Collection<String> enableMetrics) {
            this.delegate.enableMetrics(enableMetrics);
            return this;
        }

        public Builder disableMetrics(Collection<String> disableMetrics) {
            this.delegate.disableMetrics(disableMetrics);
            return this;
        }

        public Builder disableAllMetrics() {
            this.delegate.disableAllMetrics();
            return this;
        }

        public CsmObservability build() {
            return new CsmObservability(this);
        }
    }
}

