/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.zookeeper.test.AuthTest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AuthSHA3Test
extends AuthTest {
    @BeforeAll
    public static void setup() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        System.setProperty("zookeeper.DigestAuthenticationProvider.digestAlg", AuthTest.DigestAlgEnum.SHA3_256.getName());
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:cRy/KPYuDpW/dtsepniTMpuiuupnWgdU9txltIfv3hA=");
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.test.InvalidAuthProvider");
    }

    @AfterAll
    public static void teardown() {
        Security.removeProvider("BC");
        System.clearProperty("zookeeper.DigestAuthenticationProvider.superDigest");
        System.clearProperty("zookeeper.DigestAuthenticationProvider.digestAlg");
    }

    @Override
    @Test
    public void testBadAuthNotifiesWatch() throws Exception {
        super.testBadAuthNotifiesWatch();
    }

    @Override
    @Test
    public void testBadAuthThenSendOtherCommands() throws Exception {
        super.testBadAuthThenSendOtherCommands();
    }

    @Override
    @Test
    public void testSuper() throws Exception {
        super.testSuper();
    }

    @Override
    @Test
    public void testSuperACL() throws Exception {
        super.testSuperACL();
    }

    @Override
    @Test
    public void testOrdinaryACL() throws Exception {
        super.testOrdinaryACL();
    }

    @Override
    @Test
    public void testGenerateDigest() throws NoSuchAlgorithmException {
        Assertions.assertEquals((Object)"super:cRy/KPYuDpW/dtsepniTMpuiuupnWgdU9txltIfv3hA=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:test"));
        Assertions.assertEquals((Object)"super:gM3M1QcrKC6b+h4oZ5Ixc4GTVaAsggI+AqkUaF6E1Is=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:zookeeper"));
        Assertions.assertEquals((Object)"super:2Ww7VUqTohd3lX/Vf4Nvw+GxbmOsX1p337L7Bnks4L8=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:foo"));
        Assertions.assertEquals((Object)"super:Ft5s2Rtxr8zyz16feKiFR/8yqa6JoNEJ0In73aXojE8=", (Object)DigestAuthenticationProvider.generateDigest((String)"super:bar"));
    }

    @Override
    @Test
    public void testDigest() throws NoSuchAlgorithmException {
        Assertions.assertEquals((Object)"36f028580bb02cc8272a9a020f4200e346e276ae664e45ee80745574e2f5ab80", (Object)AuthSHA3Test.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"test")));
        Assertions.assertEquals((Object)"af4c1abc2deaa6edffc7ce34edeb8c03ee9a1488b64fd318ddb93b4b7f1c0746", (Object)AuthSHA3Test.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"zookeeper")));
        Assertions.assertEquals((Object)"76d3bc41c9f588f7fcd0d5bf4718f8f84b1c41b20882703100b9eb9413807c01", (Object)AuthSHA3Test.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"foo")));
        Assertions.assertEquals((Object)"cceefd7e0545bcf8b6d19f3b5750c8a3ee8350418877bc6fb12e32de28137355", (Object)AuthSHA3Test.getGeneratedDigestStr(DigestAuthenticationProvider.digest((String)"bar")));
    }
}

