/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.compat;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.compat.ProtocolManager;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.proto.ConnectResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProtocolManagerTest {
    private static byte[] serializeConnectRequest(ConnectRequest request, boolean withReadOnly) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)baos);
        request.serialize((OutputArchive)oa, "connect");
        baos.close();
        byte[] bytes = baos.toByteArray();
        if (withReadOnly) {
            return bytes;
        }
        return Arrays.copyOf(bytes, bytes.length - 1);
    }

    @Test
    public void testDeserializeConnectRequestWithReadonly() throws IOException {
        ProtocolManager protocolManager = new ProtocolManager();
        ConnectRequest req1 = new ConnectRequest();
        req1.setPasswd(new byte[16]);
        req1.setReadOnly(true);
        byte[] bytes = ProtocolManagerTest.serializeConnectRequest(req1, true);
        Assertions.assertEquals((int)45, (int)bytes.length);
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)new ByteArrayInputStream(bytes));
        ConnectRequest req2 = protocolManager.deserializeConnectRequest((InputArchive)ia);
        Assertions.assertEquals((Object)true, (Object)protocolManager.isReadonlyAvailable());
        Assertions.assertEquals((Object)true, (Object)req2.getReadOnly());
    }

    @Test
    public void testDeserializeConnectRequestWithoutReadonly() throws IOException {
        ProtocolManager protocolManager = new ProtocolManager();
        ConnectRequest req1 = new ConnectRequest();
        req1.setPasswd(new byte[16]);
        req1.setReadOnly(true);
        byte[] bytes = ProtocolManagerTest.serializeConnectRequest(req1, false);
        Assertions.assertEquals((int)44, (int)bytes.length);
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)new ByteArrayInputStream(bytes));
        ConnectRequest req2 = protocolManager.deserializeConnectRequest((InputArchive)ia);
        Assertions.assertEquals((Object)false, (Object)protocolManager.isReadonlyAvailable());
        Assertions.assertEquals((Object)false, (Object)req2.getReadOnly());
    }

    private static ProtocolManager prepareProtocolManager(boolean withReadOnly) throws IOException {
        ProtocolManager protocolManager = new ProtocolManager();
        ConnectRequest req1 = new ConnectRequest();
        req1.setPasswd(new byte[16]);
        req1.setReadOnly(true);
        byte[] bytes = ProtocolManagerTest.serializeConnectRequest(req1, withReadOnly);
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)new ByteArrayInputStream(bytes));
        ConnectRequest req2 = protocolManager.deserializeConnectRequest((InputArchive)ia);
        return protocolManager;
    }

    @Test
    public void testSerializeConnectResponseWithReadonly() throws IOException {
        ProtocolManager protocolManager = ProtocolManagerTest.prepareProtocolManager(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive os = BinaryOutputArchive.getArchive((OutputStream)baos);
        ConnectResponse rsp = new ConnectResponse();
        rsp.setPasswd(new byte[16]);
        rsp.setReadOnly(true);
        protocolManager.serializeConnectResponse(rsp, (OutputArchive)os);
        baos.close();
        byte[] bytes = baos.toByteArray();
        Assertions.assertEquals((int)37, (int)bytes.length);
        Assertions.assertEquals((int)1, (int)bytes[bytes.length - 1]);
    }

    @Test
    public void testSerializeConnectResponseWithoutReadonly() throws IOException {
        ProtocolManager protocolManager = ProtocolManagerTest.prepareProtocolManager(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive os = BinaryOutputArchive.getArchive((OutputStream)baos);
        ConnectResponse rsp = new ConnectResponse();
        rsp.setPasswd(new byte[16]);
        rsp.setReadOnly(true);
        protocolManager.serializeConnectResponse(rsp, (OutputArchive)os);
        baos.close();
        byte[] bytes = baos.toByteArray();
        Assertions.assertEquals((int)36, (int)bytes.length);
    }
}

