/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.metrics;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.zookeeper.metrics.MetricsContext;
import org.apache.zookeeper.metrics.MetricsProvider;
import org.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import org.apache.zookeeper.metrics.impl.NullMetricsProvider;

public abstract class BaseTestMetricsProvider
implements MetricsProvider {
    public void configure(Properties prprts) throws MetricsProviderLifeCycleException {
    }

    public void start() throws MetricsProviderLifeCycleException {
    }

    public MetricsContext getRootContext() {
        return NullMetricsProvider.NullMetricsContext.INSTANCE;
    }

    public void stop() {
    }

    public void dump(BiConsumer<String, Object> sink) {
    }

    public void resetAllValues() {
    }

    public static final class MetricsProviderWithErrorInStop
    extends BaseTestMetricsProvider {
        public static final AtomicBoolean stopCalled = new AtomicBoolean();

        @Override
        public void stop() {
            stopCalled.set(true);
            throw new RuntimeException();
        }
    }

    public static final class MetricsProviderWithConfiguration
    extends BaseTestMetricsProvider {
        public static final AtomicInteger httpPort = new AtomicInteger();

        @Override
        public void configure(Properties prprts) throws MetricsProviderLifeCycleException {
            httpPort.set(Integer.parseInt(prprts.getProperty("httpPort")));
        }
    }

    public static final class MetricsProviderWithErrorInConfigure
    extends BaseTestMetricsProvider {
        @Override
        public void configure(Properties prprts) throws MetricsProviderLifeCycleException {
            throw new MetricsProviderLifeCycleException();
        }
    }

    public static final class MetricsProviderWithErrorInStart
    extends BaseTestMetricsProvider {
        @Override
        public void start() throws MetricsProviderLifeCycleException {
            throw new MetricsProviderLifeCycleException();
        }
    }

    public static final class MetricsProviderCapturingLifecycle
    extends BaseTestMetricsProvider {
        public static final AtomicBoolean configureCalled = new AtomicBoolean();
        public static final AtomicBoolean startCalled = new AtomicBoolean();
        public static final AtomicBoolean stopCalled = new AtomicBoolean();
        public static final AtomicBoolean getRootContextCalled = new AtomicBoolean();

        public static void reset() {
            configureCalled.set(false);
            startCalled.set(false);
            stopCalled.set(false);
            getRootContextCalled.set(false);
        }

        @Override
        public void configure(Properties prprts) throws MetricsProviderLifeCycleException {
            if (!configureCalled.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
        }

        @Override
        public void start() throws MetricsProviderLifeCycleException {
            if (!startCalled.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
        }

        @Override
        public MetricsContext getRootContext() {
            getRootContextCalled.set(true);
            return NullMetricsProvider.NullMetricsContext.INSTANCE;
        }

        @Override
        public void stop() {
            if (!stopCalled.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
        }
    }
}

