/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.parser.java;

import java.io.File;
import java.util.List;

import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

class RoasterJavaPartialRouteDslTest extends CamelTestSupport {

    private static final Logger LOG = LoggerFactory.getLogger(RoasterJavaPartialRouteDslTest.class);

    @Test
    void parseTree() throws Exception {
        String pathToFile = "src/test/java/org/apache/camel/parser/java/MyPartialRoute.java";
        JavaClassSource clazz = (JavaClassSource) Roaster.parse(new File(pathToFile));

        List<CamelNodeDetails> list = RouteBuilderParser.parseRouteBuilderTree(clazz, pathToFile, true);
        assertEquals(1, list.size());
        CamelNodeDetails details = list.get(0);
        assertEquals(pathToFile, details.getFileName());
        assertEquals("configure", details.getMethodName());
        assertEquals("org.apache.camel.parser.java.MyPartialRoute", details.getClassName());
        assertEquals("25", list.get(0).getLineNumber());
        assertEquals("25", list.get(0).getLineNumberEnd());

        String tree = details.dump(0);
        LOG.info("\n{}", tree);

        assertTrue(tree.contains("25\tfrom"));
    }

}
