/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.spi;

import org.apache.camel.CamelContext;

/**
 * SPI for setting up XML data format (jacksonXml) for rest-dsl.
 */
public interface RestBindingJacksonXmlDataFormatFactory {

    /**
     * Service factory key.
     */
    String FACTORY = "rest-binding-jacksonxml-dataformat-factory";

    /**
     * Setup XML data format
     */
    void setupJacksonXml(
            CamelContext camelContext, RestConfiguration config,
            String type, Class<?> typeClass, String outType, Class<?> outTypeClass,
            DataFormat jacksonXml, DataFormat outJacksonXml)
            throws Exception;

}
