/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform operations on the Neo4j Graph Database
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Neo4jEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Neo4j component.
     */
    public interface Neo4jEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedNeo4jEndpointBuilder advanced() {
            return (AdvancedNeo4jEndpointBuilder) this;
        }

        /**
         * Node alias.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param alias the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder alias(String alias) {
            doSetProperty("alias", alias);
            return this;
        }
        /**
         * Url for connecting to Neo database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param databaseUrl the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder databaseUrl(String databaseUrl) {
            doSetProperty("databaseUrl", databaseUrl);
            return this;
        }
        /**
         * Detach a relationship - set true if you want to delete a node and
         * detach its relationships to other nodes at same time.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param detachRelationship the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder detachRelationship(boolean detachRelationship) {
            doSetProperty("detachRelationship", detachRelationship);
            return this;
        }
        /**
         * Detach a relationship - set true if you want to delete a node and
         * detach its relationships to other nodes at same time.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param detachRelationship the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder detachRelationship(String detachRelationship) {
            doSetProperty("detachRelationship", detachRelationship);
            return this;
        }
        /**
         * Dimension of Vector Index.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param dimension the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder dimension(Integer dimension) {
            doSetProperty("dimension", dimension);
            return this;
        }
        /**
         * Dimension of Vector Index.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param dimension the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder dimension(String dimension) {
            doSetProperty("dimension", dimension);
            return this;
        }
        /**
         * Node Label.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param label the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder label(String label) {
            doSetProperty("label", label);
            return this;
        }
        /**
         * Maximum results for Vector Similarity search.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 3
         * Group: producer
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder maxResults(int maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * Maximum results for Vector Similarity search.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 3
         * Group: producer
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder maxResults(String maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * Minimum score for Vector Similarity search.
         * 
         * The option is a: <code>double</code> type.
         * 
         * Default: 0.0
         * Group: producer
         * 
         * @param minScore the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder minScore(double minScore) {
            doSetProperty("minScore", minScore);
            return this;
        }
        /**
         * Minimum score for Vector Similarity search.
         * 
         * The option will be converted to a <code>double</code> type.
         * 
         * Default: 0.0
         * Group: producer
         * 
         * @param minScore the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder minScore(String minScore) {
            doSetProperty("minScore", minScore);
            return this;
        }
        /**
         * Cypher Query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param query the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * Similarity Function of Vector Index.
         * 
         * The option is a:
         * <code>org.apache.camel.component.neo4j.Neo4jSimilarityFunction</code>
         * type.
         * 
         * Default: cosine
         * Group: producer
         * 
         * @param similarityFunction the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder similarityFunction(org.apache.camel.component.neo4j.Neo4jSimilarityFunction similarityFunction) {
            doSetProperty("similarityFunction", similarityFunction);
            return this;
        }
        /**
         * Similarity Function of Vector Index.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.neo4j.Neo4jSimilarityFunction</code>
         * type.
         * 
         * Default: cosine
         * Group: producer
         * 
         * @param similarityFunction the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder similarityFunction(String similarityFunction) {
            doSetProperty("similarityFunction", similarityFunction);
            return this;
        }
        /**
         * Vector Index Name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param vectorIndexName the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder vectorIndexName(String vectorIndexName) {
            doSetProperty("vectorIndexName", vectorIndexName);
            return this;
        }
        /**
         * Kerberos Authentication encoded base64 ticket.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param kerberosAuthTicket the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder kerberosAuthTicket(String kerberosAuthTicket) {
            doSetProperty("kerberosAuthTicket", kerberosAuthTicket);
            return this;
        }
        /**
         * Basic authentication database password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Basic authentication database realm.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param realm the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder realm(String realm) {
            doSetProperty("realm", realm);
            return this;
        }
        /**
         * Bearer authentication database realm.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param token the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder token(String token) {
            doSetProperty("token", token);
            return this;
        }
        /**
         * Basic authentication database user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Neo4j component.
     */
    public interface AdvancedNeo4jEndpointBuilder
            extends
                EndpointProducerBuilder {
        default Neo4jEndpointBuilder basic() {
            return (Neo4jEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNeo4jEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNeo4jEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Advanced - Driver.
         * 
         * The option is a: <code>org.neo4j.driver.Driver</code> type.
         * 
         * Group: advanced
         * 
         * @param driver the value to set
         * @return the dsl builder
         */
        default AdvancedNeo4jEndpointBuilder driver(org.neo4j.driver.Driver driver) {
            doSetProperty("driver", driver);
            return this;
        }
        /**
         * Advanced - Driver.
         * 
         * The option will be converted to a
         * <code>org.neo4j.driver.Driver</code> type.
         * 
         * Group: advanced
         * 
         * @param driver the value to set
         * @return the dsl builder
         */
        default AdvancedNeo4jEndpointBuilder driver(String driver) {
            doSetProperty("driver", driver);
            return this;
        }
    }

    public interface Neo4jBuilders {
        /**
         * Neo4j (camel-neo4j)
         * Perform operations on the Neo4j Graph Database
         * 
         * Category: database,ai
         * Since: 4.10
         * Maven coordinates: org.apache.camel:camel-neo4j
         * 
         * @return the dsl builder for the headers' name.
         */
        default Neo4jHeaderNameBuilder neo4j() {
            return Neo4jHeaderNameBuilder.INSTANCE;
        }
        /**
         * Neo4j (camel-neo4j)
         * Perform operations on the Neo4j Graph Database
         * 
         * Category: database,ai
         * Since: 4.10
         * Maven coordinates: org.apache.camel:camel-neo4j
         * 
         * Syntax: <code>neo4j:name</code>
         * 
         * Path parameter: name (required)
         * The database name
         * 
         * @param path name
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder neo4j(String path) {
            return Neo4jEndpointBuilderFactory.endpointBuilder("neo4j", path);
        }
        /**
         * Neo4j (camel-neo4j)
         * Perform operations on the Neo4j Graph Database
         * 
         * Category: database,ai
         * Since: 4.10
         * Maven coordinates: org.apache.camel:camel-neo4j
         * 
         * Syntax: <code>neo4j:name</code>
         * 
         * Path parameter: name (required)
         * The database name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         * @return the dsl builder
         */
        default Neo4jEndpointBuilder neo4j(String componentName, String path) {
            return Neo4jEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Neo4j component.
     */
    public static class Neo4jHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Neo4jHeaderNameBuilder INSTANCE = new Neo4jHeaderNameBuilder();

        /**
         * The operation to be performed.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Neo4jOperation}.
         */
        public String neo4jOperation() {
            return "CamelNeo4jOperation";
        }
        /**
         * MATCH properties for the generated MATCH query. Needed only if we are
         * matching properties and values. Example: {name: 'Alice'}.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Neo4jMatchProperties}.
         */
        public String neo4jMatchProperties() {
            return "CamelNeo4jMatchProperties";
        }
        /**
         * Query Result.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Neo4jQueryResult}.
         */
        public String neo4jQueryResult() {
            return "CamelNeo4jQueryResult";
        }
        /**
         * Query Number of nodes created.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Neo4jQueryResultNodesCreated}.
         */
        public String neo4jQueryResultNodesCreated() {
            return "CamelNeo4jQueryResultNodesCreated";
        }
        /**
         * Query Number of nodes deleted.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Neo4jQueryResultNodesDeleted}.
         */
        public String neo4jQueryResultNodesDeleted() {
            return "CamelNeo4jQueryResultNodesDeleted";
        }
        /**
         * Query executed contains update.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * Neo4jQueryResultContainsUpdates}.
         */
        public String neo4jQueryResultContainsUpdates() {
            return "CamelNeo4jQueryResultContainsUpdates";
        }
        /**
         * Query executed number of relationships created.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * Neo4jQueryResultRelationshipsCreated}.
         */
        public String neo4jQueryResultRelationshipsCreated() {
            return "CamelNeo4jQueryResultRelationshipsCreated";
        }
        /**
         * Query executed number of relationships deleted.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * Neo4jQueryResultRelationshipsDeleted}.
         */
        public String neo4jQueryResultRelationshipsDeleted() {
            return "CamelNeo4jQueryResultRelationshipsDeleted";
        }
        /**
         * Number of nodes retrieved.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Neo4jQueryResultRetrieveSize}.
         */
        public String neo4jQueryResultRetrieveSize() {
            return "CamelNeo4jQueryResultRetrieveSize";
        }
        /**
         * Query execution time in Milliseconds.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * Neo4jQueryResultListNeo4jNodes}.
         */
        public String neo4jQueryResultListNeo4jNodes() {
            return "CamelNeo4jQueryResultListNeo4jNodes";
        }
        /**
         * Vector Id for the embedding.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Neo4jVectorEmbeddingId}.
         */
        public String neo4jVectorEmbeddingId() {
            return "CamelNeo4jVectorEmbeddingId";
        }
        /**
         * Label for the Node - used when inserting from Embeddings.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Neo4jLabel}.
         */
        public String neo4jLabel() {
            return "CamelNeo4jLabel";
        }
    }
    static Neo4jEndpointBuilder endpointBuilder(String componentName, String path) {
        class Neo4jEndpointBuilderImpl extends AbstractEndpointBuilder implements Neo4jEndpointBuilder, AdvancedNeo4jEndpointBuilder {
            public Neo4jEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Neo4jEndpointBuilderImpl(path);
    }
}