/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform operations on the Weaviate Vector Database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WeaviateVectorDbEndpointBuilderFactory {

    /**
     * Builder for endpoint for the weaviate component.
     */
    public interface WeaviateVectorDbEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWeaviateVectorDbEndpointBuilder advanced() {
            return (AdvancedWeaviateVectorDbEndpointBuilder) this;
        }

        /**
         * API Key to authenticate to weaviate with.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default WeaviateVectorDbEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
        /**
         * Weaviate server host to connect to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default WeaviateVectorDbEndpointBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Proxy host to connect to weaviate through.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default WeaviateVectorDbEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Proxy port to connect to weaviate through.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default WeaviateVectorDbEndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy port to connect to weaviate through.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default WeaviateVectorDbEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Proxy scheme to connect to weaviate through.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param proxyScheme the value to set
         * @return the dsl builder
         */
        default WeaviateVectorDbEndpointBuilder proxyScheme(String proxyScheme) {
            doSetProperty("proxyScheme", proxyScheme);
            return this;
        }
        /**
         * Scheme used to connect to weaviate.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param scheme the value to set
         * @return the dsl builder
         */
        default WeaviateVectorDbEndpointBuilder scheme(String scheme) {
            doSetProperty("scheme", scheme);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the weaviate component.
     */
    public interface AdvancedWeaviateVectorDbEndpointBuilder
            extends
                EndpointProducerBuilder {
        default WeaviateVectorDbEndpointBuilder basic() {
            return (WeaviateVectorDbEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWeaviateVectorDbEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWeaviateVectorDbEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface WeaviateVectorDbBuilders {
        /**
         * weaviate (camel-weaviate)
         * Perform operations on the Weaviate Vector Database.
         * 
         * Category: database,ai
         * Since: 4.12
         * Maven coordinates: org.apache.camel:camel-weaviate
         * 
         * @return the dsl builder for the headers' name.
         */
        default WeaviateVectorDbHeaderNameBuilder weaviate() {
            return WeaviateVectorDbHeaderNameBuilder.INSTANCE;
        }
        /**
         * weaviate (camel-weaviate)
         * Perform operations on the Weaviate Vector Database.
         * 
         * Category: database,ai
         * Since: 4.12
         * Maven coordinates: org.apache.camel:camel-weaviate
         * 
         * Syntax: <code>weaviate:collection</code>
         * 
         * Path parameter: collection (required)
         * The collection Name
         * 
         * @param path collection
         * @return the dsl builder
         */
        default WeaviateVectorDbEndpointBuilder weaviate(String path) {
            return WeaviateVectorDbEndpointBuilderFactory.endpointBuilder("weaviate", path);
        }
        /**
         * weaviate (camel-weaviate)
         * Perform operations on the Weaviate Vector Database.
         * 
         * Category: database,ai
         * Since: 4.12
         * Maven coordinates: org.apache.camel:camel-weaviate
         * 
         * Syntax: <code>weaviate:collection</code>
         * 
         * Path parameter: collection (required)
         * The collection Name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path collection
         * @return the dsl builder
         */
        default WeaviateVectorDbEndpointBuilder weaviate(String componentName, String path) {
            return WeaviateVectorDbEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the weaviate component.
     */
    public static class WeaviateVectorDbHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final WeaviateVectorDbHeaderNameBuilder INSTANCE = new WeaviateVectorDbHeaderNameBuilder();

        /**
         * The action to be performed.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateAction}.
         */
        public String weaviateAction() {
            return "CamelWeaviateAction";
        }
        /**
         * Text Field Name for Insert/Upsert operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateTextFieldName}.
         */
        public String weaviateTextFieldName() {
            return "CamelWeaviateTextFieldName";
        }
        /**
         * Vector Field Name for Insert/Upsert operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code weaviateVectorFieldName}.
         */
        public String weaviateVectorFieldName() {
            return "CamelweaviateVectorFieldName";
        }
        /**
         * Collection Name for Insert/Upsert operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateCollectionName}.
         */
        public String weaviateCollectionName() {
            return "CamelWeaviateCollectionName";
        }
        /**
         * Collection Similarity Metric.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * WeaviateCollectionSimilarityMetric}.
         */
        public String weaviateCollectionSimilarityMetric() {
            return "CamelWeaviateCollectionSimilarityMetric";
        }
        /**
         * Collection Dimension.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateCollectionDimension}.
         */
        public String weaviateCollectionDimension() {
            return "CamelWeaviateCollectionDimension";
        }
        /**
         * Collection Cloud Vendor.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateCollectionCloud}.
         */
        public String weaviateCollectionCloud() {
            return "CamelWeaviateCollectionCloud";
        }
        /**
         * Collection Cloud Vendor Region.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateCollectionCloudRegion}.
         */
        public String weaviateCollectionCloudRegion() {
            return "CamelWeaviateCollectionCloudRegion";
        }
        /**
         * Index Name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateIndexName}.
         */
        public String weaviateIndexName() {
            return "CamelWeaviateIndexName";
        }
        /**
         * Weaviate Object fields.
         * 
         * The option is a: {@code HashMap} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateFields}.
         */
        public String weaviateFields() {
            return "CamelWeaviateFields";
        }
        /**
         * Weaviate Object properties.
         * 
         * The option is a: {@code HashMap} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateProperties}.
         */
        public String weaviateProperties() {
            return "CamelWeaviateProperties";
        }
        /**
         * Index Id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateIndexId}.
         */
        public String weaviateIndexId() {
            return "CamelWeaviateIndexId";
        }
        /**
         * Query Top K.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateQueryTopK}.
         */
        public String weaviateQueryTopK() {
            return "CamelWeaviateQueryTopK";
        }
        /**
         * Merges properties into the object.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Default: true
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateUpdateWithMerge}.
         */
        public String weaviateUpdateWithMerge() {
            return "CamelWeaviateUpdateWithMerge";
        }
        /**
         * Key Name for Insert/Upsert operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateKeyName}.
         */
        public String weaviateKeyName() {
            return "CamelWeaviateKeyName";
        }
        /**
         * Key Value for Insert/Upsert operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WeaviateKeyValue}.
         */
        public String weaviateKeyValue() {
            return "CamelWeaviateKeyValue";
        }
    }
    static WeaviateVectorDbEndpointBuilder endpointBuilder(String componentName, String path) {
        class WeaviateVectorDbEndpointBuilderImpl extends AbstractEndpointBuilder implements WeaviateVectorDbEndpointBuilder, AdvancedWeaviateVectorDbEndpointBuilder {
            public WeaviateVectorDbEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WeaviateVectorDbEndpointBuilderImpl(path);
    }
}