/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Locale;
import java.util.Objects;
import org.apache.cassandra.cql3.ColumnIdentifier;

public class QualifiedName {
    private String keyspace;
    private String name;

    public QualifiedName() {
    }

    public QualifiedName(String keyspace, String name) {
        this.keyspace = keyspace;
        this.name = name;
    }

    public final void setKeyspace(String ks, boolean keepCase) {
        this.keyspace = QualifiedName.toInternalName(ks, keepCase);
    }

    public final boolean hasKeyspace() {
        return this.keyspace != null;
    }

    public final String getKeyspace() {
        return this.keyspace;
    }

    public void setName(String cf, boolean keepCase) {
        this.name = QualifiedName.toInternalName(cf, keepCase);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.hasKeyspace() ? String.format("%s.%s", this.keyspace, this.name) : this.name;
    }

    public String toCQLString() {
        String nameQuotedIfNeeded = ColumnIdentifier.maybeQuote(this.name);
        return this.hasKeyspace() ? String.format("%s.%s", ColumnIdentifier.maybeQuote(this.keyspace), nameQuotedIfNeeded) : nameQuotedIfNeeded;
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QualifiedName)) {
            return false;
        }
        QualifiedName qn = (QualifiedName)o;
        return Objects.equals(this.keyspace, qn.keyspace) && this.name.equals(qn.name);
    }

    private static String toInternalName(String name, boolean keepCase) {
        return keepCase ? name : name.toLowerCase(Locale.US);
    }
}

