/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.UDFContext;
import org.apache.cassandra.cql3.functions.UDFDataType;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.TupleType;
import org.apache.cassandra.cql3.functions.types.TupleValue;
import org.apache.cassandra.cql3.functions.types.UDTValue;
import org.apache.cassandra.cql3.functions.types.UserType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.JavaDriverUtils;

public final class UDFContextImpl
implements UDFContext {
    private final Map<String, UDFDataType> byName = new HashMap<String, UDFDataType>();
    private final List<UDFDataType> argTypes;
    private final UDFDataType returnType;
    private final String keyspace;
    private final Supplier<KeyspaceMetadata> metadata;

    UDFContextImpl(List<ColumnIdentifier> argNames, List<UDFDataType> argTypes, UDFDataType returnType, String keyspace) {
        for (int i = 0; i < argNames.size(); ++i) {
            this.byName.put(argNames.get(i).toString(), argTypes.get(i));
        }
        this.argTypes = argTypes;
        this.returnType = returnType;
        this.keyspace = keyspace;
        this.metadata = Suppliers.memoize(() -> Schema.instance.getKeyspaceMetadata(keyspace));
    }

    @Override
    public UDTValue newArgUDTValue(String argName) {
        return UDFContextImpl.newUDTValue(this.getArgumentTypeByName(argName).toDataType());
    }

    @Override
    public UDTValue newArgUDTValue(int argNum) {
        return UDFContextImpl.newUDTValue(this.getArgumentTypeByIndex(argNum).toDataType());
    }

    @Override
    public UDTValue newReturnUDTValue() {
        return UDFContextImpl.newUDTValue(this.returnType.toDataType());
    }

    @Override
    public UDTValue newUDTValue(String udtName) {
        Optional<org.apache.cassandra.db.marshal.UserType> udtType = this.metadata.get().types.get(ByteBufferUtil.bytes(udtName));
        DataType dataType = JavaDriverUtils.driverType(udtType.orElseThrow(() -> new IllegalArgumentException("No UDT named " + udtName + " in keyspace " + this.keyspace)));
        return UDFContextImpl.newUDTValue(dataType);
    }

    @Override
    public TupleValue newArgTupleValue(String argName) {
        return UDFContextImpl.newTupleValue(this.getArgumentTypeByName(argName).toDataType());
    }

    @Override
    public TupleValue newArgTupleValue(int argNum) {
        return UDFContextImpl.newTupleValue(this.getArgumentTypeByIndex(argNum).toDataType());
    }

    @Override
    public TupleValue newReturnTupleValue() {
        return UDFContextImpl.newTupleValue(this.returnType.toDataType());
    }

    @Override
    public TupleValue newTupleValue(String cqlDefinition) {
        AbstractType<?> abstractType = CQLTypeParser.parse(this.keyspace, cqlDefinition, this.metadata.get().types);
        DataType dataType = JavaDriverUtils.driverType(abstractType);
        return UDFContextImpl.newTupleValue(dataType);
    }

    private static UDTValue newUDTValue(DataType dataType) {
        if (!(dataType instanceof UserType)) {
            throw new IllegalStateException("Function argument is not a UDT but a " + dataType.getName());
        }
        UserType userType = (UserType)dataType;
        return userType.newValue();
    }

    private static TupleValue newTupleValue(DataType dataType) {
        if (!(dataType instanceof TupleType)) {
            throw new IllegalStateException("Function argument is not a tuple type but a " + dataType.getName());
        }
        TupleType tupleType = (TupleType)dataType;
        return tupleType.newValue();
    }

    private UDFDataType getArgumentTypeByIndex(int index) {
        if (index < 0 || index >= this.argTypes.size()) {
            throw new IllegalArgumentException("Function does not declare an argument with index " + index);
        }
        return this.argTypes.get(index);
    }

    private UDFDataType getArgumentTypeByName(String argName) {
        UDFDataType arg = this.byName.get(argName);
        if (arg == null) {
            throw new IllegalArgumentException("Function does not declare an argument named '" + argName + "'");
        }
        return arg;
    }
}

