/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.streaming.CassandraOutgoingFile;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.streaming.OutgoingStream;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.streaming.StreamingChannel;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.Ref;

public class SSTableLoader
implements StreamEventHandler {
    private final File directory;
    private final String keyspace;
    private final String table;
    private final Client client;
    private final int connectionsPerHost;
    private final OutputHandler outputHandler;
    private final Set<InetAddressAndPort> failedHosts = new HashSet<InetAddressAndPort>();
    private final List<SSTableReader> sstables = new ArrayList<SSTableReader>();

    public SSTableLoader(File directory, Client client, OutputHandler outputHandler) {
        this(directory, client, outputHandler, 1, null);
    }

    public SSTableLoader(File directory, Client client, OutputHandler outputHandler, int connectionsPerHost, String targetKeyspace) {
        this(directory, client, outputHandler, connectionsPerHost, targetKeyspace, null);
    }

    public SSTableLoader(File directory, Client client, OutputHandler outputHandler, int connectionsPerHost, String targetKeyspace, String targetTable) {
        this.directory = directory;
        this.keyspace = targetKeyspace != null ? targetKeyspace : directory.parent().name();
        this.table = targetTable;
        this.client = client;
        this.outputHandler = outputHandler;
        this.connectionsPerHost = connectionsPerHost;
    }

    private Multimap<InetAddressAndPort, CassandraOutgoingFile> openSSTables(Map<InetAddressAndPort, Collection<Range<Token>>> ranges) {
        this.outputHandler.output("Opening sstables and calculating sections to stream");
        HashMultimap streamingDetails = HashMultimap.create();
        LifecycleTransaction.getFiles(this.directory.toPath(), (arg_0, arg_1) -> this.lambda$openSSTables$0(ranges, (Multimap)streamingDetails, arg_0, arg_1), Directories.OnTxnErr.IGNORE);
        return streamingDetails;
    }

    public StreamResultFuture stream() {
        return this.stream(Collections.emptySet(), new StreamEventHandler[0]);
    }

    public StreamResultFuture stream(Set<InetAddressAndPort> toIgnore, StreamEventHandler ... listeners) {
        this.client.init(this.keyspace);
        this.outputHandler.output("Established connection to initial hosts");
        StreamPlan plan = new StreamPlan(StreamOperation.BULK_LOAD, this.connectionsPerHost, false, null, PreviewKind.NONE).connectionFactory(this.client.getConnectionFactory());
        Map<InetAddressAndPort, Collection<Range<Token>>> endpointToRanges = this.client.getEndpointToRangesMap();
        Multimap<InetAddressAndPort, CassandraOutgoingFile> streamingDetails = this.openSSTables(endpointToRanges);
        if (streamingDetails.isEmpty()) {
            return plan.execute();
        }
        this.outputHandler.output(String.format("Streaming relevant part of %s to %s", this.names(streamingDetails.values()), endpointToRanges.keySet()));
        for (Map.Entry<InetAddressAndPort, Collection<Range<Token>>> entry : endpointToRanges.entrySet()) {
            InetAddressAndPort remote = entry.getKey();
            if (toIgnore.contains(remote)) continue;
            LinkedList<OutgoingStream> streams = new LinkedList<OutgoingStream>(streamingDetails.get((Object)remote));
            plan.transferStreams(remote, streams);
        }
        plan.listeners(this, listeners);
        return plan.execute();
    }

    public void onSuccess(StreamState finalState) {
        this.releaseReferences();
    }

    public void onFailure(Throwable t) {
        this.releaseReferences();
    }

    private void releaseReferences() {
        Iterator<SSTableReader> it = this.sstables.iterator();
        while (it.hasNext()) {
            SSTableReader sstable = it.next();
            sstable.selfRef().release();
            it.remove();
        }
    }

    @VisibleForTesting
    ImmutableList<SSTableReader> getSSTables() {
        return ImmutableList.copyOf(this.sstables);
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
        if (event.eventType == StreamEvent.Type.STREAM_COMPLETE) {
            StreamEvent.SessionCompleteEvent se = (StreamEvent.SessionCompleteEvent)event;
            if (!se.success) {
                this.failedHosts.add(se.peer);
            }
        }
    }

    private String names(Collection<CassandraOutgoingFile> sstables) {
        return sstables.stream().map(CassandraOutgoingFile::getName).distinct().collect(Collectors.joining(" "));
    }

    public Set<InetAddressAndPort> getFailedHosts() {
        return this.failedHosts;
    }

    private /* synthetic */ boolean lambda$openSSTables$0(Map ranges, Multimap streamingDetails, File file, Directories.FileType type) {
        Descriptor desc;
        File dir = file.parent();
        String name = file.name();
        if (type != Directories.FileType.FINAL) {
            this.outputHandler.output(String.format("Skipping temporary file %s", name));
            return false;
        }
        Pair<Descriptor, Component> p = null != this.keyspace && null != this.table ? SSTable.tryComponentFromFilename(file, this.keyspace, this.table) : SSTable.tryComponentFromFilename(file);
        Descriptor descriptor = desc = p == null ? null : (Descriptor)p.left;
        if (p == null || !((Component)p.right).equals(SSTableFormat.Components.DATA)) {
            return false;
        }
        for (Component c : desc.getFormat().primaryComponents()) {
            if (desc.fileFor(c).exists()) continue;
            this.outputHandler.output(String.format("Skipping file %s because %s is missing", name, c.name));
            return false;
        }
        TableMetadataRef metadata = this.client.getTableMetadata(desc.cfname);
        if (metadata == null) {
            this.outputHandler.output(String.format("Skipping file %s: table %s.%s doesn't exist", name, this.keyspace, desc.cfname));
            return false;
        }
        Set<Component> components = desc.getComponents(desc.getFormat().primaryComponents(), desc.getFormat().uploadComponents());
        try {
            SSTableReader sstable = SSTableReader.openForBatch(null, desc, components, metadata);
            this.sstables.add(sstable);
            for (Map.Entry entry : ranges.entrySet()) {
                InetAddressAndPort endpoint = (InetAddressAndPort)entry.getKey();
                List<Range<Token>> tokenRanges = Range.normalize((Collection)entry.getValue());
                List<SSTableReader.PartitionPositionBounds> sstableSections = sstable.getPositionsForRanges(tokenRanges);
                if (sstableSections.isEmpty()) continue;
                long estimatedKeys = sstable.estimatedKeysForRanges(tokenRanges);
                Ref<SSTableReader> ref = sstable.ref();
                CassandraOutgoingFile stream = new CassandraOutgoingFile(StreamOperation.BULK_LOAD, ref, sstableSections, tokenRanges, estimatedKeys);
                streamingDetails.put((Object)endpoint, (Object)stream);
            }
            sstable.releaseInMemoryComponents();
        }
        catch (FSError e) {
            this.outputHandler.output(String.format("Skipping file %s, error opening it: %s", name, e.getMessage()));
        }
        return false;
    }

    public static abstract class Client {
        private final Map<InetAddressAndPort, Collection<Range<Token>>> endpointToRanges = new HashMap<InetAddressAndPort, Collection<Range<Token>>>();

        public abstract void init(String var1);

        public void stop() {
        }

        public StreamingChannel.Factory getConnectionFactory() {
            return StreamingChannel.Factory.Global.streamingFactory();
        }

        public abstract TableMetadataRef getTableMetadata(String var1);

        public void setTableMetadata(TableMetadataRef cfm) {
            throw new RuntimeException();
        }

        public Map<InetAddressAndPort, Collection<Range<Token>>> getEndpointToRangesMap() {
            return this.endpointToRanges;
        }

        protected void addRangeForEndpoint(Range<Token> range, InetAddressAndPort endpoint) {
            Collection<Range<Token>> ranges = this.endpointToRanges.get(endpoint);
            if (ranges == null) {
                ranges = new HashSet<Range<Token>>();
                this.endpointToRanges.put(endpoint, ranges);
            }
            ranges.add(range);
        }
    }
}

