/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.server.common.service.config.BaseConfigServiceImpl;
import org.apache.celeborn.server.common.service.config.ConfigLevel;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.SystemConfig;
import org.apache.celeborn.server.common.service.config.TenantConfig;
import org.apache.celeborn.server.common.service.store.IServiceManager;
import org.apache.celeborn.server.common.service.store.db.DbServiceManagerImpl;
import org.apache.commons.lang3.tuple.Pair;

public class DbConfigServiceImpl
extends BaseConfigServiceImpl
implements ConfigService {
    private volatile IServiceManager iServiceManager;

    public DbConfigServiceImpl(CelebornConf celebornConf) throws IOException {
        super(celebornConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCache() throws IOException {
        if (this.iServiceManager == null) {
            DbConfigServiceImpl dbConfigServiceImpl = this;
            synchronized (dbConfigServiceImpl) {
                if (this.iServiceManager == null) {
                    this.iServiceManager = new DbServiceManagerImpl(this.celebornConf, this);
                }
            }
        }
        ((SystemConfig)this.systemConfigAtomicReference.get()).setConfigs(this.iServiceManager.getSystemConfig());
        ((SystemConfig)this.systemConfigAtomicReference.get()).setTags(this.iServiceManager.getClusterTags());
        this.tenantConfigAtomicReference.set(this.iServiceManager.getAllTenantConfigs().stream().collect(Collectors.toMap(TenantConfig::getTenantId, Function.identity())));
        this.tenantUserConfigAtomicReference.set(this.iServiceManager.getAllTenantUserConfigs().stream().collect(Collectors.toMap(tenantConfig -> Pair.of((Object)tenantConfig.getTenantId(), (Object)tenantConfig.getName()), Function.identity())));
    }

    @Override
    public void upsertSystemConfig(Map<String, String> systemConfigs) {
        this.iServiceManager.upsertSystemConfig(systemConfigs);
    }

    @Override
    public void upsertTenantConfig(ConfigLevel configLevel, String tenantId, String name, Map<String, String> tenantConfigs) {
        this.iServiceManager.upsertTenantConfig(configLevel, tenantId, name, tenantConfigs);
    }

    @Override
    public void deleteSystemConfigByKeys(List<String> configKeys) {
        this.iServiceManager.deleteSystemConfigByKeys(configKeys);
    }

    @Override
    public void deleteTenantConfigByKeys(ConfigLevel configLevel, String tenantId, String name, List<String> configKeys) {
        this.iServiceManager.deleteTenantConfigByKeys(configLevel, tenantId, name, configKeys);
    }

    @VisibleForTesting
    public IServiceManager getServiceManager() {
        return this.iServiceManager;
    }
}

