/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import java.util.Objects;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.ResponseMessage;
import org.apache.celeborn.common.network.protocol.StreamChunkSlice;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;

public final class ChunkFetchSuccess
extends ResponseMessage {
    public final StreamChunkSlice streamChunkSlice;

    public ChunkFetchSuccess(StreamChunkSlice streamChunkSlice, ManagedBuffer buffer) {
        super(buffer);
        this.streamChunkSlice = streamChunkSlice;
    }

    @Override
    public Message.Type type() {
        return Message.Type.CHUNK_FETCH_SUCCESS;
    }

    @Override
    public int encodedLength() {
        return this.streamChunkSlice.encodedLength();
    }

    @Override
    public void encode(ByteBuf buf) {
        this.streamChunkSlice.encode(buf);
    }

    @Override
    public ResponseMessage createFailureResponse(String error) {
        return new ChunkFetchFailure(this.streamChunkSlice, error);
    }

    public static ChunkFetchSuccess decode(ByteBuf buf) {
        return ChunkFetchSuccess.decode(buf, true);
    }

    public static ChunkFetchSuccess decode(ByteBuf buf, boolean decodeBody) {
        StreamChunkSlice streamChunkSlice = StreamChunkSlice.decode(buf);
        if (decodeBody) {
            NettyManagedBuffer managedBuf = new NettyManagedBuffer(buf);
            return new ChunkFetchSuccess(streamChunkSlice, managedBuf);
        }
        return new ChunkFetchSuccess(streamChunkSlice, NettyManagedBuffer.EmptyBuffer);
    }

    public int hashCode() {
        return Objects.hash(this.streamChunkSlice, this.body());
    }

    public boolean equals(Object other) {
        if (other instanceof ChunkFetchSuccess) {
            ChunkFetchSuccess o = (ChunkFetchSuccess)other;
            return this.streamChunkSlice.equals(o.streamChunkSlice) && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return "ChunkFetchSuccess[streamChunkId=" + this.streamChunkSlice + ",body=" + this.body() + "]";
    }
}

