/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadIndexHeartbeats {
    private static final Logger LOG = LoggerFactory.getLogger(ReadIndexHeartbeats.class);
    private final AppendEntriesListeners appendEntriesListeners = new AppendEntriesListeners();
    private final RaftLogIndex ackedCommitIndex = new RaftLogIndex((Object)"ackedCommitIndex", -1L);

    ReadIndexHeartbeats() {
    }

    AppendEntriesListener addAppendEntriesListener(long commitIndex, Function<Long, AppendEntriesListener> constructor) {
        if (commitIndex <= this.ackedCommitIndex.get()) {
            return null;
        }
        LOG.debug("listen commitIndex {}", (Object)commitIndex);
        return this.appendEntriesListeners.add(commitIndex, constructor);
    }

    void onAppendEntriesReply(LogAppender appender, RaftProtos.AppendEntriesReplyProto reply, Predicate<Predicate<RaftPeerId>> hasMajority) {
        this.appendEntriesListeners.onAppendEntriesReply(appender, reply, hasMajority);
    }

    void failListeners(Exception e) {
        this.appendEntriesListeners.failAll(e);
    }

    class AppendEntriesListeners {
        private final NavigableMap<Long, AppendEntriesListener> sorted = new TreeMap<Long, AppendEntriesListener>();
        private Exception exception = null;

        AppendEntriesListeners() {
        }

        synchronized AppendEntriesListener add(long commitIndex, Function<Long, AppendEntriesListener> constructor) {
            if (this.exception != null) {
                Preconditions.assertTrue((boolean)this.sorted.isEmpty());
                AppendEntriesListener listener = constructor.apply(commitIndex);
                listener.getFuture().completeExceptionally(this.exception);
                return listener;
            }
            return this.sorted.computeIfAbsent(commitIndex, constructor);
        }

        synchronized void onAppendEntriesReply(LogAppender appender, RaftProtos.AppendEntriesReplyProto reply, Predicate<Predicate<RaftPeerId>> hasMajority) {
            long followerCommit = reply.getFollowerCommit();
            Iterator iterator = this.sorted.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if ((Long)entry.getKey() > followerCommit) {
                    return;
                }
                AppendEntriesListener listener = (AppendEntriesListener)entry.getValue();
                if (listener == null || !listener.receive(appender, reply, hasMajority)) continue;
                ReadIndexHeartbeats.this.ackedCommitIndex.updateToMax(listener.commitIndex, s -> LOG.debug("{}: {}", (Object)this, s));
                iterator.remove();
            }
        }

        synchronized void failAll(Exception e) {
            if (this.exception != null) {
                return;
            }
            this.exception = e;
            this.sorted.forEach((index, listener) -> listener.getFuture().completeExceptionally(e));
            this.sorted.clear();
        }
    }

    static class AppendEntriesListener {
        private final long commitIndex;
        private final CompletableFuture<Long> future = new CompletableFuture();
        private final ConcurrentHashMap<RaftPeerId, HeartbeatAck> replies = new ConcurrentHashMap();

        AppendEntriesListener(long commitIndex, Iterable<LogAppender> logAppenders) {
            this.commitIndex = commitIndex;
            for (LogAppender a : logAppenders) {
                a.triggerHeartbeat();
                this.replies.put(a.getFollowerId(), new HeartbeatAck(a));
            }
        }

        CompletableFuture<Long> getFuture() {
            return this.future;
        }

        boolean receive(LogAppender logAppender, RaftProtos.AppendEntriesReplyProto proto, Predicate<Predicate<RaftPeerId>> hasMajority) {
            if (JavaUtils.isCompletedNormally(this.future)) {
                return true;
            }
            HeartbeatAck reply = this.replies.computeIfAbsent(logAppender.getFollowerId(), key -> new HeartbeatAck(logAppender));
            if (reply.receive(proto) && hasMajority.test(this::isAcknowledged)) {
                this.future.complete(this.commitIndex);
                return true;
            }
            return JavaUtils.isCompletedNormally(this.future);
        }

        boolean isAcknowledged(RaftPeerId id) {
            return Optional.ofNullable(this.replies.get(id)).filter(HeartbeatAck::isAcknowledged).isPresent();
        }
    }

    static class HeartbeatAck {
        private final LogAppender appender;
        private final long minCallId;
        private volatile boolean acknowledged = false;

        HeartbeatAck(LogAppender appender) {
            this.appender = appender;
            this.minCallId = appender.getCallId();
        }

        boolean isAcknowledged() {
            return this.acknowledged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean receive(RaftProtos.AppendEntriesReplyProto reply) {
            if (this.acknowledged) {
                return false;
            }
            HeartbeatAck heartbeatAck = this;
            synchronized (heartbeatAck) {
                if (!this.acknowledged && this.isValid(reply)) {
                    this.acknowledged = true;
                    return true;
                }
                return false;
            }
        }

        private boolean isValid(RaftProtos.AppendEntriesReplyProto reply) {
            if (reply == null || !reply.getServerReply().getSuccess()) {
                return false;
            }
            return this.appender.getCallIdComparator().compare(reply.getServerReply().getCallId(), this.minCallId) >= 0;
        }
    }
}

