/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.protocol.PbWorkerStatus;
import org.apache.celeborn.common.protocol.WorkerEventType;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.service.deploy.worker.Worker;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f!\u0002\u0012$\u0001%z\u0003\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b\u0011\u0003A\u0011A#\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\"9\u0011\u000b\u0001a\u0001\n\u0003\u0011\u0006B\u0002-\u0001A\u0003&1\nC\u0004Z\u0001\u0001\u0007I\u0011\u0001.\t\u000f\u0005\u0004\u0001\u0019!C\u0001E\"1A\r\u0001Q!\nmC\u0011\u0002\n\u0001A\u0002\u0003\u0007I\u0011B3\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0013Q\u0007\"\u00037\u0001\u0001\u0004\u0005\t\u0015)\u0003g\u0011%i\u0007\u00011AA\u0002\u0013%a\u000eC\u0005|\u0001\u0001\u0007\t\u0019!C\u0005y\"Ia\u0010\u0001a\u0001\u0002\u0003\u0006Ka\u001c\u0005\u000b\u007f\u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0001bCA\b\u0001\u0001\u0007\t\u0019!C\u0005\u0003#A1\"!\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0004!I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002(!I\u0011q\f\u0001C\u0002\u0013%\u0011\u0011\r\u0005\t\u0003k\u0002\u0001\u0015!\u0003\u0002d!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\u0018\u0002!I!a\"\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\b\"9\u00111\u0014\u0001\u0005\n\u0005u\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003G\u0003A\u0011BAO\u0005M9vN]6feN#\u0018\r^;t\u001b\u0006t\u0017mZ3s\u0015\t!S%\u0001\u0004x_J\\WM\u001d\u0006\u0003M\u001d\na\u0001Z3qY>L(B\u0001\u0015*\u0003\u001d\u0019XM\u001d<jG\u0016T!AK\u0016\u0002\u0011\r,G.\u001a2pe:T!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sON\u0019\u0001\u0001\r\u001c\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g!\t9D(D\u00019\u0015\tI$(\u0001\u0005j]R,'O\\1m\u0015\tY\u0014&\u0001\u0004d_6lwN\\\u0005\u0003{a\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003\u0003\nk\u0011AO\u0005\u0003\u0007j\u0012AbQ3mK\n|'O\\\"p]\u001a\fa\u0001P5oSRtDC\u0001$I!\t9\u0005!D\u0001$\u0011\u0015q$\u00011\u0001A\u0003M\u0019WO\u001d:f]R<vN]6feN#\u0018\r^;t+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(;\u0003\u0011iW\r^1\n\u0005Ak%\u0001D,pe.,'o\u0015;biV\u001c\u0018aF2veJ,g\u000e^,pe.,'o\u0015;biV\u001cx\fJ3r)\t\u0019f\u000b\u0005\u00022)&\u0011QK\r\u0002\u0005+:LG\u000fC\u0004X\t\u0005\u0005\t\u0019A&\u0002\u0007a$\u0013'\u0001\u000bdkJ\u0014XM\u001c;X_J\\WM]*uCR,8\u000fI\u0001\u000eKbLG/\u0012<f]R$\u0016\u0010]3\u0016\u0003m\u0003\"\u0001X0\u000e\u0003uS!A\u0018\u001e\u0002\u0011A\u0014x\u000e^8d_2L!\u0001Y/\u0003\u001f]{'o[3s\u000bZ,g\u000e\u001e+za\u0016\f\u0011#\u001a=ji\u00163XM\u001c;UsB,w\fJ3r)\t\u00196\rC\u0004X\u000f\u0005\u0005\t\u0019A.\u0002\u001d\u0015D\u0018\u000e^#wK:$H+\u001f9fAU\ta\r\u0005\u0002HO&\u0011\u0001n\t\u0002\u0007/>\u00148.\u001a:\u0002\u0015]|'o[3s?\u0012*\u0017\u000f\u0006\u0002TW\"9qKCA\u0001\u0002\u00041\u0017aB<pe.,'\u000fI\u0001\tg\",H\u000fZ8x]V\tq\u000e\u0005\u0002qs6\t\u0011O\u0003\u0002sg\u00061\u0011\r^8nS\u000eT!\u0001^;\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002wo\u0006!Q\u000f^5m\u0015\u0005A\u0018\u0001\u00026bm\u0006L!A_9\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u00031\u0019\b.\u001e;e_^tw\fJ3r)\t\u0019V\u0010C\u0004X\u001b\u0005\u0005\t\u0019A8\u0002\u0013MDW\u000f\u001e3po:\u0004\u0013AD:u_J\fw-Z'b]\u0006<WM]\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0019\u0013aB:u_J\fw-Z\u0005\u0005\u0003\u001b\t9A\u0001\bTi>\u0014\u0018mZ3NC:\fw-\u001a:\u0002%M$xN]1hK6\u000bg.Y4fe~#S-\u001d\u000b\u0004'\u0006M\u0001\u0002C,\u0011\u0003\u0003\u0005\r!a\u0001\u0002\u001fM$xN]1hK6\u000bg.Y4fe\u0002\n\u0001c\u001a:bG\u00164W\u000f\\*ikR$wn\u001e8\u0016\u0005\u0005m\u0001cA\u0019\u0002\u001e%\u0019\u0011q\u0004\u001a\u0003\u000f\t{w\u000e\\3b]\u0006\trM]1dK\u001a,Hn\u00155vi\u0012|wO\u001c\u0011\u0002%Q\u0014\u0018M\\:ji&|gn\u0015;bi\u0016l\u0015\r]\u000b\u0003\u0003O\u0001\u0002\"!\u000b\u0002,\u0005=\u0012qK\u0007\u0002k&\u0019\u0011QF;\u0003\u000f!\u000b7\u000f['baB!\u0011\u0011GA)\u001d\u0011\t\u0019$!\u0014\u000f\t\u0005U\u00121\n\b\u0005\u0003o\tIE\u0004\u0003\u0002:\u0005\u001dc\u0002BA\u001e\u0003\u000brA!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003z\u0014A\u0002\u001fs_>$h(C\u0001/\u0013\taS&\u0003\u0002+W%\u00111(K\u0005\u0003=jJ1!a\u0014^\u00039\u0001&mV8sW\u0016\u00148\u000b^1ukNLA!a\u0015\u0002V\t)1\u000b^1uK*\u0019\u0011qJ/\u0011\r\u0005%\u0012\u0011LA\u0018\u0013\r\tY&\u001e\u0002\b\u0011\u0006\u001c\bnU3u\u0003M!(/\u00198tSRLwN\\*uCR,W*\u00199!\u0003))\u00070\u001b;Ti\u0006$Xo]\u000b\u0003\u0003G\u0002b!!\u001a\u0002p\u0005ETBAA4\u0015\u0011\tI'a\u001b\u0002\u0013%lW.\u001e;bE2,'bAA7e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0013q\r\t\u0005\u0003g\n\t&\u0004\u0002\u0002V\u0005YQ\r_5u'R\fG/^:!\u0003\u0011Ig.\u001b;\u0015\u0007M\u000bY\bC\u0003%1\u0001\u0007a-\u0001\u0007e_R\u0013\u0018M\\:ji&|g\u000eF\u0002T\u0003\u0003Ca!a!\u001a\u0001\u0004Y\u0016!C3wK:$H+\u001f9f\u0003m\u0019\u0007.Z2l\u0013\u001atU-\u001a3Ue\u0006t7/\u001b;j_:\u001cF/\u0019;vgR\t1+\u0001\u0003fq&$HcA*\u0002\u000e\"1\u00111Q\u000eA\u0002m\u000bq\u0002\u001e:b]NLG/[8o'R\fG/\u001a\u000b\u0004'\u0006M\u0005bBAK9\u0001\u0007\u0011qF\u0001\u0006gR\fG/Z\u0001\u0013e\u0016\u001cw.\\7jgNLwN\\,pe.,'/\u0001\u000eeK\u000e|W.\\5tg&|gnV8sW\u0016\u0014H\u000b[3o\u0013\u0012dW-\u0001\u000feK\u000e|W.\\5tg&|g\u000e\u00165f]&#G.\u001a$j]&\u001c\b.\u001a3\u0015\u0005\u0005m\u0011AD4fi^{'o[3s'R\fG/\u001a\u000b\u0003\u0003_\tA\"\u001b8Fq&$8\u000b^1ukN\u0004")
public class WorkerStatusManager
implements Logging {
    private WorkerStatus currentWorkerStatus;
    private WorkerEventType exitEventType;
    private Worker worker;
    private AtomicBoolean shutdown;
    private StorageManager storageManager;
    private final boolean gracefulShutdown;
    private final HashMap<PbWorkerStatus.State, java.util.HashSet<PbWorkerStatus.State>> transitionStateMap;
    private final HashSet<PbWorkerStatus.State> exitStatus;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        WorkerStatusManager workerStatusManager = this;
        synchronized (workerStatusManager) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public WorkerStatus currentWorkerStatus() {
        return this.currentWorkerStatus;
    }

    public void currentWorkerStatus_$eq(WorkerStatus x$1) {
        this.currentWorkerStatus = x$1;
    }

    public WorkerEventType exitEventType() {
        return this.exitEventType;
    }

    public void exitEventType_$eq(WorkerEventType x$1) {
        this.exitEventType = x$1;
    }

    private Worker worker() {
        return this.worker;
    }

    private void worker_$eq(Worker x$1) {
        this.worker = x$1;
    }

    private AtomicBoolean shutdown() {
        return this.shutdown;
    }

    private void shutdown_$eq(AtomicBoolean x$1) {
        this.shutdown = x$1;
    }

    private StorageManager storageManager() {
        return this.storageManager;
    }

    private void storageManager_$eq(StorageManager x$1) {
        this.storageManager = x$1;
    }

    private boolean gracefulShutdown() {
        return this.gracefulShutdown;
    }

    private HashMap<PbWorkerStatus.State, java.util.HashSet<PbWorkerStatus.State>> transitionStateMap() {
        return this.transitionStateMap;
    }

    private HashSet<PbWorkerStatus.State> exitStatus() {
        return this.exitStatus;
    }

    public void init(Worker worker) {
        this.worker_$eq(worker);
        this.shutdown_$eq(worker.shutdown());
        this.storageManager_$eq(worker.storageManager());
    }

    public synchronized void doTransition(WorkerEventType eventType) {
        WorkerEventType workerEventType;
        block7: {
            block8: {
                if (this.inExitStatus()) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Worker receive event: ").append(eventType).append(", but in exit State: ").append(this.getWorkerState()).append(" ").toString());
                    return;
                }
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Worker receive event: ").append(eventType).append(", currentState: ").append(this.getWorkerState()).append(" ").toString());
                this.checkIfNeedTransitionStatus();
                PbWorkerStatus.State currentState = this.getWorkerState();
                workerEventType = eventType;
                if (WorkerEventType.DecommissionThenIdle.equals(workerEventType)) {
                    PbWorkerStatus.State state = currentState;
                    PbWorkerStatus.State state2 = PbWorkerStatus.State.Normal;
                    if (!(state != null ? !state.equals(state2) : state2 != null)) {
                        this.decommissionWorkerThenIdle();
                        return;
                    }
                }
                if (!WorkerEventType.Recommission.equals(workerEventType)) break block7;
                PbWorkerStatus.State state = currentState;
                PbWorkerStatus.State state3 = PbWorkerStatus.State.InDecommissionThenIdle;
                if (!(state == null ? state3 != null : !state.equals(state3))) break block8;
                PbWorkerStatus.State state4 = currentState;
                PbWorkerStatus.State state5 = PbWorkerStatus.State.Idle;
                if (state4 != null ? !state4.equals(state5) : state5 != null) break block7;
            }
            this.recommissionWorker();
            return;
        }
        if (WorkerEventType.Graceful.equals(workerEventType) ? true : (WorkerEventType.Immediately.equals(workerEventType) ? true : WorkerEventType.Decommission.equals(workerEventType))) {
            this.exit(eventType);
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Worker receive event: ").append(eventType).append(", and has nothing to do ").toString());
    }

    public synchronized void checkIfNeedTransitionStatus() {
        PbWorkerStatus.State state = this.currentWorkerStatus().getState();
        if (PbWorkerStatus.State.InDecommissionThenIdle.equals(state) && this.decommissionThenIdleFinished()) {
            this.transitionState(PbWorkerStatus.State.Idle);
            return;
        }
    }

    private void exit(WorkerEventType eventType) {
        this.exitEventType_$eq(eventType);
        WorkerEventType workerEventType = this.exitEventType();
        if (WorkerEventType.Immediately.equals(workerEventType)) {
            this.transitionState(PbWorkerStatus.State.InExit);
        } else if (WorkerEventType.Graceful.equals(workerEventType)) {
            this.transitionState(PbWorkerStatus.State.InGraceFul);
        } else if (WorkerEventType.Decommission.equals(workerEventType)) {
            this.transitionState(PbWorkerStatus.State.InDecommission);
        }
        ThreadUtils$.MODULE$.newThread(new Runnable(null){

            public void run() {
                Thread.sleep(10000L);
                System.exit(0);
            }
        }, "worker-exit-thread").start();
    }

    public synchronized void transitionState(PbWorkerStatus.State state) {
        java.util.HashSet<PbWorkerStatus.State> allowStates = this.transitionStateMap().get(this.currentWorkerStatus().getState());
        if (allowStates != null && allowStates.contains(state)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Worker transition status from ").append(this.currentWorkerStatus().getState()).append(" to ").append(state).append(".").toString());
            this.currentWorkerStatus_$eq(new WorkerStatus(state.getNumber(), System.currentTimeMillis()));
            if (this.worker() != null && this.worker().workerInfo() != null) {
                this.worker().workerInfo().setWorkerStatus(this.currentWorkerStatus());
                return;
            }
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Worker transition status from ").append(this.currentWorkerStatus().getState()).append(" to ").append(state).append(" is not allowed.").toString());
    }

    private synchronized void recommissionWorker() {
        this.shutdown().set(false);
        this.transitionState(PbWorkerStatus.State.Normal);
    }

    private synchronized void decommissionWorkerThenIdle() {
        this.shutdown().set(true);
        this.transitionState(PbWorkerStatus.State.InDecommissionThenIdle);
        this.worker().sendWorkerDecommissionToMaster();
        this.checkIfNeedTransitionStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized boolean decommissionThenIdleFinished() {
        if (!this.shutdown().get()) return false;
        if (this.storageManager().shuffleKeySet().isEmpty()) return true;
        PbWorkerStatus.State state = this.currentWorkerStatus().getState();
        PbWorkerStatus.State state2 = PbWorkerStatus.State.Idle;
        if (state != null) {
            if (!state.equals(state2)) return false;
            return true;
        }
        if (state2 == null) return true;
        return false;
    }

    public PbWorkerStatus.State getWorkerState() {
        return this.currentWorkerStatus().getState();
    }

    private boolean inExitStatus() {
        return this.exitStatus().contains((Object)this.currentWorkerStatus().getState());
    }

    public WorkerStatusManager(CelebornConf conf) {
        Logging.$init$((Logging)this);
        this.currentWorkerStatus = WorkerStatus.normalWorkerStatus();
        this.exitEventType = WorkerEventType.Immediately;
        this.gracefulShutdown = conf.workerGracefulShutdown();
        if (this.gracefulShutdown()) {
            this.exitEventType_$eq(WorkerEventType.Graceful);
        }
        this.transitionStateMap = new HashMap();
        this.transitionStateMap().put(PbWorkerStatus.State.Normal, Sets.newHashSet((Object[])new PbWorkerStatus.State[]{PbWorkerStatus.State.InGraceFul, PbWorkerStatus.State.InExit, PbWorkerStatus.State.InDecommission, PbWorkerStatus.State.InDecommissionThenIdle}));
        this.transitionStateMap().put(PbWorkerStatus.State.InDecommissionThenIdle, Sets.newHashSet((Object[])new PbWorkerStatus.State[]{PbWorkerStatus.State.Normal, PbWorkerStatus.State.Idle, PbWorkerStatus.State.InGraceFul, PbWorkerStatus.State.InExit, PbWorkerStatus.State.InDecommission}));
        this.transitionStateMap().put(PbWorkerStatus.State.Idle, Sets.newHashSet((Object[])new PbWorkerStatus.State[]{PbWorkerStatus.State.Normal, PbWorkerStatus.State.InGraceFul, PbWorkerStatus.State.InExit, PbWorkerStatus.State.InDecommission}));
        this.transitionStateMap().put(PbWorkerStatus.State.InGraceFul, Sets.newHashSet((Object[])new PbWorkerStatus.State[]{PbWorkerStatus.State.Exit}));
        this.transitionStateMap().put(PbWorkerStatus.State.InDecommission, Sets.newHashSet((Object[])new PbWorkerStatus.State[]{PbWorkerStatus.State.Exit}));
        this.transitionStateMap().put(PbWorkerStatus.State.InExit, Sets.newHashSet((Object[])new PbWorkerStatus.State[]{PbWorkerStatus.State.Exit}));
        this.exitStatus = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PbWorkerStatus.State[]{PbWorkerStatus.State.InExit, PbWorkerStatus.State.Exit, PbWorkerStatus.State.InDecommission, PbWorkerStatus.State.InGraceFul}));
    }
}

