/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.ClientUtils$;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.ShuffleClientImpl;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornBroadcastException;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.exception.CelebornRuntimeException;
import org.apache.celeborn.common.exception.PartitionUnRetryAbleException;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbOpenStreamList;
import org.apache.celeborn.common.protocol.PbOpenStreamListResponse;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.PbStreamHandlerOpt;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.Aggregator;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.celeborn.ExceptionMakerHelper$;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.celeborn.CelebornPartitionUtil;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CelebornShuffleReader$;
import org.apache.spark.shuffle.celeborn.ExecutorShuffleIdTracker;
import org.apache.spark.shuffle.celeborn.SparkCommonUtils;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.spark.util.collection.ExternalSorter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Set$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u0014)\u0001MB\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"A\u0001\r\u0001B\u0001B\u0003%Q\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003^\u0011!\u0011\u0007A!A!\u0002\u0013i\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011!\u0004!\u0011!Q\u0001\n%D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\ti\u0002\u0011\t\u0011)A\u0005k\"A\u0001\u0010\u0001B\u0001B\u0003%\u0011\u0010C\u0003}\u0001\u0011\u0005Q\u0010\u0003\u0004}\u0001\u0011\u0005\u00111\u0004\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003wA\u0001\"!\u0013\u0001A\u0003%\u0011Q\b\u0005\n\u0003\u0017\u0002!\u0019!C\u0001\u0003\u001bB\u0001\"a\u0017\u0001A\u0003%\u0011q\n\u0005\n\u0003k\u0002!\u0019!C\u0005\u0003oB\u0001\"!(\u0001A\u0003%\u0011\u0011\u0010\u0005\n\u0003?\u0003!\u0019!C\u0005\u0003CCq!a)\u0001A\u0003%\u0011\u0010C\u0005\u0002&\u0002\u0011\r\u0011\"\u0003\u0002(\"9\u0011\u0011\u0016\u0001!\u0002\u0013i\u0006\"CAV\u0001\t\u0007I\u0011BAQ\u0011\u001d\ti\u000b\u0001Q\u0001\neD\u0011\"a,\u0001\u0005\u0004%I!!)\t\u000f\u0005E\u0006\u0001)A\u0005s\"9\u00111\u0017\u0001\u0005B\u0005U\u0006bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003_\u0004A\u0011AAy\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000b9qAa\b)\u0011\u0003\u0011\tC\u0002\u0004(Q!\u0005!1\u0005\u0005\u0007y\u0002\"\tA!\n\t\u0013\t\u001d\u0002\u00051A\u0005\u0002\t%\u0002\"\u0003B\u001aA\u0001\u0007I\u0011\u0001B\u001b\u0011!\u0011Y\u0004\tQ!\n\t-\u0002\"\u0003B\u001fAE\u0005I\u0011\u0001B \u0011%\u0011Y\u0006II\u0001\n\u0003\u0011iFA\u000bDK2,'m\u001c:o'\",hM\u001a7f%\u0016\fG-\u001a:\u000b\u0005%R\u0013\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005-b\u0013aB:ik\u001a4G.\u001a\u0006\u0003[9\nQa\u001d9be.T!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO\u000e\u0001Qc\u0001\u001bB\u0017N!\u0001!N\u001eN!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fMB!A(P K\u001b\u0005Q\u0013B\u0001 +\u00055\u0019\u0006.\u001e4gY\u0016\u0014V-\u00193feB\u0011\u0001)\u0011\u0007\u0001\t\u0015\u0011\u0005A1\u0001D\u0005\u0005Y\u0015C\u0001#H!\t1T)\u0003\u0002Go\t9aj\u001c;iS:<\u0007C\u0001\u001cI\u0013\tIuGA\u0002B]f\u0004\"\u0001Q&\u0005\u000b1\u0003!\u0019A\"\u0003\u0003\r\u0003\"AT)\u000e\u0003=S!\u0001\u0015\u0017\u0002\u0011%tG/\u001a:oC2L!AU(\u0003\u000f1{wmZ5oO\u00061\u0001.\u00198eY\u0016\u0004$!\u0016.\u0011\u000bY;v(\u0017&\u000e\u0003!J!\u0001\u0017\u0015\u0003+\r+G.\u001a2pe:\u001c\u0006.\u001e4gY\u0016D\u0015M\u001c3mKB\u0011\u0001I\u0017\u0003\n7\u0006\t\t\u0011!A\u0003\u0002\r\u00131a\u0018\u00132\u00039\u0019H/\u0019:u!\u0006\u0014H/\u001b;j_:\u0004\"A\u000e0\n\u0005};$aA%oi\u0006aQM\u001c3QCJ$\u0018\u000e^5p]\u0006i1\u000f^1si6\u000b\u0007/\u00138eKb\f1\"\u001a8e\u001b\u0006\u0004\u0018J\u001c3fq\u000691m\u001c8uKb$\bCA3g\u001b\u0005a\u0013BA4-\u0005-!\u0016m]6D_:$X\r\u001f;\u0002\t\r|gN\u001a\t\u0003U:l\u0011a\u001b\u0006\u0003Y6\faaY8n[>t'BA\u0015/\u0013\ty7N\u0001\u0007DK2,'m\u001c:o\u0007>tg-A\u0004nKR\u0014\u0018nY:\u0011\u0005q\u0012\u0018BA:+\u0005i\u0019\u0006.\u001e4gY\u0016\u0014V-\u00193NKR\u0014\u0018nY:SKB|'\u000f^3s\u0003A\u0019\b.\u001e4gY\u0016LE\r\u0016:bG.,'\u000f\u0005\u0002Wm&\u0011q\u000f\u000b\u0002\u0019\u000bb,7-\u001e;peNCWO\u001a4mK&#GK]1dW\u0016\u0014\u0018A\u00048fK\u0012$UmY8naJ,7o\u001d\t\u0003miL!a_\u001c\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"BC`@\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001\u0003\u0002,\u0001\u007f)CaaU\u0006A\u0002\u0005\u0005\u0001\u0007BA\u0002\u0003\u000f\u0001bAV,@\u0003\u000bQ\u0005c\u0001!\u0002\b\u0011I1l`A\u0001\u0002\u0003\u0015\ta\u0011\u0005\u00069.\u0001\r!\u0018\u0005\u0006A.\u0001\r!\u0018\u0005\bC.\u0001\n\u00111\u0001^\u0011\u001d\u00117\u0002%AA\u0002uCQaY\u0006A\u0002\u0011DQ\u0001[\u0006A\u0002%DQ\u0001]\u0006A\u0002EDQ\u0001^\u0006A\u0002UDQ\u0001_\u0006A\u0002e$2C`A\u000f\u0003S\tY#!\f\u00020\u0005E\u00121GA\u001b\u0003oAaa\u0015\u0007A\u0002\u0005}\u0001\u0007BA\u0011\u0003K\u0001bAV,@\u0003GQ\u0005c\u0001!\u0002&\u0011Y\u0011qEA\u000f\u0003\u0003\u0005\tQ!\u0001D\u0005\ryFE\r\u0005\u000692\u0001\r!\u0018\u0005\u0006A2\u0001\r!\u0018\u0005\u0006C2\u0001\r!\u0018\u0005\u0006E2\u0001\r!\u0018\u0005\u0006G2\u0001\r\u0001\u001a\u0005\u0006Q2\u0001\r!\u001b\u0005\u0006a2\u0001\r!\u001d\u0005\u0006i2\u0001\r!^\u0001\u0004I\u0016\u0004XCAA\u001fa\u0011\ty$a\u0012\u0011\u000f\u0015\f\tePA#\u0015&\u0019\u00111\t\u0017\u0003#MCWO\u001a4mK\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010E\u0002A\u0003\u000f\"\u0011bW\u0001\u0002\u0002\u0003\u0005)\u0011A\"\u0002\t\u0011,\u0007\u000fI\u0001\u000eg\",hM\u001a7f\u00072LWM\u001c;\u0016\u0005\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005US.\u0001\u0004dY&,g\u000e^\u0005\u0005\u00033\n\u0019FA\u0007TQV4g\r\\3DY&,g\u000e^\u0001\u000fg\",hM\u001a7f\u00072LWM\u001c;!Q\r\u0001\u0012q\f\t\u0005\u0003C\n\t(\u0004\u0002\u0002d)!\u0011Q\rB9\u0003-\tgN\\8uCRLwN\\:\u000b\u00071\u0014iH\u0003\u0003\u0002l\u00055\u0014AB4p_\u001edWM\u0003\u0002\u0002p\u0005\u00191m\\7\n\t\u0005M\u00141\r\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0017\u0001D3yG\u0016\u0004H/[8o%\u00164WCAA=!\u0019\tY(!$\u0002\u00126\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003\u0007\u000b))\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\"\u0002\n\u0006!Q\u000f^5m\u0015\t\tY)\u0001\u0003kCZ\f\u0017\u0002BAH\u0003{\u0012q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*!\u0011qSAE\u0003\tIw.\u0003\u0003\u0002\u001c\u0006U%aC%P\u000bb\u001cW\r\u001d;j_:\fQ\"\u001a=dKB$\u0018n\u001c8SK\u001a\u0004\u0013!E:uC\u001e,'+\u001a:v]\u0016s\u0017M\u00197fIV\t\u00110\u0001\nti\u0006<WMU3sk:,e.\u00192mK\u0012\u0004\u0013\u0001E3oG>$W\rZ!ui\u0016l\u0007\u000f^%e+\u0005i\u0016!E3oG>$W\rZ!ui\u0016l\u0007\u000f^%eA\u0005!\u0002/^:i%\u0016\u0004H.[2bi\u0016,e.\u00192mK\u0012\fQ\u0003];tQJ+\u0007\u000f\\5dCR,WI\\1cY\u0016$\u0007%A\tqe\u00164WM\u001d*fa2L7-\u0019*fC\u0012\f!\u0003\u001d:fM\u0016\u0014(+\u001a9mS\u000e\f'+Z1eA\u0005!!/Z1e)\t\t9\f\u0005\u0004\u0002:\u0006%\u0017q\u001a\b\u0005\u0003w\u000b)M\u0004\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tMM\u0001\u0007yI|w\u000e\u001e \n\u0003aJ1!a28\u0003\u001d\u0001\u0018mY6bO\u0016LA!a3\u0002N\nA\u0011\n^3sCR|'OC\u0002\u0002H^\u0002RANAi\u007f)K1!a58\u0005!\u0001&o\u001c3vGR\u0014\u0014aM2iK\u000e\\\u0017I\u001c3SKB|'\u000f\u001e$fi\u000eDg)Y5mkJ,gi\u001c:Va\u0012\fG/\u001a$jY\u0016<%o\\;q\r\u0006LG.\u001e:f)\u0019\tI.a8\u0002dB\u0019a'a7\n\u0007\u0005uwG\u0001\u0003V]&$\bBBAq9\u0001\u0007Q,A\tdK2,'m\u001c:o'\",hM\u001a7f\u0013\u0012Dq!!:\u001d\u0001\u0004\t9/\u0001\u0002dKB!\u0011\u0011XAu\u0013\u0011\tY/!4\u0003\u0013QC'o\\<bE2,\u0007f\u0001\u000f\u0002`\u0005)\u0002.\u00198eY\u00164U\r^2i\u000bb\u001cW\r\u001d;j_:\u001cH#\u0003#\u0002t\u0006]\u00181`A\u0000\u0011\u0019\t)0\ba\u0001;\u0006a\u0011\r\u001d9TQV4g\r\\3JI\"1\u0011\u0011`\u000fA\u0002u\u000b\u0011b\u001d5vM\u001adW-\u00133\t\r\u0005uX\u00041\u0001^\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\u0005\u0015X\u00041\u0001\u0002h\"\u001aQ$a\u0018\u0002+9,woU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dKR!!q\u0001B\n!\u0011\u0011IAa\u0004\u000e\u0005\t-!b\u0001B\u0007Y\u0005Q1/\u001a:jC2L'0\u001a:\n\t\tE!1\u0002\u0002\u0013'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\rC\u0004\u0002:y\u0001\rA!\u00061\t\t]!1\u0004\t\bK\u0006\u0005sH!\u0007K!\r\u0001%1\u0004\u0003\f\u0005;\u0011\u0019\"!A\u0001\u0002\u000b\u00051IA\u0002`IQ\nQcQ3mK\n|'O\\*ik\u001a4G.\u001a*fC\u0012,'\u000f\u0005\u0002WAM\u0011\u0001%\u000e\u000b\u0003\u0005C\t\u0011c\u001d;sK\u0006l7I]3bi>\u0014\bk\\8m+\t\u0011Y\u0003\u0005\u0003\u0003.\t=RBAAA\u0013\u0011\u0011\t$!!\u0003%QC'/Z1e!>|G.\u0012=fGV$xN]\u0001\u0016gR\u0014X-Y7De\u0016\fGo\u001c:Q_>dw\fJ3r)\u0011\tINa\u000e\t\u0013\te2%!AA\u0002\t-\u0012a\u0001=%c\u0005\u00112\u000f\u001e:fC6\u001c%/Z1u_J\u0004vn\u001c7!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU1!\u0011\tB,\u00053*\"Aa\u0011+\u0007u\u0013)e\u000b\u0002\u0003HA!!\u0011\nB*\u001b\t\u0011YE\u0003\u0003\u0003N\t=\u0013!C;oG\",7m[3e\u0015\r\u0011\tfN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B+\u0005\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015\u0011UE1\u0001D\t\u0015aUE1\u0001D\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU1!\u0011\tB0\u0005C\"QA\u0011\u0014C\u0002\r#Q\u0001\u0014\u0014C\u0002\rS\u0011!\r\u0006\u0004_\t\r$bA\u0015\u0003f\u000511\u000f[1eK\u0012TAA!\u001b\u0003h)!\u0011q\u000eB6\u0015\u0011\tYG!\u001c\u000b\u00071\u0014yGC\u00012\u0015\ry#1\u000f\u0006\u0004S\tU$\u0002\u0002B5\u0005oRA!a\u001c\u0003z)!\u00111\u000eB>\u0001")
public class CelebornShuffleReader<K, C>
implements ShuffleReader<K, C>,
Logging {
    private final CelebornShuffleHandle<K, ?, C> handle;
    private final int startPartition;
    private final int endPartition;
    private final int startMapIndex;
    private final int endMapIndex;
    private final TaskContext context;
    private final CelebornConf conf;
    public final ShuffleReadMetricsReporter org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics;
    private final ExecutorShuffleIdTracker shuffleIdTracker;
    private final boolean needDecompress;
    private final ShuffleDependency<K, ?, C> dep;
    @VisibleForTesting
    private final ShuffleClient shuffleClient;
    private final AtomicReference<IOException> exceptionRef;
    private final boolean stageRerunEnabled;
    private final int encodedAttemptId;
    private final boolean pushReplicateEnabled;
    private final boolean preferReplicaRead;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <K, C> int $lessinit$greater$default$5() {
        return CelebornShuffleReader$.MODULE$.$lessinit$greater$default$5();
    }

    public static <K, C> int $lessinit$greater$default$4() {
        return CelebornShuffleReader$.MODULE$.$lessinit$greater$default$4();
    }

    public static void streamCreatorPool_$eq(ThreadPoolExecutor threadPoolExecutor) {
        CelebornShuffleReader$.MODULE$.streamCreatorPool_$eq(threadPoolExecutor);
    }

    public static ThreadPoolExecutor streamCreatorPool() {
        return CelebornShuffleReader$.MODULE$.streamCreatorPool();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ShuffleDependency<K, ?, C> dep() {
        return this.dep;
    }

    public ShuffleClient shuffleClient() {
        return this.shuffleClient;
    }

    private AtomicReference<IOException> exceptionRef() {
        return this.exceptionRef;
    }

    private boolean stageRerunEnabled() {
        return this.stageRerunEnabled;
    }

    private int encodedAttemptId() {
        return this.encodedAttemptId;
    }

    private boolean pushReplicateEnabled() {
        return this.pushReplicateEnabled;
    }

    private boolean preferReplicaRead() {
        return this.preferReplicaRead;
    }

    public Iterator<Product2<K, C>> read() {
        InterruptibleIterator resultIter;
        InterruptibleIterator interruptibleIterator;
        int n;
        long startTime = System.currentTimeMillis();
        SerializerInstance serializerInstance = this.newSerializerInstance(this.dep());
        try {
            n = SparkUtils.celebornShuffleId(this.shuffleClient(), this.handle, this.context, Predef$.MODULE$.boolean2Boolean(false));
        }
        catch (CelebornRuntimeException e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to get shuffleId for appShuffleId ").append($this.handle.shuffleId()).toString(), e);
            if (this.stageRerunEnabled()) {
                throw new FetchFailedException(null, this.handle.shuffleId(), -1L, -1, this.startPartition, new StringBuilder(47).append("Celeborn FetchFailure appShuffleId/shuffleId: ").append(this.handle.shuffleId()).append("/").append(this.handle.shuffleId()).toString(), (Throwable)e);
            }
            throw e;
        }
        int shuffleId = n;
        this.shuffleIdTracker.track(this.handle.shuffleId(), shuffleId);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("get shuffleId ").append(shuffleId).append(" for appShuffleId ").append($this.handle.shuffleId()).append(" attemptNum ").append($this.context.stageAttemptNumber()).toString());
        MetricsCallback metricsCallback = new MetricsCallback(this){
            private final /* synthetic */ CelebornShuffleReader $outer;

            public void incDuplicateBytesRead(long x$1) {
                MetricsCallback.super.incDuplicateBytesRead(x$1);
            }

            public void incBytesRead(long bytesWritten) {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRemoteBytesRead(bytesWritten);
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRemoteBlocksFetched(1L);
            }

            public void incReadTime(long time) {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incFetchWaitTime(time);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        if (CelebornShuffleReader$.MODULE$.streamCreatorPool() == null) {
            CelebornShuffleReader$ celebornShuffleReader$ = CelebornShuffleReader$.MODULE$;
            synchronized (celebornShuffleReader$) {
                if (CelebornShuffleReader$.MODULE$.streamCreatorPool() == null) {
                    CelebornShuffleReader$.MODULE$.streamCreatorPool_$eq(ThreadUtils$.MODULE$.newDaemonCachedThreadPool("celeborn-create-stream-thread", this.conf.readStreamCreatorPoolThreads(), 60));
                }
            }
        }
        long fetchTimeoutMs = this.conf.clientFetchTimeoutMs();
        boolean localFetchEnabled = this.conf.enableReadLocalShuffleFile();
        String localHostAddress = Utils$.MODULE$.localHostName(this.conf);
        String shuffleKey = Utils$.MODULE$.makeShuffleKey(this.handle.appUniqueId(), shuffleId);
        ObjectRef fileGroups = ObjectRef.create(null);
        boolean isShuffleStageEnd = false;
        IntRef updateFileGroupsRetryTimes = IntRef.create((int)0);
        do {
            isShuffleStageEnd = this.liftedTree1$1(shuffleId);
            try {
                fileGroups.elem = this.shuffleClient().updateFileGroup(shuffleId, this.startPartition);
            }
            catch (Throwable throwable) {
                CelebornIOException celebornIOException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CelebornIOException && (celebornIOException = (CelebornIOException)throwable2).getCause() != null && celebornIOException.getCause() instanceof TimeoutException && !isShuffleStageEnd) {
                    ++updateFileGroupsRetryTimes.elem;
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("UpdateFileGroup for ").append(shuffleKey).append(" timeout due to shuffle stage not ended,").append(" retry again, retry times ").append(updateFileGroupsRetryTimes$1.elem).toString(), celebornIOException);
                    continue;
                }
                if (throwable2 instanceof CelebornIOException ? true : throwable2 instanceof PartitionUnRetryAbleException) {
                    this.checkAndReportFetchFailureForUpdateFileGroupFailure(shuffleId, throwable2);
                    continue;
                }
                throw throwable;
            }
        } while ((ShuffleClientImpl.ReduceFileGroups)fileGroups.elem == null);
        long batchOpenStreamStartTime = System.currentTimeMillis();
        HashMap workerRequestMap = new HashMap();
        HashMap partitionId2ChunkRange = new HashMap();
        HashMap partitionId2PartitionLocations = new HashMap();
        IntRef partCnt = IntRef.create((int)0);
        boolean splitSkewPartitionWithoutMapRange = ClientUtils$.MODULE$.readSkewPartitionWithoutMapRange(this.conf, this.startMapIndex, this.endMapIndex);
        List partitionIdList = (List)((TraversableLike)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)this.startPartition), (Object)BoxesRunTime.boxToInteger((int)this.endPartition), (Integral)Numeric.IntIsIntegral$.MODULE$)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)p -> ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.containsKey(BoxesRunTime.boxToInteger((int)p)));
        partitionIdList.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            if (((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.containsKey(BoxesRunTime.boxToInteger((int)partitionId))) {
                Set locations;
                Set originLocations = ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.get(BoxesRunTime.boxToInteger((int)partitionId));
                boolean hasReplicate = this.pushReplicateEnabled() && ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(originLocations).asScala()).exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)CelebornShuffleReader.$anonfun$read$10(p)));
                Set set = locations = this.preferReplicaRead() && hasReplicate ? (Set)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(originLocations).asScala()).map((Function1 & Serializable & scala.Serializable)p -> {
                    if (p != null && p.hasPeer()) {
                        return p.getPeer();
                    }
                    return p;
                }, Set$.MODULE$.canBuildFrom())).asJava() : originLocations;
                if (splitSkewPartitionWithoutMapRange) {
                    Map<String, Pair<Integer, Integer>> partitionLocation2ChunkRange = CelebornPartitionUtil.splitSkewedPartitionLocations(new ArrayList<PartitionLocation>(locations), $this.startMapIndex, $this.endMapIndex);
                    partitionId2ChunkRange.put(BoxesRunTime.boxToInteger((int)partitionId), partitionLocation2ChunkRange);
                    scala.collection.mutable.Set filterLocations = (scala.collection.mutable.Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(locations).asScala()).filter((Function1 & Serializable & scala.Serializable)location -> BoxesRunTime.boxToBoolean((boolean)CelebornShuffleReader.$anonfun$read$12(partitionLocation2ChunkRange, location)));
                    locations = (Set)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(filterLocations).asJava();
                }
                partitionId2PartitionLocations.put(BoxesRunTime.boxToInteger((int)partitionId), locations);
                this.makeOpenStreamList$1(locations, partCnt, workerRequestMap, shuffleKey, localFetchEnabled, localHostAddress);
                return;
            }
        });
        ConcurrentHashMap locationStreamHandlerMap = JavaUtils.newConcurrentHashMap();
        List futures = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(workerRequestMap.values()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable(null, (Tuple3)entry, fetchTimeoutMs, locationStreamHandlerMap){
            private final Tuple3 entry$1;
            private final long fetchTimeoutMs$1;
            private final ConcurrentHashMap locationStreamHandlerMap$1;

            public void run() {
                PbOpenStreamListResponse pbOpenStreamListResponse;
                PbOpenStreamListResponse pbOpenStreamListResponse2;
                Tuple3 tuple3 = this.entry$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                TransportClient client = (TransportClient)tuple3._1();
                ArrayList locArr = (ArrayList)tuple3._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder = (PbOpenStreamList.Builder)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)client, (Object)locArr, (Object)pbOpenStreamListBuilder);
                TransportClient client2 = (TransportClient)tuple32._1();
                ArrayList locArr2 = (ArrayList)tuple32._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder2 = (PbOpenStreamList.Builder)tuple32._3();
                TransportMessage msg = new TransportMessage(MessageType.BATCH_OPEN_STREAM, pbOpenStreamListBuilder2.build().toByteArray());
                try {
                    ByteBuffer response = client2.sendRpcSync(msg.toByteBuffer(), this.fetchTimeoutMs$1);
                    pbOpenStreamListResponse2 = (PbOpenStreamListResponse)TransportMessage.fromByteBuffer(response).getParsedPayload();
                }
                catch (Exception exception) {
                    pbOpenStreamListResponse2 = pbOpenStreamListResponse = null;
                }
                if (pbOpenStreamListResponse != null) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), locArr2.size()).foreach((Function1 & Serializable & scala.Serializable)idx -> $anon$2.$anonfun$run$1(this, pbOpenStreamListResponse, locArr2, BoxesRunTime.unboxToInt((Object)idx)));
                    return;
                }
            }

            public static final /* synthetic */ Object $anonfun$run$1($anon$2 $this, PbOpenStreamListResponse pbOpenStreamListResponse$1, ArrayList locArr$1, int idx) {
                PbStreamHandlerOpt streamHandlerOpt = pbOpenStreamListResponse$1.getStreamHandlerOptList().get(idx);
                if (streamHandlerOpt.getStatus() == StatusCode.SUCCESS.getValue()) {
                    return $this.locationStreamHandlerMap$1.put(locArr$1.get(idx), streamHandlerOpt.getStreamHandler());
                }
                return BoxedUnit.UNIT;
            }
            {
                this.entry$1 = entry$1;
                this.fetchTimeoutMs$1 = fetchTimeoutMs$1;
                this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.shuffle.celeborn.CelebornShuffleReader$$anon$2 org.apache.celeborn.common.protocol.PbOpenStreamListResponse java.util.ArrayList java.lang.Object )}, serializedLambda);
            }
        }), Iterable$.MODULE$.canBuildFrom())).toList();
        futures.foreach((Function1 & Serializable & scala.Serializable)f -> f.get());
        long end = System.currentTimeMillis();
        metricsCallback.incReadTime(end - startTime);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("BatchOpenStream for ").append(partCnt$1.elem).append(" cost ").append(end - batchOpenStreamStartTime).append("ms").toString());
        ConcurrentHashMap streams = JavaUtils.newConcurrentHashMap();
        int inputStreamCreationWindow = this.conf.clientInputStreamCreationWindow();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Math.min(inputStreamCreationWindow, partitionIdList.size())).foreach((Function1 & Serializable & scala.Serializable)listIndex -> CelebornShuffleReader.$anonfun$read$19(this, partitionIdList, partitionId2PartitionLocations, locationStreamHandlerMap, shuffleId, fileGroups, partitionId2ChunkRange, metricsCallback, streams, BoxesRunTime.unboxToInt((Object)listIndex)));
        IntRef curIndex = IntRef.create((int)0);
        Iterator recordIter = partitionIdList.iterator().map((Function1 & Serializable & scala.Serializable)partitionId -> CelebornShuffleReader.$anonfun$read$20(this, streams, shuffleId, metricsCallback, curIndex, inputStreamCreationWindow, partitionIdList, partitionId2PartitionLocations, locationStreamHandlerMap, fileGroups, partitionId2ChunkRange, BoxesRunTime.unboxToInt((Object)partitionId))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CelebornShuffleReader.$anonfun$read$24(x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int partitionId = tuple2._1$mcI$sp();
                CelebornInputStream inputStream = (CelebornInputStream)tuple2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)serializerInstance.deserializeStream((InputStream)inputStream).asKeyValueIterator());
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Iterator iterator;
                int partitionId = tuple2._1$mcI$sp();
                Iterator iter = (Iterator)tuple2._2();
                try {
                    iterator = iter;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof CelebornIOException ? true : throwable2 instanceof PartitionUnRetryAbleException) {
                        throw this.handleFetchExceptions($this.handle.shuffleId(), shuffleId, partitionId, throwable2);
                    }
                    throw throwable;
                }
                return iterator;
            }
            throw new MatchError((Object)tuple2);
        });
        Iterator iterWithUpdatedRecordsRead = recordIter.map((Function1 & Serializable & scala.Serializable)record -> {
            $this.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRecordsRead(1L);
            return record;
        });
        CompletionIterator metricIter = CompletionIterator$.MODULE$.apply(iterWithUpdatedRecordsRead, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.context.taskMetrics().mergeShuffleReadMetrics());
        InterruptibleIterator interruptibleIter = new InterruptibleIterator(this.context, (Iterator)metricIter);
        if (this.dep().keyOrdering().isDefined()) {
            ExternalSorter externalSorter;
            if (this.dep().aggregator().isDefined()) {
                if (this.dep().mapSideCombine()) {
                    TaskContext x$1 = this.context;
                    Option x$2 = Option$.MODULE$.apply((Object)new Aggregator((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x), ((Aggregator)this.dep().aggregator().get()).mergeCombiners(), ((Aggregator)this.dep().aggregator().get()).mergeCombiners()));
                    Some x$32 = new Some(this.dep().keyOrdering().get());
                    Serializer x$4 = this.dep().serializer();
                    Option x$5 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                    externalSorter = new ExternalSorter(x$1, x$2, x$5, (Option)x$32, x$4);
                } else {
                    TaskContext x$6 = this.context;
                    Option x$7 = this.dep().aggregator();
                    Some x$8 = new Some(this.dep().keyOrdering().get());
                    Serializer x$9 = this.dep().serializer();
                    Option x$10 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                    externalSorter = new ExternalSorter(x$6, x$7, x$10, (Option)x$8, x$9);
                }
            } else {
                TaskContext x$11 = this.context;
                Some x$12 = new Some(this.dep().keyOrdering().get());
                Serializer x$13 = this.dep().serializer();
                None$ x$14 = ExternalSorter$.MODULE$.$lessinit$greater$default$2();
                Option x$15 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                externalSorter = new ExternalSorter(x$11, (Option)x$14, x$15, (Option)x$12, x$13);
            }
            ExternalSorter sorter = externalSorter;
            sorter.insertAll((Iterator)interruptibleIter);
            this.context.taskMetrics().incMemoryBytesSpilled(sorter.memoryBytesSpilled());
            this.context.taskMetrics().incDiskBytesSpilled(sorter.diskBytesSpilled());
            this.context.taskMetrics().incPeakExecutionMemory(sorter.peakMemoryUsedBytes());
            this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                sorter.stop();
                return BoxedUnit.UNIT;
            });
            interruptibleIterator = CompletionIterator$.MODULE$.apply(sorter.iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sorter.stop());
        } else if (this.dep().aggregator().isDefined()) {
            if (this.dep().mapSideCombine()) {
                InterruptibleIterator combinedKeyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineCombinersByKey((Iterator)combinedKeyValuesIterator, this.context);
            } else {
                InterruptibleIterator keyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineValuesByKey((Iterator)keyValuesIterator, this.context);
            }
        } else {
            interruptibleIterator = interruptibleIter;
        }
        InterruptibleIterator interruptibleIterator2 = resultIter = interruptibleIterator;
        if (interruptibleIterator2 instanceof InterruptibleIterator) {
            return resultIter;
        }
        return new InterruptibleIterator(this.context, (Iterator)resultIter);
    }

    @VisibleForTesting
    public void checkAndReportFetchFailureForUpdateFileGroupFailure(int celebornShuffleId, Throwable ce) {
        if (ce.getCause() != null && (ce.getCause() instanceof InterruptedException || ce.getCause() instanceof TimeoutException || ce.getCause() instanceof CelebornBroadcastException)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("fetch shuffle ").append(celebornShuffleId).append(" timeout or interrupt or GetReducerFileGroupResponse failed via broadcast").toString(), ce);
            throw ce;
        }
        throw this.handleFetchExceptions(this.handle.shuffleId(), celebornShuffleId, 0, ce);
    }

    @VisibleForTesting
    public Nothing$ handleFetchExceptions(int appShuffleId, int shuffleId, int partitionId, Throwable ce) {
        if (this.stageRerunEnabled() && this.shuffleClient().reportShuffleFetchFailure(appShuffleId, shuffleId, this.context.taskAttemptId())) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handle fetch exceptions for ").append(shuffleId).append("-").append(partitionId).toString(), ce);
            throw new FetchFailedException(null, appShuffleId, -1L, -1, partitionId, new StringBuilder(47).append("Celeborn FetchFailure appShuffleId/shuffleId: ").append(appShuffleId).append("/").append(shuffleId).toString(), ce);
        }
        throw ce;
    }

    public SerializerInstance newSerializerInstance(ShuffleDependency<K, ?, C> dep) {
        return dep.serializer().newInstance();
    }

    private final /* synthetic */ boolean liftedTree1$1(int shuffleId$1) {
        boolean bl;
        try {
            bl = this.shuffleClient().isShuffleStageEnd(shuffleId$1);
        }
        catch (Exception e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Failed to check shuffle stage end for ").append(shuffleId$1).append(", assume ended").toString(), e);
            bl = true;
        }
        return bl;
    }

    private final void makeOpenStreamList$1(Set locations, IntRef partCnt$1, HashMap workerRequestMap$1, String shuffleKey$1, boolean localFetchEnabled$1, String localHostAddress$1) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(locations).asScala()).foreach((Function1 & Serializable & scala.Serializable)location -> {
            Tuple3 tuple3;
            BoxedUnit boxedUnit;
            ++partCnt$1.elem;
            String hostPort = location.hostAndFetchPort();
            if (!workerRequestMap$1.containsKey(hostPort)) {
                try {
                    TransportClient client = this.shuffleClient().getDataClientFactory().createClient(location.getHost(), location.getFetchPort());
                    PbOpenStreamList.Builder pbOpenStreamList = PbOpenStreamList.newBuilder();
                    pbOpenStreamList.setShuffleKey(shuffleKey$1);
                    boxedUnit = workerRequestMap$1.put(hostPort, new Tuple3((Object)client, new ArrayList(), (Object)pbOpenStreamList));
                }
                catch (Exception ex) {
                    this.shuffleClient().excludeFailedFetchLocation(hostPort, ex);
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to create client for ").append(shuffleKey$1).append("-").append(location.getId()).append(" from host: ").append(hostPort).append(". ").append("Shuffle reader will try its replica if exists.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if ((tuple3 = (Tuple3)workerRequestMap$1.get(hostPort)) != null) {
                ArrayList locArr = (ArrayList)tuple3._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder = (PbOpenStreamList.Builder)tuple3._3();
                locArr.add(location);
                pbOpenStreamListBuilder.addFileName(location.getFileName()).addStartIndex($this.startMapIndex).addEndIndex($this.endMapIndex);
                return pbOpenStreamListBuilder.addReadLocalShuffle(localFetchEnabled$1 && location.getHost().equals(localHostAddress$1));
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Empty client for host ").append(hostPort).toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$read$10(PartitionLocation p) {
        return p != null && p.hasPeer();
    }

    public static final /* synthetic */ boolean $anonfun$read$12(Map partitionLocation2ChunkRange$1, PartitionLocation location) {
        return partitionLocation2ChunkRange$1 != null && partitionLocation2ChunkRange$1.containsKey(location.getUniqueId());
    }

    public final void org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(int partitionId, HashMap partitionId2PartitionLocations$1, ConcurrentHashMap locationStreamHandlerMap$1, int shuffleId$1, ObjectRef fileGroups$1, HashMap partitionId2ChunkRange$1, MetricsCallback metricsCallback$1, ConcurrentHashMap streams$1) {
        ArrayList<PbStreamHandler> streamHandlers;
        ArrayList<PbStreamHandler> arrayList;
        ArrayList<PartitionLocation> locationList;
        Set locations = (Set)partitionId2PartitionLocations$1.get(BoxesRunTime.boxToInteger((int)partitionId));
        ArrayList<PartitionLocation> arrayList2 = locationList = locations == null ? new ArrayList<PartitionLocation>() : new ArrayList(locations);
        if (locations != null) {
            ArrayList<PbStreamHandler> streamHandlerArr = new ArrayList<PbStreamHandler>(locationList.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(locationList).asScala()).foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)streamHandlerArr.add(locationStreamHandlerMap$1.get(loc))));
            arrayList = streamHandlerArr;
        } else {
            arrayList = streamHandlers = null;
        }
        if (this.exceptionRef().get() == null) {
            try {
                CelebornInputStream inputStream = this.shuffleClient().readPartition(shuffleId$1, this.handle.shuffleId(), partitionId, this.encodedAttemptId(), this.context.taskAttemptId(), this.startMapIndex, this.endMapIndex, this.stageRerunEnabled() ? ExceptionMakerHelper$.MODULE$.SHUFFLE_FETCH_FAILURE_EXCEPTION_MAKER() : null, locationList, streamHandlers, ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).pushFailedBatches, (Map)partitionId2ChunkRange$1.get(BoxesRunTime.boxToInteger((int)partitionId)), ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).mapAttempts, metricsCallback$1, this.needDecompress);
                streams$1.put(Predef$.MODULE$.int2Integer(partitionId), inputStream);
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Exception caught when readPartition ").append(partitionId).append("!").toString(), e);
                this.exceptionRef().compareAndSet(null, e);
            }
            catch (Throwable e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Non IOException caught when readPartition ").append(partitionId).append("!").toString(), e);
                this.exceptionRef().compareAndSet(null, new CelebornIOException(e));
            }
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$read$19(CelebornShuffleReader $this, List partitionIdList$1, HashMap partitionId2PartitionLocations$1, ConcurrentHashMap locationStreamHandlerMap$1, int shuffleId$1, ObjectRef fileGroups$1, HashMap partitionId2ChunkRange$1, MetricsCallback metricsCallback$1, ConcurrentHashMap streams$1, int listIndex) {
        return CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable($this, partitionIdList$1, listIndex, partitionId2PartitionLocations$1, locationStreamHandlerMap$1, shuffleId$1, fileGroups$1, partitionId2ChunkRange$1, metricsCallback$1, streams$1){
            private final /* synthetic */ CelebornShuffleReader $outer;
            private final List partitionIdList$1;
            private final int listIndex$1;
            private final HashMap partitionId2PartitionLocations$1;
            private final ConcurrentHashMap locationStreamHandlerMap$1;
            private final int shuffleId$1;
            private final ObjectRef fileGroups$1;
            private final HashMap partitionId2ChunkRange$1;
            private final MetricsCallback metricsCallback$1;
            private final ConcurrentHashMap streams$1;

            public void run() {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(BoxesRunTime.unboxToInt((Object)this.partitionIdList$1.apply(this.listIndex$1)), this.partitionId2PartitionLocations$1, this.locationStreamHandlerMap$1, this.shuffleId$1, this.fileGroups$1, this.partitionId2ChunkRange$1, this.metricsCallback$1, this.streams$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionIdList$1 = partitionIdList$1;
                this.listIndex$1 = listIndex$1;
                this.partitionId2PartitionLocations$1 = partitionId2PartitionLocations$1;
                this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
                this.shuffleId$1 = shuffleId$1;
                this.fileGroups$1 = fileGroups$1;
                this.partitionId2ChunkRange$1 = partitionId2ChunkRange$1;
                this.metricsCallback$1 = metricsCallback$1;
                this.streams$1 = streams$1;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$read$23(ObjectRef inputStream$1, TaskContext x$2) {
        ((CelebornInputStream)inputStream$1.elem).close();
    }

    public static final /* synthetic */ Tuple2 $anonfun$read$20(CelebornShuffleReader $this, ConcurrentHashMap streams$1, int shuffleId$1, MetricsCallback metricsCallback$1, IntRef curIndex$1, int inputStreamCreationWindow$1, List partitionIdList$1, HashMap partitionId2PartitionLocations$1, ConcurrentHashMap locationStreamHandlerMap$1, ObjectRef fileGroups$1, HashMap partitionId2ChunkRange$1, int partitionId) {
        if ($this.handle.numMappers() > 0) {
            Object object;
            long startFetchWait = System.nanoTime();
            ObjectRef inputStream = ObjectRef.create((Object)((CelebornInputStream)streams$1.get(BoxesRunTime.boxToInteger((int)partitionId))));
            LongRef sleepCnt = LongRef.create((long)0L);
            while ((CelebornInputStream)inputStream.elem == null) {
                if ($this.exceptionRef().get() != null) {
                    IOException iOException = $this.exceptionRef().get();
                    if (iOException instanceof CelebornIOException ? true : iOException instanceof PartitionUnRetryAbleException) {
                        throw $this.handleFetchExceptions($this.handle.shuffleId(), shuffleId$1, partitionId, iOException);
                    }
                    throw iOException;
                }
                if (sleepCnt.elem == 0L) {
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("inputStream for partition: ").append(partitionId).append(" is null, sleeping 5ms").toString());
                }
                ++sleepCnt.elem;
                Thread.sleep(5L);
                inputStream.elem = (CelebornInputStream)streams$1.get(BoxesRunTime.boxToInteger((int)partitionId));
            }
            if (sleepCnt.elem > 0L) {
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("inputStream for partition: ").append(partitionId).append(" is not null, sleep ").append(sleepCnt$1.elem).append(" times for ").append(5L * sleepCnt$1.elem).append(" ms").toString());
            }
            metricsCallback$1.incReadTime(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startFetchWait));
            $this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
                CelebornShuffleReader.$anonfun$read$23(inputStream, x$2);
                return BoxedUnit.UNIT;
            });
            if (curIndex$1.elem + inputStreamCreationWindow$1 < partitionIdList$1.size()) {
                int nextPartitionId = BoxesRunTime.unboxToInt((Object)partitionIdList$1.apply(curIndex$1.elem + inputStreamCreationWindow$1));
                object = CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable($this, nextPartitionId, partitionId2PartitionLocations$1, locationStreamHandlerMap$1, shuffleId$1, fileGroups$1, partitionId2ChunkRange$1, metricsCallback$1, streams$1){
                    private final /* synthetic */ CelebornShuffleReader $outer;
                    private final int nextPartitionId$1;
                    private final HashMap partitionId2PartitionLocations$1;
                    private final ConcurrentHashMap locationStreamHandlerMap$1;
                    private final int shuffleId$1;
                    private final ObjectRef fileGroups$1;
                    private final HashMap partitionId2ChunkRange$1;
                    private final MetricsCallback metricsCallback$1;
                    private final ConcurrentHashMap streams$1;

                    public void run() {
                        this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(this.nextPartitionId$1, this.partitionId2PartitionLocations$1, this.locationStreamHandlerMap$1, this.shuffleId$1, this.fileGroups$1, this.partitionId2ChunkRange$1, this.metricsCallback$1, this.streams$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nextPartitionId$1 = nextPartitionId$1;
                        this.partitionId2PartitionLocations$1 = partitionId2PartitionLocations$1;
                        this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
                        this.shuffleId$1 = shuffleId$1;
                        this.fileGroups$1 = fileGroups$1;
                        this.partitionId2ChunkRange$1 = partitionId2ChunkRange$1;
                        this.metricsCallback$1 = metricsCallback$1;
                        this.streams$1 = streams$1;
                    }
                });
            } else {
                object = BoxedUnit.UNIT;
            }
            ++curIndex$1.elem;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)((CelebornInputStream)inputStream.elem));
        }
        ++curIndex$1.elem;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)CelebornInputStream.empty());
    }

    public static final /* synthetic */ boolean $anonfun$read$24(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            CelebornInputStream inputStream;
            CelebornInputStream celebornInputStream = inputStream = (CelebornInputStream)tuple2._2();
            CelebornInputStream celebornInputStream2 = CelebornInputStream.empty();
            return celebornInputStream == null ? celebornInputStream2 != null : !celebornInputStream.equals(celebornInputStream2);
        }
        throw new MatchError((Object)tuple2);
    }

    public CelebornShuffleReader(CelebornShuffleHandle<K, ?, C> handle, int startPartition, int endPartition, int startMapIndex, int endMapIndex, TaskContext context, CelebornConf conf, ShuffleReadMetricsReporter metrics, ExecutorShuffleIdTracker shuffleIdTracker, boolean needDecompress) {
        this.handle = handle;
        this.startPartition = startPartition;
        this.endPartition = endPartition;
        this.startMapIndex = startMapIndex;
        this.endMapIndex = endMapIndex;
        this.context = context;
        this.conf = conf;
        this.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics = metrics;
        this.shuffleIdTracker = shuffleIdTracker;
        this.needDecompress = needDecompress;
        Logging.$init$((Logging)this);
        this.dep = handle.dependency();
        this.shuffleClient = ShuffleClient.get(handle.appUniqueId(), handle.lifecycleManagerHost(), handle.lifecycleManagerPort(), conf, handle.userIdentifier(), handle.extension());
        this.exceptionRef = new AtomicReference();
        this.stageRerunEnabled = handle.stageRerunEnabled();
        this.encodedAttemptId = SparkCommonUtils.getEncodedAttemptNumber(context);
        this.pushReplicateEnabled = conf.clientPushReplicateEnabled();
        this.preferReplicaRead = context.attemptNumber() % 2 == 1;
    }

    public CelebornShuffleReader(CelebornShuffleHandle<K, ?, C> handle, int startPartition, int endPartition, int startMapIndex, int endMapIndex, TaskContext context, CelebornConf conf, ShuffleReadMetricsReporter metrics, ExecutorShuffleIdTracker shuffleIdTracker) {
        this(handle, startPartition, endPartition, startMapIndex, endMapIndex, context, conf, metrics, shuffleIdTracker, true);
    }
}

