/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.SerdeVersion;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv;
import org.apache.celeborn.common.rpc.netty.RequestMessage$;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.util.ByteBufferOutputStream;
import org.apache.celeborn.common.util.Utils$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da!\u0002\t\u0012\u0001]i\u0002\u0002\u0003\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\t\u0011-\u0002!\u0011!Q\u0001\n\u001dB\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\te\u0001\u0011\t\u0011)A\u0005]!A1\u0007\u0001BC\u0002\u0013\u0005A\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u00036\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015q\u0005\u0001\"\u0003P\u0011\u0015i\u0006\u0001\"\u0011_\u000f\u0019Q\u0017\u0003#\u0001\u0018W\u001a1\u0001#\u0005E\u0001/1DQ!\u000f\u0007\u0005\u00025DQA\u001c\u0007\u0005\n=DQ!\u001e\u0007\u0005\u0002Y\u0014aBU3rk\u0016\u001cH/T3tg\u0006<WM\u0003\u0002\u0013'\u0005)a.\u001a;us*\u0011A#F\u0001\u0004eB\u001c'B\u0001\f\u0018\u0003\u0019\u0019w.\\7p]*\u0011\u0001$G\u0001\tG\u0016dWMY8s]*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h'\t\u0001a\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\u000eg\u0016tG-\u001a:BI\u0012\u0014Xm]:\u0004\u0001U\tq\u0005\u0005\u0002)S5\t1#\u0003\u0002+'\tQ!\u000b]2BI\u0012\u0014Xm]:\u0002\u001dM,g\u000eZ3s\u0003\u0012$'/Z:tA\u0005A!/Z2fSZ,'/F\u0001/!\ty\u0003'D\u0001\u0012\u0013\t\t\u0014CA\nOKR$\u0018P\u00159d\u000b:$\u0007o\\5oiJ+g-A\u0005sK\u000e,\u0017N^3sA\u000591m\u001c8uK:$X#A\u001b\u0011\u0005}1\u0014BA\u001c!\u0005\r\te._\u0001\tG>tG/\u001a8uA\u00051A(\u001b8jiz\"Ba\u000f\u001f>}A\u0011q\u0006\u0001\u0005\u0006I\u001d\u0001\ra\n\u0005\u0006Y\u001d\u0001\rA\f\u0005\u0006g\u001d\u0001\r!N\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$\"!Q%\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015a\u00018j_*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006\u0015\"\u0001\raS\u0001\t]\u0016$H/_#omB\u0011q\u0006T\u0005\u0003\u001bF\u00111BT3uif\u0014\u0006oY#om\u0006yqO]5uKJ\u00038-\u00113ee\u0016\u001c8\u000fF\u0002Q'n\u0003\"aH)\n\u0005I\u0003#\u0001B+oSRDQ\u0001V\u0005A\u0002U\u000b1a\\;u!\t1\u0016,D\u0001X\u0015\tAV)\u0001\u0002j_&\u0011!l\u0016\u0002\u0011\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6DQ\u0001X\u0005A\u0002\u001d\n!B\u001d9d\u0003\u0012$'/Z:t\u0003!!xn\u0015;sS:<G#A0\u0011\u0005\u0001<gBA1f!\t\u0011\u0007%D\u0001d\u0015\t!W%\u0001\u0004=e>|GOP\u0005\u0003M\u0002\na\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011a\rI\u0001\u000f%\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f!\tyCb\u0005\u0002\r=Q\t1.\u0001\bsK\u0006$'\u000b]2BI\u0012\u0014Xm]:\u0015\u0005\u001d\u0002\b\"B9\u000f\u0001\u0004\u0011\u0018AA5o!\t16/\u0003\u0002u/\nyA)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0003baBd\u0017\u0010F\u0003<ob\f\u0019\u0001C\u0003K\u001f\u0001\u00071\nC\u0003z\u001f\u0001\u0007!0\u0001\u0004dY&,g\u000e\u001e\t\u0003w~l\u0011\u0001 \u0006\u0003svT!A`\u000b\u0002\u000f9,Go^8sW&\u0019\u0011\u0011\u0001?\u0003\u001fQ\u0013\u0018M\\:q_J$8\t\\5f]RDa!!\u0002\u0010\u0001\u0004\t\u0015!\u00022zi\u0016\u001c\b")
public class RequestMessage {
    private final RpcAddress senderAddress;
    private final NettyRpcEndpointRef receiver;
    private final Object content;

    public static RequestMessage apply(NettyRpcEnv nettyEnv, TransportClient client, ByteBuffer bytes) {
        return RequestMessage$.MODULE$.apply(nettyEnv, client, bytes);
    }

    public RpcAddress senderAddress() {
        return this.senderAddress;
    }

    public NettyRpcEndpointRef receiver() {
        return this.receiver;
    }

    public Object content() {
        return this.content;
    }

    public ByteBuffer serialize(NettyRpcEnv nettyEnv) {
        ByteBufferOutputStream bos;
        block9: {
            ByteBuffer byteBuffer;
            block8: {
                bos = new ByteBufferOutputStream();
                try (DataOutputStream out = new DataOutputStream(bos);){
                    Object msg;
                    this.writeRpcAddress(out, this.senderAddress());
                    this.writeRpcAddress(out, this.receiver().address());
                    out.writeUTF(this.receiver().name());
                    Object object = msg = Utils$.MODULE$.toTransportMessage(this.content());
                    if (object instanceof TransportMessage) {
                        TransportMessage transportMessage = (TransportMessage)object;
                        SerdeVersion serdeVersion = transportMessage.getSerdeVersion();
                        SerdeVersion serdeVersion2 = SerdeVersion.V2;
                        if (!(serdeVersion != null ? !((Object)((Object)serdeVersion)).equals((Object)serdeVersion2) : serdeVersion2 != null)) {
                            DataOutputStream out2 = new DataOutputStream(bos);
                            out2.writeByte(SerdeVersion.V2.getMarker());
                            out2.write(transportMessage.toByteBuffer().array());
                            out2.close();
                            byteBuffer = bos.toByteBuffer();
                            break block8;
                        }
                    }
                    try (SerializationStream s = nettyEnv.serializeStream(out);){
                        s.writeObject(Utils$.MODULE$.toTransportMessage(this.content()), ClassTag$.MODULE$.Any());
                        break block9;
                    }
                }
            }
            return byteBuffer;
        }
        return bos.toByteBuffer();
    }

    private void writeRpcAddress(DataOutputStream out, RpcAddress rpcAddress) {
        if (rpcAddress == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeUTF(rpcAddress.host());
        out.writeInt(rpcAddress.port());
    }

    public String toString() {
        return new StringBuilder(20).append("RequestMessage(").append(this.senderAddress()).append(", ").append(this.receiver()).append(", ").append(this.content()).append(")").toString();
    }

    public RequestMessage(RpcAddress senderAddress, NettyRpcEndpointRef receiver, Object content) {
        this.senderAddress = senderAddress;
        this.receiver = receiver;
        this.content = content;
    }
}

