/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.group;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;

public class GroupInfoCommand
extends AbstractRatisCommand {
    public GroupInfoCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "info";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        super.run(cl);
        this.println("group id: " + this.getRaftGroup().getGroupId().getUuid());
        GroupInfoReply reply = this.getGroupInfoReply();
        RaftProtos.RaftPeerProto leader = this.getLeader(reply.getRoleInfoProto());
        if (leader == null) {
            this.println("leader not found");
        } else {
            this.printf("leader info: %s(%s)%n%n", leader.getId().toStringUtf8(), leader.getAddress());
        }
        this.println(reply.getCommitInfos());
        this.println(reply.getLogInfoProto());
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>]", this.getCommandName(), "peers", "groupid");
    }

    @Override
    public String getDescription() {
        return GroupInfoCommand.description();
    }

    @Override
    public Options getOptions() {
        return super.getOptions();
    }

    public static String description() {
        return "Display the information of a specific raft group";
    }
}

