/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.write;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.shaded.org.apache.commons.lang3.StringUtils;

public class LocationPushFailedBatches
implements Serializable {
    private final Map<String, Set<Integer>> failedBatches = JavaUtils.newConcurrentHashMap();

    public Map<String, Set<Integer>> getFailedBatches() {
        return this.failedBatches;
    }

    public boolean contains(int mapId, int attemptId, int batchId) {
        Set<Integer> batches = this.failedBatches.get(Utils.makeAttemptKey(mapId, attemptId));
        return batches != null && batches.contains(batchId);
    }

    public void merge(LocationPushFailedBatches batches) {
        Map<String, Set<Integer>> otherFailedBatchesMap = batches.getFailedBatches();
        otherFailedBatchesMap.forEach((k, v) -> {
            Set failedBatches = this.failedBatches.computeIfAbsent((String)k, s -> ConcurrentHashMap.newKeySet());
            failedBatches.addAll(v);
        });
    }

    public void addFailedBatch(int mapId, int attemptId, int batchId) {
        String attemptKey = Utils.makeAttemptKey(mapId, attemptId);
        Set failedBatches = this.failedBatches.computeIfAbsent(attemptKey, s -> ConcurrentHashMap.newKeySet());
        failedBatches.add(batchId);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationPushFailedBatches that = (LocationPushFailedBatches)o;
        if (that.failedBatches.size() != this.failedBatches.size()) {
            return false;
        }
        return this.failedBatches.entrySet().stream().allMatch(item -> {
            Set<Integer> failedBatchesSet = that.failedBatches.get(item.getKey());
            if (failedBatchesSet == null) {
                return false;
            }
            return failedBatchesSet.equals(item.getValue());
        });
    }

    public int hashCode() {
        return this.failedBatches.entrySet().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.failedBatches.forEach((attemptKey, value) -> {
            stringBuilder.append("failed attemptKey:");
            stringBuilder.append((String)attemptKey);
            stringBuilder.append(" fail batch Ids:");
            stringBuilder.append(StringUtils.join(value, ","));
        });
        return "LocationPushFailedBatches{failedBatches=" + stringBuilder + '}';
    }
}

