/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.ConvertUtils;
import org.apache.commons.beanutils2.ConvertUtilsBean;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaBeanUtilsTest;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.MappedPropertyTestBean;
import org.apache.commons.beanutils2.PassTestException;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.apache.commons.beanutils2.TestBean;
import org.apache.commons.beanutils2.ThrowExceptionConverter;
import org.apache.commons.beanutils2.converters.ArrayConverter;
import org.apache.commons.beanutils2.converters.DateConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BeanUtilsBeanTest {
    protected TestBean bean;
    protected String[] describes = new String[]{"booleanProperty", "booleanSecond", "byteProperty", "doubleProperty", "dupProperty", "floatProperty", "intArray", "longProperty", "listIndexed", "longProperty", "nested", "nullProperty", "readOnlyProperty", "shortProperty", "stringArray", "stringProperty"};
    protected Calendar testCalendar;
    protected Date testUtilDate;
    protected String testStringDate;

    protected void checkIntArray(int[] actual, int[] expected) {
        Assertions.assertNotNull((Object)actual, (String)"actual array not null");
        Assertions.assertEquals((int)expected.length, (int)actual.length, (String)"actual array length");
        for (int i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((int)expected[i], (int)actual[i], (String)("actual array value[" + i + "]"));
        }
    }

    protected void checkMap(Map<?, ?> actual, Map<?, ?> expected) {
        Assertions.assertNotNull(actual, (String)"actual map not null");
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"actual map size");
        for (Object key : expected.keySet()) {
            Assertions.assertEquals(expected.get(key), actual.get(key), (String)("actual map value(" + key + ")"));
        }
    }

    private Throwable getCause(Throwable t) throws Throwable {
        return (Throwable)PropertyUtils.getProperty((Object)t, (String)"cause");
    }

    private void initCauseAndThrowException(String parent, String cause) throws Throwable {
        try {
            this.throwException(cause);
        }
        catch (Throwable e) {
            throw new Exception(parent, e);
        }
    }

    @BeforeEach
    public void setUp() {
        ConvertUtils.deregister();
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean());
        this.setUpShared();
    }

    protected void setUpShared() {
        this.bean = new TestBean();
        DateConverter dateConverter = new DateConverter(null);
        dateConverter.setLocale(Locale.US);
        dateConverter.setPattern("dd.MM.yyyy");
        ConvertUtils.register((Converter)dateConverter, Date.class);
        ArrayConverter dateArrayConverter = new ArrayConverter(Date[].class, (Converter)dateConverter, 0);
        ConvertUtils.register((Converter)dateArrayConverter, Date[].class);
        this.testCalendar = Calendar.getInstance();
        this.testCalendar.set(1992, 11, 28, 0, 0, 0);
        this.testCalendar.set(14, 0);
        this.testUtilDate = this.testCalendar.getTime();
        this.testStringDate = "28.12.1992";
    }

    @AfterEach
    public void tearDown() {
        this.bean = null;
    }

    @Test
    public void testArrayPropertyConversion() throws Exception {
        BeanUtilsBean beanUtils = new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean());
        TestBean bean = new TestBean();
        String[] results = beanUtils.getArrayProperty((Object)bean, "intArray");
        int[] values = bean.getIntArray();
        Assertions.assertEquals((int)results.length, (int)values.length, (String)"Converted array size not equal to property array size.");
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            Assertions.assertEquals((Object)(values[i] + ""), (Object)results[i], (String)("Value " + i + " incorrectly converted "));
        }
    }

    @Test
    public void testCopyPropertiesDynaBean() throws Exception {
        DynaClass dynaClass = DynaBeanUtilsTest.createDynaClass();
        DynaBean orig = null;
        orig = dynaClass.newInstance();
        orig.set("booleanProperty", (Object)Boolean.FALSE);
        orig.set("byteProperty", (Object)111);
        orig.set("doubleProperty", (Object)333.33);
        orig.set("dupProperty", (Object)new String[]{"New 0", "New 1", "New 2"});
        orig.set("intArray", (Object)new int[]{100, 200, 300});
        orig.set("intProperty", (Object)333);
        orig.set("longProperty", (Object)3333L);
        orig.set("shortProperty", (Object)33);
        orig.set("stringArray", (Object)new String[]{"New 0", "New 1"});
        orig.set("stringProperty", (Object)"Custom string");
        BeanUtils.copyProperties((Object)this.bean, (Object)orig);
        Assertions.assertEquals((Object)false, (Object)this.bean.getBooleanProperty(), (String)"Copied boolean property");
        Assertions.assertEquals((byte)111, (byte)this.bean.getByteProperty(), (String)"Copied byte property");
        Assertions.assertEquals((double)333.33, (double)this.bean.getDoubleProperty(), (double)0.005, (String)"Copied double property");
        Assertions.assertEquals((int)333, (int)this.bean.getIntProperty(), (String)"Copied int property");
        Assertions.assertEquals((long)3333L, (long)this.bean.getLongProperty(), (String)"Copied long property");
        Assertions.assertEquals((short)33, (short)this.bean.getShortProperty(), (String)"Copied short property");
        Assertions.assertEquals((Object)"Custom string", (Object)this.bean.getStringProperty(), (String)"Copied string property");
        String[] dupProperty = this.bean.getDupProperty();
        Assertions.assertNotNull((Object)dupProperty, (String)"dupProperty present");
        Assertions.assertEquals((int)3, (int)dupProperty.length, (String)"dupProperty length");
        Assertions.assertEquals((Object)"New 0", (Object)dupProperty[0], (String)"dupProperty[0]");
        Assertions.assertEquals((Object)"New 1", (Object)dupProperty[1], (String)"dupProperty[1]");
        Assertions.assertEquals((Object)"New 2", (Object)dupProperty[2], (String)"dupProperty[2]");
        int[] intArray = this.bean.getIntArray();
        Assertions.assertNotNull((Object)intArray, (String)"intArray present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)100, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)200, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)300, (int)intArray[2], (String)"intArray[2]");
        String[] stringArray = this.bean.getStringArray();
        Assertions.assertNotNull((Object)stringArray, (String)"stringArray present");
        Assertions.assertEquals((int)2, (int)stringArray.length, (String)"stringArray length");
        Assertions.assertEquals((Object)"New 0", (Object)stringArray[0], (String)"stringArray[0]");
        Assertions.assertEquals((Object)"New 1", (Object)stringArray[1], (String)"stringArray[1]");
    }

    @Test
    public void testCopyPropertiesMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("booleanProperty", "false");
        map.put("byteProperty", "111");
        map.put("doubleProperty", "333.0");
        map.put("dupProperty", new String[]{"New 0", "New 1", "New 2"});
        map.put("floatProperty", "222.0");
        map.put("intArray", new String[]{"0", "100", "200"});
        map.put("intProperty", "111");
        map.put("longProperty", "444");
        map.put("shortProperty", "555");
        map.put("stringProperty", "New String Property");
        BeanUtils.copyProperties((Object)this.bean, map);
        Assertions.assertEquals((Object)false, (Object)this.bean.getBooleanProperty(), (String)"booleanProperty");
        Assertions.assertEquals((byte)111, (byte)this.bean.getByteProperty(), (String)"byteProperty");
        Assertions.assertEquals((double)333.0, (double)this.bean.getDoubleProperty(), (double)0.005, (String)"doubleProperty");
        Assertions.assertEquals((float)222.0f, (float)this.bean.getFloatProperty(), (float)0.005f, (String)"floatProperty");
        Assertions.assertEquals((int)111, (int)this.bean.getIntProperty(), (String)"longProperty");
        Assertions.assertEquals((long)444L, (long)this.bean.getLongProperty(), (String)"longProperty");
        Assertions.assertEquals((short)555, (short)this.bean.getShortProperty(), (String)"shortProperty");
        Assertions.assertEquals((Object)"New String Property", (Object)this.bean.getStringProperty(), (String)"stringProperty");
        String[] dupProperty = this.bean.getDupProperty();
        Assertions.assertNotNull((Object)dupProperty, (String)"dupProperty present");
        Assertions.assertEquals((int)3, (int)dupProperty.length, (String)"dupProperty length");
        Assertions.assertEquals((Object)"New 0", (Object)dupProperty[0], (String)"dupProperty[0]");
        Assertions.assertEquals((Object)"New 1", (Object)dupProperty[1], (String)"dupProperty[1]");
        Assertions.assertEquals((Object)"New 2", (Object)dupProperty[2], (String)"dupProperty[2]");
        int[] intArray = this.bean.getIntArray();
        Assertions.assertNotNull((Object)intArray, (String)"intArray present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)0, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)100, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)200, (int)intArray[2], (String)"intArray[2]");
    }

    @Test
    public void testCopyPropertiesStandard() throws Exception {
        TestBean orig = new TestBean();
        orig.setBooleanProperty(false);
        orig.setByteProperty((byte)111);
        orig.setDoubleProperty(333.33);
        orig.setDupProperty(new String[]{"New 0", "New 1", "New 2"});
        orig.setIntArray(new int[]{100, 200, 300});
        orig.setIntProperty(333);
        orig.setLongProperty(3333L);
        orig.setShortProperty((short)33);
        orig.setStringArray(new String[]{"New 0", "New 1"});
        orig.setStringProperty("Custom string");
        BeanUtils.copyProperties((Object)this.bean, (Object)orig);
        Assertions.assertEquals((Object)false, (Object)this.bean.getBooleanProperty(), (String)"Copied boolean property");
        Assertions.assertEquals((byte)111, (byte)this.bean.getByteProperty(), (String)"Copied byte property");
        Assertions.assertEquals((double)333.33, (double)this.bean.getDoubleProperty(), (double)0.005, (String)"Copied double property");
        Assertions.assertEquals((int)333, (int)this.bean.getIntProperty(), (String)"Copied int property");
        Assertions.assertEquals((long)3333L, (long)this.bean.getLongProperty(), (String)"Copied long property");
        Assertions.assertEquals((short)33, (short)this.bean.getShortProperty(), (String)"Copied short property");
        Assertions.assertEquals((Object)"Custom string", (Object)this.bean.getStringProperty(), (String)"Copied string property");
        String[] dupProperty = this.bean.getDupProperty();
        Assertions.assertNotNull((Object)dupProperty, (String)"dupProperty present");
        Assertions.assertEquals((int)3, (int)dupProperty.length, (String)"dupProperty length");
        Assertions.assertEquals((Object)"New 0", (Object)dupProperty[0], (String)"dupProperty[0]");
        Assertions.assertEquals((Object)"New 1", (Object)dupProperty[1], (String)"dupProperty[1]");
        Assertions.assertEquals((Object)"New 2", (Object)dupProperty[2], (String)"dupProperty[2]");
        int[] intArray = this.bean.getIntArray();
        Assertions.assertNotNull((Object)intArray, (String)"intArray present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)100, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)200, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)300, (int)intArray[2], (String)"intArray[2]");
        String[] stringArray = this.bean.getStringArray();
        Assertions.assertNotNull((Object)stringArray, (String)"stringArray present");
        Assertions.assertEquals((int)2, (int)stringArray.length, (String)"stringArray length");
        Assertions.assertEquals((Object)"New 0", (Object)stringArray[0], (String)"stringArray[0]");
        Assertions.assertEquals((Object)"New 1", (Object)stringArray[1], (String)"stringArray[1]");
    }

    @Test
    public void testCopyPropertyByte() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)123);
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)123.0);
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)123);
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)123L);
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"byteProperty", (Object)123);
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
    }

    @Test
    public void testCopyPropertyConvert() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"dateProperty", (Object)this.testCalendar);
        Assertions.assertEquals((Object)this.testUtilDate, (Object)this.bean.getDateProperty(), (String)"Calendar --> java.util.Date");
    }

    @Test
    public void testCopyPropertyConvertFromString() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"dateProperty", (Object)this.testStringDate);
        Assertions.assertEquals((Object)this.testUtilDate, (Object)this.bean.getDateProperty(), (String)"String --> java.util.Date");
    }

    @Test
    public void testCopyPropertyConvertToString() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"stringProperty", (Object)this.testUtilDate);
        Assertions.assertEquals((Object)this.testStringDate, (Object)this.bean.getStringProperty(), (String)"java.util.Date --> String");
    }

    @Test
    public void testCopyPropertyConvertToStringArray() throws Exception {
        this.bean.setStringArray(null);
        BeanUtils.copyProperty((Object)this.bean, (String)"stringArray", (Object)new Date[]{this.testUtilDate});
        Assertions.assertEquals((int)1, (int)this.bean.getStringArray().length, (String)"java.util.Date[] --> String[] length");
        Assertions.assertEquals((Object)this.testStringDate, (Object)this.bean.getStringArray()[0], (String)"java.util.Date[] --> String[] value ");
    }

    @Test
    public void testCopyPropertyConvertToStringIndexed() throws Exception {
        this.bean.setStringArray(new String[1]);
        BeanUtils.copyProperty((Object)this.bean, (String)"stringArray[0]", (Object)this.testUtilDate);
        Assertions.assertEquals((int)1, (int)this.bean.getStringArray().length, (String)"java.util.Date[] --> String[] length");
        Assertions.assertEquals((Object)this.testStringDate, (Object)this.bean.getStringArray()[0], (String)"java.util.Date[] --> String[] value ");
    }

    @Test
    public void testCopyPropertyDouble() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)123.0);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)123L);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"doubleProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
    }

    @Test
    public void testCopyPropertyFloat() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)123.0);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)123L);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.copyProperty((Object)this.bean, (String)"floatProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
    }

    @Test
    public void testCopyPropertyInteger() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123.0);
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123L);
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
    }

    @Test
    public void testCopyPropertyLong() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123.0);
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123L);
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
    }

    @Test
    public void testCopyPropertyNestedIndexedArray() throws Exception {
        int[] origArray = new int[]{0, 10, 20, 30, 40};
        int[] intArray = new int[]{0, 0, 0};
        this.bean.getNested().setIntArray(intArray);
        int[] intChanged = new int[]{0, 0, 0};
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)1);
        this.checkIntArray(this.bean.getIntArray(), origArray);
        intChanged[1] = 1;
        this.checkIntArray(this.bean.getNested().getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)2);
        this.checkIntArray(this.bean.getIntArray(), origArray);
        intChanged[1] = 2;
        this.checkIntArray(this.bean.getNested().getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)3L);
        this.checkIntArray(this.bean.getIntArray(), origArray);
        intChanged[1] = 3;
        this.checkIntArray(this.bean.getNested().getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)"4");
        this.checkIntArray(this.bean.getIntArray(), origArray);
        intChanged[1] = 4;
        this.checkIntArray(this.bean.getNested().getIntArray(), intChanged);
    }

    @Test
    public void testCopyPropertyNestedMappedMap() throws Exception {
        HashMap<String, String> origMap = new HashMap<String, String>();
        origMap.put("First Key", "First Value");
        origMap.put("Second Key", "Second Value");
        HashMap<String, String> changedMap = new HashMap<String, String>();
        changedMap.put("First Key", "First Value");
        changedMap.put("Second Key", "Second Value");
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.mapProperty(Second Key)", (Object)"New Second Value");
        this.checkMap(this.bean.getMapProperty(), origMap);
        changedMap.put("Second Key", "New Second Value");
        this.checkMap(this.bean.getNested().getMapProperty(), changedMap);
    }

    @Test
    public void testCopyPropertyNestedSimple() throws Exception {
        this.bean.setIntProperty(0);
        this.bean.getNested().setIntProperty(0);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)1);
        Assertions.assertNotNull((Object)this.bean.getNested());
        Assertions.assertEquals((int)0, (int)this.bean.getIntProperty());
        Assertions.assertEquals((int)1, (int)this.bean.getNested().getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)2);
        Assertions.assertNotNull((Object)this.bean.getNested());
        Assertions.assertEquals((int)0, (int)this.bean.getIntProperty());
        Assertions.assertEquals((int)2, (int)this.bean.getNested().getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)3L);
        Assertions.assertNotNull((Object)this.bean.getNested());
        Assertions.assertEquals((int)0, (int)this.bean.getIntProperty());
        Assertions.assertEquals((int)3, (int)this.bean.getNested().getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)"4");
        Assertions.assertNotNull((Object)this.bean.getNested());
        Assertions.assertEquals((int)0, (int)this.bean.getIntProperty());
        Assertions.assertEquals((int)4, (int)this.bean.getNested().getIntProperty());
    }

    @Test
    public void testCopyPropertyNull() throws Exception {
        this.bean.setNullProperty("non-null value");
        BeanUtils.copyProperty((Object)this.bean, (String)"nullProperty", null);
        Assertions.assertNull((Object)this.bean.getNullProperty(), (String)"nullProperty is null");
    }

    @Test
    public void testCopyPropertyShort() throws Exception {
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)123);
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)123.0);
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)123);
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)123L);
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"shortProperty", (Object)123);
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
    }

    @Test
    public void testCopyPropertyWriteOnly() throws Exception {
        this.bean.setWriteOnlyProperty("Original value");
        BeanUtils.copyProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)"New value");
        Assertions.assertEquals((Object)"New value", (Object)this.bean.getWriteOnlyPropertyValue());
        BeanUtils.copyProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)123);
        Assertions.assertEquals((Object)"123", (Object)this.bean.getWriteOnlyPropertyValue());
    }

    @Test
    public void testDescribe() throws Exception {
        Assertions.assertTrue((boolean)BeanUtils.describe(null).isEmpty());
        Map map = null;
        map = BeanUtils.describe((Object)this.bean);
        for (String describe : this.describes) {
            Assertions.assertTrue((boolean)map.containsKey(describe), (String)("Property '" + describe + "' is present"));
        }
        Assertions.assertTrue((!map.containsKey("writeOnlyProperty") ? 1 : 0) != 0, (String)"Property 'writeOnlyProperty' is not present");
        Assertions.assertEquals((Object)"true", map.get("booleanProperty"), (String)"Value of 'booleanProperty'");
        Assertions.assertEquals((Object)"121", map.get("byteProperty"), (String)"Value of 'byteProperty'");
        Assertions.assertEquals((Object)"321.0", map.get("doubleProperty"), (String)"Value of 'doubleProperty'");
        Assertions.assertEquals((Object)"123.0", map.get("floatProperty"), (String)"Value of 'floatProperty'");
        Assertions.assertEquals((Object)"123", map.get("intProperty"), (String)"Value of 'intProperty'");
        Assertions.assertEquals((Object)"321", map.get("longProperty"), (String)"Value of 'longProperty'");
        Assertions.assertEquals((Object)"987", map.get("shortProperty"), (String)"Value of 'shortProperty'");
        Assertions.assertEquals((Object)"This is a string", map.get("stringProperty"), (String)"Value of 'stringProperty'");
    }

    @Test
    public void testGetArrayProperty() throws Exception {
        String[] arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"stringArray");
        String[] comp = this.bean.getStringArray();
        Assertions.assertEquals((int)comp.length, (int)arr.length, (String)("String array length = " + comp.length));
        arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"intArray");
        int[] iarr = this.bean.getIntArray();
        Assertions.assertEquals((int)iarr.length, (int)arr.length, (String)("String array length = " + iarr.length));
        arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"shortProperty");
        String shortAsString = "" + this.bean.getShortProperty();
        Assertions.assertEquals((int)1, (int)arr.length, (String)"Short List Test lth");
        Assertions.assertEquals((Object)shortAsString, (Object)arr[0], (String)"Short Test value");
        this.bean.setStringProperty("ABC");
        arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"stringProperty");
        Assertions.assertEquals((int)1, (int)arr.length, (String)"Delimited List Test lth");
        Assertions.assertEquals((Object)"ABC", (Object)arr[0], (String)"Delimited List Test value1");
    }

    @Test
    public void testGetArrayPropertyDate() throws Exception {
        String[] value = null;
        this.bean.setDateArrayProperty(new Date[]{this.testUtilDate});
        value = BeanUtils.getArrayProperty((Object)this.bean, (String)"dateArrayProperty");
        Assertions.assertEquals((int)1, (int)value.length, (String)"java.util.Date[] --> String[] length");
        Assertions.assertEquals((Object)this.testStringDate, (Object)value[0], (String)"java.util.Date[] --> String[] value ");
    }

    @Test
    public void testGetGeneralProperty() throws Exception {
        String val = BeanUtils.getProperty((Object)this.bean, (String)"nested.intIndexed[2]");
        String comp = String.valueOf(this.bean.getIntIndexed(2));
        Assertions.assertEquals((Object)val, (Object)comp, (String)("nested.intIndexed[2] == " + comp));
    }

    @Test
    public void testGetIndexedProperty1() throws Exception {
        String val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed[3]");
        String comp = String.valueOf(this.bean.getIntIndexed(3));
        Assertions.assertEquals((Object)val, (Object)comp, (String)("intIndexed[3] == " + comp));
        val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed[3]");
        comp = this.bean.getStringIndexed(3);
        Assertions.assertEquals((Object)val, (Object)comp, (String)("stringIndexed[3] == " + comp));
    }

    @Test
    public void testGetIndexedProperty2() throws Exception {
        String val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)3);
        String comp = String.valueOf(this.bean.getIntIndexed(3));
        Assertions.assertEquals((Object)val, (Object)comp, (String)("intIndexed,3 == " + comp));
        val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)3);
        comp = this.bean.getStringIndexed(3);
        Assertions.assertEquals((Object)val, (Object)comp, (String)("stringIndexed,3 == " + comp));
    }

    @Test
    public void testGetIndexedPropertyDate() throws Exception {
        String value = null;
        this.bean.setDateArrayProperty(new Date[]{this.testUtilDate});
        value = BeanUtils.getIndexedProperty((Object)this.bean, (String)"dateArrayProperty[0]");
        Assertions.assertEquals((Object)this.testStringDate, (Object)value, (String)"java.util.Date[0] --> String");
    }

    @Test
    public void testGetMappedProperty2Args() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> BeanUtils.getMappedProperty(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> BeanUtils.getMappedProperty(null, (String)""));
        Assertions.assertThrows(NullPointerException.class, () -> BeanUtils.getMappedProperty((Object)"", null));
    }

    @Test
    public void testGetMappedProperty3Args() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> BeanUtils.getMappedProperty(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> BeanUtils.getMappedProperty(null, (String)"", null));
        Assertions.assertThrows(NullPointerException.class, () -> BeanUtils.getMappedProperty((Object)"", null, null));
    }

    @Test
    public void testGetNestedProperty() throws Exception {
        String val = BeanUtils.getNestedProperty((Object)this.bean, (String)"nested.stringProperty");
        String comp = this.bean.getNested().getStringProperty();
        Assertions.assertEquals((Object)val, (Object)comp, (String)("nested.StringProperty == " + comp));
    }

    @Test
    public void testGetSimpleProperty() throws Exception {
        String val = BeanUtils.getSimpleProperty((Object)this.bean, (String)"shortProperty");
        String comp = String.valueOf(this.bean.getShortProperty());
        Assertions.assertEquals((Object)val, (Object)comp, (String)("shortProperty == " + comp));
    }

    @Test
    public void testGetSimplePropertyDate() throws Exception {
        String value = null;
        this.bean.setDateProperty(this.testUtilDate);
        value = BeanUtils.getSimpleProperty((Object)this.bean, (String)"dateProperty");
        Assertions.assertEquals((Object)this.testStringDate, (Object)value, (String)"java.util.Date --> String");
    }

    @Test
    public void testMappedProperty() throws Exception {
        MappedPropertyTestBean bean = new MappedPropertyTestBean();
        BeanUtils.setProperty((Object)bean, (String)"mapproperty(this.that.the-other)", (Object)"some.dotty.value");
        Assertions.assertEquals((Object)"some.dotty.value", (Object)bean.getMapproperty("this.that.the-other"), (String)"Mapped property set correctly");
    }

    @Test
    public void testPopulate() throws Exception {
        BeanUtilsBean.getInstance().populate(null, null);
        BeanUtilsBean.getInstance().populate((Object)"", null);
        BeanUtilsBean.getInstance().populate(null, new HashMap());
    }

    @Test
    public void testPopulateArrayElements() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("intIndexed[0]", "100");
        map.put("intIndexed[2]", "120");
        map.put("intIndexed[4]", "140");
        BeanUtils.populate((Object)this.bean, map);
        Assertions.assertEquals((int)100, (int)this.bean.getIntIndexed(0), (String)"intIndexed[0] is 100");
        Assertions.assertEquals((int)10, (int)this.bean.getIntIndexed(1), (String)"intIndexed[1] is 10");
        Assertions.assertEquals((int)120, (int)this.bean.getIntIndexed(2), (String)"intIndexed[2] is 120");
        Assertions.assertEquals((int)30, (int)this.bean.getIntIndexed(3), (String)"intIndexed[3] is 30");
        Assertions.assertEquals((int)140, (int)this.bean.getIntIndexed(4), (String)"intIndexed[4] is 140");
        map.clear();
        map.put("stringIndexed[1]", "New String 1");
        map.put("stringIndexed[3]", "New String 3");
        BeanUtils.populate((Object)this.bean, map);
        Assertions.assertEquals((Object)"String 0", (Object)this.bean.getStringIndexed(0), (String)"stringIndexed[0] is \"String 0\"");
        Assertions.assertEquals((Object)"New String 1", (Object)this.bean.getStringIndexed(1), (String)"stringIndexed[1] is \"New String 1\"");
        Assertions.assertEquals((Object)"String 2", (Object)this.bean.getStringIndexed(2), (String)"stringIndexed[2] is \"String 2\"");
        Assertions.assertEquals((Object)"New String 3", (Object)this.bean.getStringIndexed(3), (String)"stringIndexed[3] is \"New String 3\"");
        Assertions.assertEquals((Object)"String 4", (Object)this.bean.getStringIndexed(4), (String)"stringIndexed[4] is \"String 4\"");
    }

    @Test
    public void testPopulateArrayProperties() throws Exception {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        int[] intArray = new int[]{123, 456, 789};
        map.put("intArray", intArray);
        String[] stringArray = new String[]{"New String 0", "New String 1"};
        map.put("stringArray", stringArray);
        BeanUtils.populate((Object)this.bean, map);
        intArray = this.bean.getIntArray();
        Assertions.assertNotNull((Object)intArray, (String)"intArray is present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)123, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)456, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)789, (int)intArray[2], (String)"intArray[2]");
        stringArray = this.bean.getStringArray();
        Assertions.assertNotNull((Object)stringArray, (String)"stringArray is present");
        Assertions.assertEquals((int)2, (int)stringArray.length, (String)"stringArray length");
        Assertions.assertEquals((Object)"New String 0", (Object)stringArray[0], (String)"stringArray[0]");
        Assertions.assertEquals((Object)"New String 1", (Object)stringArray[1], (String)"stringArray[1]");
    }

    @Test
    public void testPopulateMapped() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mappedProperty(First Key)", "New First Value");
        map.put("mappedProperty(Third Key)", "New Third Value");
        BeanUtils.populate((Object)this.bean, map);
        Assertions.assertEquals((Object)"New First Value", (Object)this.bean.getMappedProperty("First Key"), (String)"mappedProperty(First Key)");
        Assertions.assertEquals((Object)"Second Value", (Object)this.bean.getMappedProperty("Second Key"), (String)"mappedProperty(Second Key)");
        Assertions.assertEquals((Object)"New Third Value", (Object)this.bean.getMappedProperty("Third Key"), (String)"mappedProperty(Third Key)");
        Assertions.assertNull((Object)this.bean.getMappedProperty("Fourth Key"), (String)"mappedProperty(Fourth Key");
    }

    @Test
    public void testPopulateNested() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nested.booleanProperty", "false");
        map.put("nested.doubleProperty", "432.0");
        map.put("nested.intProperty", "543");
        map.put("nested.shortProperty", "654");
        map.put("nested.writeOnlyProperty", "New writeOnlyProperty value");
        BeanUtils.populate((Object)this.bean, map);
        Assertions.assertTrue((!this.bean.getNested().getBooleanProperty() ? 1 : 0) != 0, (String)"booleanProperty is false");
        Assertions.assertTrue((boolean)this.bean.getNested().isBooleanSecond(), (String)"booleanSecond is true");
        Assertions.assertEquals((double)432.0, (double)this.bean.getNested().getDoubleProperty(), (double)0.005, (String)"doubleProperty is 432.0");
        Assertions.assertEquals((float)123.0f, (float)this.bean.getNested().getFloatProperty(), (float)0.005f, (String)"floatProperty is 123.0");
        Assertions.assertEquals((int)543, (int)this.bean.getNested().getIntProperty(), (String)"intProperty is 543");
        Assertions.assertEquals((long)321L, (long)this.bean.getNested().getLongProperty(), (String)"longProperty is 321");
        Assertions.assertEquals((short)654, (short)this.bean.getNested().getShortProperty(), (String)"shortProperty is 654");
        Assertions.assertEquals((Object)"This is a string", (Object)this.bean.getNested().getStringProperty(), (String)"stringProperty is \"This is a string\"");
        Assertions.assertEquals((Object)"New writeOnlyProperty value", (Object)this.bean.getNested().getWriteOnlyPropertyValue(), (String)"writeOnlyProperty is \"New writeOnlyProperty value\"");
    }

    @Test
    public void testPopulateScalar() throws Exception {
        this.bean.setNullProperty("Non-null value");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("booleanProperty", "false");
        map.put("byteProperty", "111");
        map.put("doubleProperty", "432.0");
        map.put("intProperty", "543");
        map.put("longProperty", "");
        map.put("nullProperty", null);
        map.put("shortProperty", "654");
        map.put("writeOnlyProperty", "New writeOnlyProperty value");
        map.put("readOnlyProperty", "New readOnlyProperty value");
        BeanUtils.populate((Object)this.bean, map);
        Assertions.assertTrue((!this.bean.getBooleanProperty() ? 1 : 0) != 0, (String)"booleanProperty is false");
        Assertions.assertTrue((boolean)this.bean.isBooleanSecond(), (String)"booleanSecond is true");
        Assertions.assertEquals((byte)111, (byte)this.bean.getByteProperty(), (String)"byteProperty is 111");
        Assertions.assertEquals((double)432.0, (double)this.bean.getDoubleProperty(), (double)0.005, (String)"doubleProperty is 432.0");
        Assertions.assertEquals((float)123.0f, (float)this.bean.getFloatProperty(), (float)0.005f, (String)"floatProperty is 123.0");
        Assertions.assertEquals((int)543, (int)this.bean.getIntProperty(), (String)"intProperty is 543");
        Assertions.assertEquals((long)0L, (long)this.bean.getLongProperty(), (String)"longProperty is 0");
        Assertions.assertNull((Object)this.bean.getNullProperty(), (String)"nullProperty is null");
        Assertions.assertEquals((short)654, (short)this.bean.getShortProperty(), (String)"shortProperty is 654");
        Assertions.assertEquals((Object)"This is a string", (Object)this.bean.getStringProperty(), (String)"stringProperty is \"This is a string\"");
        Assertions.assertEquals((Object)"New writeOnlyProperty value", (Object)this.bean.getWriteOnlyPropertyValue(), (String)"writeOnlyProperty is \"New writeOnlyProperty value\"");
        Assertions.assertEquals((Object)"Read Only String Property", (Object)this.bean.getReadOnlyProperty(), (String)"readOnlyProperty is \"Read Only String Property\"");
    }

    @Test
    public void testSeparateInstances() throws Exception {
        BeanUtilsBean utilsOne = new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean());
        BeanUtilsBean utilsTwo = new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean());
        TestBean bean = new TestBean();
        bean.setBooleanProperty(false);
        utilsOne.setProperty((Object)bean, "booleanProperty", (Object)"true");
        Assertions.assertEquals((Object)bean.getBooleanProperty(), (Object)true, (String)"Set property failed (1)");
        bean.setBooleanProperty(false);
        utilsTwo.setProperty((Object)bean, "booleanProperty", (Object)"true");
        Assertions.assertEquals((Object)bean.getBooleanProperty(), (Object)true, (String)"Set property failed (2)");
        utilsOne.getConvertUtils().register((Converter)new ThrowExceptionConverter(), Boolean.TYPE);
        bean.setBooleanProperty(false);
        Assertions.assertThrows(PassTestException.class, () -> utilsOne.setProperty((Object)bean, "booleanProperty", (Object)"true"));
        bean.setBooleanProperty(false);
        utilsTwo.setProperty((Object)bean, "booleanProperty", (Object)"true");
        Assertions.assertEquals((Object)bean.getBooleanProperty(), (Object)true, (String)"Set property failed (3)");
    }

    @Test
    public void testSetMappedMap() throws Exception {
        TestBean bean = new TestBean();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sub-key-1", "sub-value-1");
        map.put("sub-key-2", "sub-value-2");
        map.put("sub-key-3", "sub-value-3");
        bean.getMapProperty().put("mappedMap", map);
        Assertions.assertEquals((Object)"sub-value-3", ((Map)bean.getMapProperty().get("mappedMap")).get("sub-key-3"), (String)"BEFORE");
        BeanUtils.setProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-3)", (Object)"SUB-KEY-3-UPDATED");
        Assertions.assertEquals((Object)"SUB-KEY-3-UPDATED", ((Map)bean.getMapProperty().get("mappedMap")).get("sub-key-3"), (String)"AFTER");
    }

    @Test
    public void testSetPropertyByte() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)123);
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)123);
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)123L);
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)123);
        Assertions.assertEquals((byte)123, (byte)this.bean.getByteProperty());
    }

    @Test
    public void testSetPropertyConvert() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"dateProperty", (Object)this.testCalendar);
        Assertions.assertEquals((Object)this.testUtilDate, (Object)this.bean.getDateProperty(), (String)"Calendar --> java.util.Date");
    }

    @Test
    public void testSetPropertyConvertFromString() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"dateProperty", (Object)this.testStringDate);
        Assertions.assertEquals((Object)this.testUtilDate, (Object)this.bean.getDateProperty(), (String)"String --> java.util.Date");
    }

    @Test
    public void testSetPropertyConvertToString() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", (Object)this.testUtilDate);
        Assertions.assertEquals((Object)this.testStringDate, (Object)this.bean.getStringProperty(), (String)"java.util.Date --> String");
    }

    @Test
    public void testSetPropertyConvertToStringArray() throws Exception {
        this.bean.setStringArray(null);
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)new Date[]{this.testUtilDate});
        Assertions.assertEquals((int)1, (int)this.bean.getStringArray().length, (String)"java.util.Date[] --> String[] length");
        Assertions.assertEquals((Object)this.testStringDate, (Object)this.bean.getStringArray()[0], (String)"java.util.Date[] --> String[] value ");
    }

    @Test
    public void testSetPropertyConvertToStringIndexed() throws Exception {
        this.bean.setStringArray(new String[1]);
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray[0]", (Object)this.testUtilDate);
        Assertions.assertEquals((Object)this.testStringDate, (Object)this.bean.getStringArray()[0], (String)"java.util.Date --> String[]");
    }

    @Test
    public void testSetPropertyDouble() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123.0);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123L);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getDoubleProperty(), (double)0.005);
    }

    @Test
    public void testSetPropertyFloat() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123.0);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123L);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)this.bean.getFloatProperty(), (double)0.005);
    }

    @Test
    public void testSetPropertyInteger() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123L);
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((int)123, (int)this.bean.getIntProperty());
    }

    @Test
    public void testSetPropertyLong() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123L);
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((long)123L, (long)this.bean.getLongProperty());
    }

    @Test
    public void testSetPropertyNull() throws Exception {
        this.bean.setNullProperty("non-null value");
        BeanUtils.setProperty((Object)this.bean, (String)"nullProperty", null);
        Assertions.assertNull((Object)this.bean.getNullProperty(), (String)"nullProperty is null");
    }

    @Test
    public void testSetPropertyNullValues() throws Exception {
        Object oldValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray", null);
        Object newValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        Assertions.assertNotNull((Object)newValue, (String)"stringArray is not null");
        Assertions.assertInstanceOf(String[].class, (Object)newValue, (String)"stringArray of correct type");
        Assertions.assertEquals((int)1, (int)((String[])newValue).length, (String)"stringArray length");
        PropertyUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)oldValue);
        oldValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray[2]", null);
        newValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        Assertions.assertNotNull((Object)newValue, (String)"stringArray is not null");
        Assertions.assertInstanceOf(String[].class, (Object)newValue, (String)"stringArray of correct type");
        Assertions.assertEquals((int)5, (int)((String[])newValue).length, (String)"stringArray length");
        Assertions.assertNull((Object)((String[])newValue)[2], (String)"stringArray[2] is null");
        PropertyUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)oldValue);
        BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", null);
        Assertions.assertNull((Object)BeanUtils.getProperty((Object)this.bean, (String)"stringProperty"), (String)"stringProperty is now null");
    }

    @Test
    public void testSetPropertyOnPrimitiveWrappers() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"intProperty", (Object)1);
        Assertions.assertEquals((int)1, (int)this.bean.getIntProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", (Object)1);
        Assertions.assertEquals((int)1, (int)Integer.parseInt(this.bean.getStringProperty()));
    }

    @Test
    public void testSetPropertyShort() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)123);
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)123);
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)123L);
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)123);
        Assertions.assertEquals((short)123, (short)this.bean.getShortProperty());
    }

    @Test
    public void testSetPropertyStringToArray() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)"ABC,DEF,GHI");
        String[] strArray = this.bean.getStringArray();
        Assertions.assertEquals((int)3, (int)strArray.length, (String)"length");
        Assertions.assertEquals((Object)"ABC", (Object)strArray[0], (String)"value[0]");
        Assertions.assertEquals((Object)"DEF", (Object)strArray[1], (String)"value[1]");
        Assertions.assertEquals((Object)"GHI", (Object)strArray[2], (String)"value[2]");
        BeanUtils.setProperty((Object)this.bean, (String)"intArray", (Object)"0, 10, 20, 30, 40");
        int[] intArray = this.bean.getIntArray();
        Assertions.assertEquals((int)5, (int)intArray.length, (String)"length");
        Assertions.assertEquals((int)0, (int)intArray[0], (String)"value[0]");
        Assertions.assertEquals((int)10, (int)intArray[1], (String)"value[1]");
        Assertions.assertEquals((int)20, (int)intArray[2], (String)"value[2]");
        Assertions.assertEquals((int)30, (int)intArray[3], (String)"value[3]");
        Assertions.assertEquals((int)40, (int)intArray[4], (String)"value[4]");
    }

    @Test
    public void testSetPropertyWriteOnly() throws Exception {
        this.bean.setWriteOnlyProperty("Original value");
        BeanUtils.setProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)"New value");
        Assertions.assertEquals((Object)"New value", (Object)this.bean.getWriteOnlyPropertyValue());
        BeanUtils.setProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)123);
        Assertions.assertEquals((Object)"123", (Object)this.bean.getWriteOnlyPropertyValue());
    }

    private void throwException(String msg) throws Throwable {
        throw new Exception(msg);
    }
}

