/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.util.Arrays;
import org.apache.commons.dbcp2.PStmtKey;
import org.apache.commons.dbcp2.PoolingConnection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPStmtKey {
    @Test
    void testCtorDifferentCatalog() {
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1"), (Object)new PStmtKey("sql", "catalog2", "schema1"));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0), (Object)new PStmtKey("sql", "catalog2", "schema1", 0));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, 0));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog2", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (int[])null), (Object)new PStmtKey("sql", "catalog2", "schema1", (int[])null));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new int[1]), (Object)new PStmtKey("sql", "catalog2", "schema1", new int[1]));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (String[])null), (Object)new PStmtKey("sql", "catalog2", "schema1", (String[])null));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new String[]{"A"}), (Object)new PStmtKey("sql", "catalog2", "schema1", new String[]{"A"}));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog2", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)), (Object)new PStmtKey("sql", "catalog2", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    void testCtorDifferentSchema() {
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1"), (Object)new PStmtKey("sql", "catalog1", "schema2"));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0), (Object)new PStmtKey("sql", "catalog1", "schema2", 0));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, 0));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema2", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (int[])null), (Object)new PStmtKey("sql", "catalog1", "schema2", (int[])null));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new int[1]), (Object)new PStmtKey("sql", "catalog1", "schema2", new int[1]));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (String[])null), (Object)new PStmtKey("sql", "catalog1", "schema2", (String[])null));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new String[]{"A"}), (Object)new PStmtKey("sql", "catalog1", "schema2", new String[]{"A"}));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema2", PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertNotEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)), (Object)new PStmtKey("sql", "catalog1", "schema2", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    void testCtorEquals() {
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1"), (Object)new PStmtKey("sql", "catalog1", "schema1"));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0), (Object)new PStmtKey("sql", "catalog1", "schema1", 0));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema1", 0, 0, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (int[])null), (Object)new PStmtKey("sql", "catalog1", "schema1", (int[])null));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new int[1]), (Object)new PStmtKey("sql", "catalog1", "schema1", new int[1]));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", (String[])null), (Object)new PStmtKey("sql", "catalog1", "schema1", (String[])null));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", new String[]{"A"}), (Object)new PStmtKey("sql", "catalog1", "schema1", new String[]{"A"}));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT), (Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertEquals((Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)), (Object)new PStmtKey("sql", "catalog1", "schema1", PoolingConnection.StatementType.PREPARED_STATEMENT, Integer.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    void testCtorStringStringArrayOfInts() {
        int[] input = new int[]{0, 0};
        PStmtKey pStmtKey = new PStmtKey("", "", "", input);
        Assertions.assertArrayEquals((int[])input, (int[])pStmtKey.getColumnIndexes());
        input[0] = 1;
        input[1] = 1;
        Assertions.assertFalse((boolean)Arrays.equals(input, pStmtKey.getColumnIndexes()));
    }

    @Test
    void testCtorStringStringArrayOfNullInts() {
        int[] input = null;
        PStmtKey pStmtKey = new PStmtKey("", "", "", input);
        Assertions.assertArrayEquals(input, (int[])pStmtKey.getColumnIndexes());
    }

    @Test
    void testCtorStringStringArrayOfNullStrings() {
        Object[] input = null;
        PStmtKey pStmtKey = new PStmtKey("", "", "", input);
        Assertions.assertArrayEquals(input, (Object[])pStmtKey.getColumnNames());
    }

    @Test
    void testCtorStringStringArrayOfStrings() {
        Object[] input = new String[]{"A", "B"};
        PStmtKey pStmtKey = new PStmtKey("", "", "", (String[])input);
        Assertions.assertArrayEquals((Object[])input, (Object[])pStmtKey.getColumnNames());
        input[0] = "C";
        input[1] = "D";
        Assertions.assertFalse((boolean)Arrays.equals(input, pStmtKey.getColumnNames()));
    }

    @Test
    void testEquals() {
        PStmtKey pStmtKey = new PStmtKey("SELECT 1", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT);
        Assertions.assertEquals((Object)pStmtKey, (Object)pStmtKey);
        Assertions.assertNotEquals(null, (Object)pStmtKey);
        Assertions.assertNotEquals((Object)pStmtKey, (Object)new Object());
        Assertions.assertNotEquals((Object)pStmtKey, (Object)new PStmtKey("SELECT 2", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertNotEquals((Object)pStmtKey, (Object)new PStmtKey("SELECT 1", "anothercatalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertNotEquals((Object)pStmtKey, (Object)new PStmtKey("SELECT 1", "catalog", "private", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertNotEquals((Object)pStmtKey, (Object)new PStmtKey("SELECT 1", "catalog", "public", 1005, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertNotEquals((Object)pStmtKey, (Object)new PStmtKey("SELECT 1", "catalog", "public", 1004, 1008, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertNotEquals((Object)pStmtKey, (Object)new PStmtKey("SELECT 1", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.PREPARED_STATEMENT));
        Assertions.assertEquals((Object)pStmtKey, (Object)new PStmtKey("SELECT 1", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT));
        Assertions.assertEquals((int)pStmtKey.hashCode(), (int)new PStmtKey("SELECT 1", "catalog", "public", 1004, 1007, PoolingConnection.StatementType.CALLABLE_STATEMENT).hashCode());
    }

    @Test
    void testGettersSetters() {
        PStmtKey pStmtKey = new PStmtKey("SELECT 1", "catalog", "public");
        Assertions.assertEquals((Object)"SELECT 1", (Object)pStmtKey.getSql());
        Assertions.assertEquals((Object)"public", (Object)pStmtKey.getSchema());
        Assertions.assertEquals((Object)"catalog", (Object)pStmtKey.getCatalog());
        Assertions.assertNull((Object)pStmtKey.getAutoGeneratedKeys());
        Assertions.assertNull((Object)pStmtKey.getResultSetConcurrency());
        Assertions.assertNull((Object)pStmtKey.getResultSetHoldability());
        Assertions.assertNull((Object)pStmtKey.getResultSetType());
        Assertions.assertEquals((Object)PoolingConnection.StatementType.PREPARED_STATEMENT, (Object)pStmtKey.getStmtType());
    }

    @Test
    void testToString() {
        PStmtKey pStmtKey = new PStmtKey("SELECT 1", "catalog", "public", PoolingConnection.StatementType.CALLABLE_STATEMENT, Integer.valueOf(1));
        Assertions.assertTrue((boolean)pStmtKey.toString().contains("sql=SELECT 1"));
        Assertions.assertTrue((boolean)pStmtKey.toString().contains("schema=public"));
        Assertions.assertTrue((boolean)pStmtKey.toString().contains("autoGeneratedKeys=1"));
        Assertions.assertTrue((boolean)pStmtKey.toString().contains("statementType=CALLABLE_STATEMENT"));
    }
}

