/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.dbcp2.managed.ManagedConnection;
import org.apache.commons.dbcp2.managed.TransactionContext;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTransactionContext {
    @Test
    void testSetSharedConnectionEnlistFailure() throws Exception {
        try (BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();){
            basicManagedDataSource.setTransactionManager((TransactionManager)new TransactionManagerImpl());
            basicManagedDataSource.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
            basicManagedDataSource.setUrl("jdbc:apache:commons:testdriver");
            basicManagedDataSource.setUsername("userName");
            basicManagedDataSource.setPassword("password");
            basicManagedDataSource.setMaxIdle(1);
            try (Connection conn = basicManagedDataSource.getConnection();){
                Assertions.assertInstanceOf(ManagedConnection.class, (Object)conn);
                UncooperativeTransaction transaction = new UncooperativeTransaction();
                TransactionContext transactionContext = new TransactionContext(basicManagedDataSource.getTransactionRegistry(), (Transaction)transaction);
                Assertions.assertThrows(SQLException.class, () -> transactionContext.setSharedConnection(conn));
            }
        }
    }

    private static final class UncooperativeTransaction
    extends TransactionImpl {
        public UncooperativeTransaction() {
            super(null, null);
        }

        public synchronized boolean enlistResource(XAResource xaRes) {
            return false;
        }
    }
}

