/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingDatabaseMetaData;
import org.apache.commons.dbcp2.TesterConnection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDelegatingDatabaseMetaData {
    private TesterConnection testConn;
    private DelegatingConnection<?> conn;
    private DelegatingDatabaseMetaData delegate;
    private DelegatingDatabaseMetaData delegateSpy;
    private DatabaseMetaData obj;

    @BeforeEach
    public void setUp() throws Exception {
        this.obj = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        this.testConn = new TesterConnection("test", "test");
        this.conn = new DelegatingConnection((Connection)this.testConn);
        this.delegate = new DelegatingDatabaseMetaData(this.conn, this.obj);
        this.delegateSpy = (DelegatingDatabaseMetaData)Mockito.spy((Object)this.delegate);
    }

    @Test
    void testAllProceduresAreCallable() throws Exception {
        try {
            this.delegate.allProceduresAreCallable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).allProceduresAreCallable();
        Mockito.when((Object)this.obj.allProceduresAreCallable()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).allProceduresAreCallable());
    }

    @Test
    void testAllTablesAreSelectable() throws Exception {
        try {
            this.delegate.allTablesAreSelectable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).allTablesAreSelectable();
        Mockito.when((Object)this.obj.allTablesAreSelectable()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).allTablesAreSelectable());
    }

    @Test
    void testAutoCommitFailureClosesAllResultSets() throws Exception {
        try {
            this.delegate.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).autoCommitFailureClosesAllResultSets();
        Mockito.when((Object)this.obj.autoCommitFailureClosesAllResultSets()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).autoCommitFailureClosesAllResultSets());
    }

    @Test
    void testCheckOpen() throws Exception {
        this.delegate = new DelegatingDatabaseMetaData(this.conn, this.conn.getMetaData());
        ResultSet rst = this.delegate.getSchemas();
        Assertions.assertFalse((boolean)rst.isClosed());
        this.conn.close();
        Assertions.assertTrue((boolean)rst.isClosed());
    }

    @Test
    void testDataDefinitionCausesTransactionCommit() throws Exception {
        try {
            this.delegate.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).dataDefinitionCausesTransactionCommit();
        Mockito.when((Object)this.obj.dataDefinitionCausesTransactionCommit()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).dataDefinitionCausesTransactionCommit());
    }

    @Test
    void testDataDefinitionIgnoredInTransactions() throws Exception {
        try {
            this.delegate.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).dataDefinitionIgnoredInTransactions();
        Mockito.when((Object)this.obj.dataDefinitionIgnoredInTransactions()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).dataDefinitionIgnoredInTransactions());
    }

    @Test
    void testDeletesAreDetectedInteger() throws Exception {
        try {
            this.delegate.deletesAreDetected(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).deletesAreDetected(1);
        Mockito.when((Object)this.obj.deletesAreDetected(1)).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> this.delegate.deletesAreDetected(1));
    }

    @Test
    void testDoesMaxRowSizeIncludeBlobs() throws Exception {
        try {
            this.delegate.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).doesMaxRowSizeIncludeBlobs();
        Mockito.when((Object)this.obj.doesMaxRowSizeIncludeBlobs()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).doesMaxRowSizeIncludeBlobs());
    }

    @Test
    void testGeneratedKeyAlwaysReturned() throws Exception {
        try {
            this.delegate.generatedKeyAlwaysReturned();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).generatedKeyAlwaysReturned();
        Mockito.when((Object)this.obj.generatedKeyAlwaysReturned()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).generatedKeyAlwaysReturned());
    }

    @Test
    void testGetAttributesStringStringStringString() throws Exception {
        try {
            this.delegate.getAttributes("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getAttributes("foo", "foo", "foo", "foo");
    }

    @Test
    void testGetBestRowIdentifierStringStringStringIntegerBoolean() throws Exception {
        try {
            this.delegate.getBestRowIdentifier("foo", "foo", "foo", 1, Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBestRowIdentifier("foo", "foo", "foo", 1, Boolean.TRUE);
    }

    @Test
    void testGetCatalogs() throws Exception {
        try {
            this.delegate.getCatalogs();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCatalogs();
        Mockito.when((Object)this.obj.getCatalogs()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).getCatalogs());
    }

    @Test
    void testGetCatalogSeparator() throws Exception {
        try {
            this.delegate.getCatalogSeparator();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCatalogSeparator();
        Mockito.when((Object)this.obj.getCatalogSeparator()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).getCatalogSeparator());
    }

    @Test
    void testGetCatalogTerm() throws Exception {
        try {
            this.delegate.getCatalogTerm();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCatalogTerm();
        Mockito.when((Object)this.obj.getCatalogTerm()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).getCatalogTerm());
    }

    @Test
    void testGetClientInfoProperties() throws Exception {
        try {
            this.delegate.getClientInfoProperties();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getClientInfoProperties();
        Mockito.when((Object)this.obj.getClientInfoProperties()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).getClientInfoProperties());
    }

    @Test
    void testGetColumnPrivilegesStringStringStringString() throws Exception {
        try {
            this.delegate.getColumnPrivileges("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getColumnPrivileges("foo", "foo", "foo", "foo");
    }

    @Test
    void testGetColumnsStringStringStringString() throws Exception {
        try {
            this.delegate.getColumns("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getColumns("foo", "foo", "foo", "foo");
    }

    @Test
    void testGetConnection() throws Exception {
        try {
            this.delegate.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)0))).getConnection();
    }

    @Test
    void testGetCrossReferenceStringStringStringStringStringString() throws Exception {
        try {
            this.delegate.getCrossReference("foo", "foo", "foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCrossReference("foo", "foo", "foo", "foo", "foo", "foo");
    }

    @Test
    void testGetDatabaseMajorVersion() throws Exception {
        try {
            this.delegate.getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDatabaseMajorVersion();
        Mockito.when((Object)this.obj.getDatabaseMajorVersion()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).getDatabaseMajorVersion());
    }

    @Test
    void testGetDatabaseMinorVersion() throws Exception {
        try {
            this.delegate.getDatabaseMinorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDatabaseMinorVersion();
        Mockito.when((Object)this.obj.getDatabaseMinorVersion()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).getDatabaseMinorVersion());
    }

    @Test
    void testGetDatabaseProductName() throws Exception {
        try {
            this.delegate.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDatabaseProductName();
        Mockito.when((Object)this.obj.getDatabaseProductName()).thenThrow(SQLException.class);
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingDatabaseMetaData)this.delegate).getDatabaseProductName());
    }

    @Test
    void testGetDatabaseProductVersion() throws Exception {
        try {
            this.delegate.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDatabaseProductVersion();
    }

    @Test
    void testGetDefaultTransactionIsolation() throws Exception {
        try {
            this.delegate.getDefaultTransactionIsolation();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDefaultTransactionIsolation();
    }

    @Test
    void testGetDelegate() throws Exception {
        Assertions.assertEquals((Object)this.obj, (Object)this.delegate.getDelegate());
    }

    @Test
    void testGetDriverMajorVersion() throws Exception {
        this.delegate.getDriverMajorVersion();
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDriverMajorVersion();
    }

    @Test
    void testGetDriverMinorVersion() throws Exception {
        this.delegate.getDriverMinorVersion();
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDriverMinorVersion();
    }

    @Test
    void testGetDriverName() throws Exception {
        try {
            this.delegate.getDriverName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDriverName();
    }

    @Test
    void testGetDriverVersion() throws Exception {
        try {
            this.delegate.getDriverVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDriverVersion();
    }

    @Test
    void testGetExportedKeysStringStringString() throws Exception {
        try {
            this.delegate.getExportedKeys("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getExportedKeys("foo", "foo", "foo");
    }

    @Test
    void testGetExtraNameCharacters() throws Exception {
        try {
            this.delegate.getExtraNameCharacters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getExtraNameCharacters();
    }

    @Test
    void testGetFunctionColumnsStringStringStringString() throws Exception {
        try {
            this.delegate.getFunctionColumns("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFunctionColumns("foo", "foo", "foo", "foo");
    }

    @Test
    void testGetFunctionsStringStringString() throws Exception {
        try {
            this.delegate.getFunctions("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFunctions("foo", "foo", "foo");
    }

    @Test
    void testGetIdentifierQuoteString() throws Exception {
        try {
            this.delegate.getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getIdentifierQuoteString();
    }

    @Test
    void testGetImportedKeysStringStringString() throws Exception {
        try {
            this.delegate.getImportedKeys("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getImportedKeys("foo", "foo", "foo");
    }

    @Test
    void testGetIndexInfoStringStringStringBooleanBoolean() throws Exception {
        try {
            this.delegate.getIndexInfo("foo", "foo", "foo", Boolean.TRUE.booleanValue(), Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getIndexInfo("foo", "foo", "foo", Boolean.TRUE, Boolean.TRUE);
    }

    @Test
    void testGetInnermostDelegate() {
        Assertions.assertNotNull((Object)this.delegate.getInnermostDelegate());
    }

    @Test
    void testGetJDBCMajorVersion() throws Exception {
        try {
            this.delegate.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getJDBCMajorVersion();
    }

    @Test
    void testGetJDBCMinorVersion() throws Exception {
        try {
            this.delegate.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getJDBCMinorVersion();
    }

    @Test
    void testGetMaxBinaryLiteralLength() throws Exception {
        try {
            this.delegate.getMaxBinaryLiteralLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxBinaryLiteralLength();
    }

    @Test
    void testGetMaxCatalogNameLength() throws Exception {
        try {
            this.delegate.getMaxCatalogNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxCatalogNameLength();
    }

    @Test
    void testGetMaxCharLiteralLength() throws Exception {
        try {
            this.delegate.getMaxCharLiteralLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxCharLiteralLength();
    }

    @Test
    void testGetMaxColumnNameLength() throws Exception {
        try {
            this.delegate.getMaxColumnNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnNameLength();
    }

    @Test
    void testGetMaxColumnsInGroupBy() throws Exception {
        try {
            this.delegate.getMaxColumnsInGroupBy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInGroupBy();
    }

    @Test
    void testGetMaxColumnsInIndex() throws Exception {
        try {
            this.delegate.getMaxColumnsInIndex();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInIndex();
    }

    @Test
    void testGetMaxColumnsInOrderBy() throws Exception {
        try {
            this.delegate.getMaxColumnsInOrderBy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInOrderBy();
    }

    @Test
    void testGetMaxColumnsInSelect() throws Exception {
        try {
            this.delegate.getMaxColumnsInSelect();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInSelect();
    }

    @Test
    void testGetMaxColumnsInTable() throws Exception {
        try {
            this.delegate.getMaxColumnsInTable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxColumnsInTable();
    }

    @Test
    void testGetMaxConnections() throws Exception {
        try {
            this.delegate.getMaxConnections();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxConnections();
    }

    @Test
    void testGetMaxCursorNameLength() throws Exception {
        try {
            this.delegate.getMaxCursorNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxCursorNameLength();
    }

    @Test
    void testGetMaxIndexLength() throws Exception {
        try {
            this.delegate.getMaxIndexLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxIndexLength();
    }

    @Test
    void testGetMaxLogicalLobSize() throws Exception {
        try {
            this.delegate.getMaxLogicalLobSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxLogicalLobSize();
    }

    @Test
    void testGetMaxProcedureNameLength() throws Exception {
        try {
            this.delegate.getMaxProcedureNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxProcedureNameLength();
    }

    @Test
    void testGetMaxRowSize() throws Exception {
        try {
            this.delegate.getMaxRowSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxRowSize();
    }

    @Test
    void testGetMaxSchemaNameLength() throws Exception {
        try {
            this.delegate.getMaxSchemaNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxSchemaNameLength();
    }

    @Test
    void testGetMaxStatementLength() throws Exception {
        try {
            this.delegate.getMaxStatementLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxStatementLength();
    }

    @Test
    void testGetMaxStatements() throws Exception {
        try {
            this.delegate.getMaxStatements();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxStatements();
    }

    @Test
    void testGetMaxTableNameLength() throws Exception {
        try {
            this.delegate.getMaxTableNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxTableNameLength();
    }

    @Test
    void testGetMaxTablesInSelect() throws Exception {
        try {
            this.delegate.getMaxTablesInSelect();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxTablesInSelect();
    }

    @Test
    void testGetMaxUserNameLength() throws Exception {
        try {
            this.delegate.getMaxUserNameLength();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getMaxUserNameLength();
    }

    @Test
    void testGetNumericFunctions() throws Exception {
        try {
            this.delegate.getNumericFunctions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNumericFunctions();
    }

    @Test
    void testGetPrimaryKeysStringStringString() throws Exception {
        try {
            this.delegate.getPrimaryKeys("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getPrimaryKeys("foo", "foo", "foo");
    }

    @Test
    void testGetProcedureColumnsStringStringStringString() throws Exception {
        try {
            this.delegate.getProcedureColumns("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getProcedureColumns("foo", "foo", "foo", "foo");
    }

    @Test
    void testGetProceduresStringStringString() throws Exception {
        try {
            this.delegate.getProcedures("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getProcedures("foo", "foo", "foo");
    }

    @Test
    void testGetProcedureTerm() throws Exception {
        try {
            this.delegate.getProcedureTerm();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getProcedureTerm();
    }

    @Test
    void testGetPseudoColumnsStringStringStringString() throws Exception {
        try {
            this.delegate.getPseudoColumns("foo", "foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getPseudoColumns("foo", "foo", "foo", "foo");
    }

    @Test
    void testGetResultSetHoldability() throws Exception {
        try {
            this.delegate.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getResultSetHoldability();
    }

    @Test
    void testGetRowIdLifetime() throws Exception {
        try {
            this.delegate.getRowIdLifetime();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRowIdLifetime();
    }

    @Test
    void testGetSchemas() throws Exception {
        try {
            this.delegate.getSchemas();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSchemas();
    }

    @Test
    void testGetSchemasStringString() throws Exception {
        try {
            this.delegate.getSchemas("foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSchemas("foo", "foo");
    }

    @Test
    void testGetSchemaTerm() throws Exception {
        try {
            this.delegate.getSchemaTerm();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSchemaTerm();
    }

    @Test
    void testGetSearchStringEscape() throws Exception {
        try {
            this.delegate.getSearchStringEscape();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSearchStringEscape();
    }

    @Test
    void testGetSQLKeywords() throws Exception {
        try {
            this.delegate.getSQLKeywords();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSQLKeywords();
    }

    @Test
    void testGetSQLStateType() throws Exception {
        try {
            this.delegate.getSQLStateType();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSQLStateType();
    }

    @Test
    void testGetStringFunctions() throws Exception {
        try {
            this.delegate.getStringFunctions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getStringFunctions();
    }

    @Test
    void testGetSuperTablesStringStringString() throws Exception {
        try {
            this.delegate.getSuperTables("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSuperTables("foo", "foo", "foo");
    }

    @Test
    void testGetSuperTypesStringStringString() throws Exception {
        try {
            this.delegate.getSuperTypes("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSuperTypes("foo", "foo", "foo");
    }

    @Test
    void testGetSystemFunctions() throws Exception {
        try {
            this.delegate.getSystemFunctions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSystemFunctions();
    }

    @Test
    void testGetTablePrivilegesStringStringString() throws Exception {
        try {
            this.delegate.getTablePrivileges("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTablePrivileges("foo", "foo", "foo");
    }

    @Test
    void testGetTablesStringStringStringStringArray() throws Exception {
        try {
            this.delegate.getTables("foo", "foo", "foo", (String[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTables("foo", "foo", "foo", null);
    }

    @Test
    void testGetTableTypes() throws Exception {
        try {
            this.delegate.getTableTypes();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTableTypes();
    }

    @Test
    void testGetTimeDateFunctions() throws Exception {
        try {
            this.delegate.getTimeDateFunctions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimeDateFunctions();
    }

    @Test
    void testGetTypeInfo() throws Exception {
        try {
            this.delegate.getTypeInfo();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTypeInfo();
    }

    @Test
    void testGetUDTsStringStringStringIntegerArray() throws Exception {
        try {
            this.delegate.getUDTs("foo", "foo", "foo", (int[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getUDTs("foo", "foo", "foo", null);
    }

    @Test
    void testGetURL() throws Exception {
        try {
            this.delegate.getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getURL();
    }

    @Test
    void testGetUserName() throws Exception {
        try {
            this.delegate.getUserName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getUserName();
    }

    @Test
    void testGetVersionColumnsStringStringString() throws Exception {
        try {
            this.delegate.getVersionColumns("foo", "foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getVersionColumns("foo", "foo", "foo");
    }

    @Test
    void testInsertsAreDetectedInteger() throws Exception {
        try {
            this.delegate.insertsAreDetected(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).insertsAreDetected(1);
    }

    @Test
    void testIsCatalogAtStart() throws Exception {
        try {
            this.delegate.isCatalogAtStart();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).isCatalogAtStart();
    }

    @Test
    void testIsReadOnly() throws Exception {
        try {
            this.delegate.isReadOnly();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).isReadOnly();
    }

    @Test
    void testLocatorsUpdateCopy() throws Exception {
        try {
            this.delegate.locatorsUpdateCopy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).locatorsUpdateCopy();
    }

    @Test
    void testNullArguments() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> new DelegatingDatabaseMetaData(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> new DelegatingDatabaseMetaData(new DelegatingConnection(null), null));
    }

    @Test
    void testNullPlusNonNullIsNull() throws Exception {
        try {
            this.delegate.nullPlusNonNullIsNull();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullPlusNonNullIsNull();
    }

    @Test
    void testNullsAreSortedAtEnd() throws Exception {
        try {
            this.delegate.nullsAreSortedAtEnd();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullsAreSortedAtEnd();
    }

    @Test
    void testNullsAreSortedAtStart() throws Exception {
        try {
            this.delegate.nullsAreSortedAtStart();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullsAreSortedAtStart();
    }

    @Test
    void testNullsAreSortedHigh() throws Exception {
        try {
            this.delegate.nullsAreSortedHigh();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullsAreSortedHigh();
    }

    @Test
    void testNullsAreSortedLow() throws Exception {
        try {
            this.delegate.nullsAreSortedLow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).nullsAreSortedLow();
    }

    @Test
    void testOthersDeletesAreVisibleInteger() throws Exception {
        try {
            this.delegate.othersDeletesAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).othersDeletesAreVisible(1);
    }

    @Test
    void testOthersInsertsAreVisibleInteger() throws Exception {
        try {
            this.delegate.othersInsertsAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).othersInsertsAreVisible(1);
    }

    @Test
    void testOthersUpdatesAreVisibleInteger() throws Exception {
        try {
            this.delegate.othersUpdatesAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).othersUpdatesAreVisible(1);
    }

    @Test
    void testOwnDeletesAreVisibleInteger() throws Exception {
        try {
            this.delegate.ownDeletesAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).ownDeletesAreVisible(1);
    }

    @Test
    void testOwnInsertsAreVisibleInteger() throws Exception {
        try {
            this.delegate.ownInsertsAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).ownInsertsAreVisible(1);
    }

    @Test
    void testOwnUpdatesAreVisibleInteger() throws Exception {
        try {
            this.delegate.ownUpdatesAreVisible(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).ownUpdatesAreVisible(1);
    }

    @Test
    void testStoresLowerCaseIdentifiers() throws Exception {
        try {
            this.delegate.storesLowerCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesLowerCaseIdentifiers();
    }

    @Test
    void testStoresLowerCaseQuotedIdentifiers() throws Exception {
        try {
            this.delegate.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesLowerCaseQuotedIdentifiers();
    }

    @Test
    void testStoresMixedCaseIdentifiers() throws Exception {
        try {
            this.delegate.storesMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesMixedCaseIdentifiers();
    }

    @Test
    void testStoresMixedCaseQuotedIdentifiers() throws Exception {
        try {
            this.delegate.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesMixedCaseQuotedIdentifiers();
    }

    @Test
    void testStoresUpperCaseIdentifiers() throws Exception {
        try {
            this.delegate.storesUpperCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesUpperCaseIdentifiers();
    }

    @Test
    void testStoresUpperCaseQuotedIdentifiers() throws Exception {
        try {
            this.delegate.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).storesUpperCaseQuotedIdentifiers();
    }

    @Test
    void testSupportsAlterTableWithAddColumn() throws Exception {
        try {
            this.delegate.supportsAlterTableWithAddColumn();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsAlterTableWithAddColumn();
    }

    @Test
    void testSupportsAlterTableWithDropColumn() throws Exception {
        try {
            this.delegate.supportsAlterTableWithDropColumn();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsAlterTableWithDropColumn();
    }

    @Test
    void testSupportsANSI92EntryLevelSQL() throws Exception {
        try {
            this.delegate.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsANSI92EntryLevelSQL();
    }

    @Test
    void testSupportsANSI92FullSQL() throws Exception {
        try {
            this.delegate.supportsANSI92FullSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsANSI92FullSQL();
    }

    @Test
    void testSupportsANSI92IntermediateSQL() throws Exception {
        try {
            this.delegate.supportsANSI92IntermediateSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsANSI92IntermediateSQL();
    }

    @Test
    void testSupportsBatchUpdates() throws Exception {
        try {
            this.delegate.supportsBatchUpdates();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsBatchUpdates();
    }

    @Test
    void testSupportsCatalogsInDataManipulation() throws Exception {
        try {
            this.delegate.supportsCatalogsInDataManipulation();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInDataManipulation();
    }

    @Test
    void testSupportsCatalogsInIndexDefinitions() throws Exception {
        try {
            this.delegate.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInIndexDefinitions();
    }

    @Test
    void testSupportsCatalogsInPrivilegeDefinitions() throws Exception {
        try {
            this.delegate.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInPrivilegeDefinitions();
    }

    @Test
    void testSupportsCatalogsInProcedureCalls() throws Exception {
        try {
            this.delegate.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInProcedureCalls();
    }

    @Test
    void testSupportsCatalogsInTableDefinitions() throws Exception {
        try {
            this.delegate.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCatalogsInTableDefinitions();
    }

    @Test
    void testSupportsColumnAliasing() throws Exception {
        try {
            this.delegate.supportsColumnAliasing();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsColumnAliasing();
    }

    @Test
    void testSupportsConvert() throws Exception {
        try {
            this.delegate.supportsConvert();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsConvert();
    }

    @Test
    void testSupportsConvertIntegerInteger() throws Exception {
        try {
            this.delegate.supportsConvert(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsConvert(1, 1);
    }

    @Test
    void testSupportsCoreSQLGrammar() throws Exception {
        try {
            this.delegate.supportsCoreSQLGrammar();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCoreSQLGrammar();
    }

    @Test
    void testSupportsCorrelatedSubqueries() throws Exception {
        try {
            this.delegate.supportsCorrelatedSubqueries();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsCorrelatedSubqueries();
    }

    @Test
    void testSupportsDataDefinitionAndDataManipulationTransactions() throws Exception {
        try {
            this.delegate.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Test
    void testSupportsDataManipulationTransactionsOnly() throws Exception {
        try {
            this.delegate.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsDataManipulationTransactionsOnly();
    }

    @Test
    void testSupportsDifferentTableCorrelationNames() throws Exception {
        try {
            this.delegate.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsDifferentTableCorrelationNames();
    }

    @Test
    void testSupportsExpressionsInOrderBy() throws Exception {
        try {
            this.delegate.supportsExpressionsInOrderBy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsExpressionsInOrderBy();
    }

    @Test
    void testSupportsExtendedSQLGrammar() throws Exception {
        try {
            this.delegate.supportsExtendedSQLGrammar();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsExtendedSQLGrammar();
    }

    @Test
    void testSupportsFullOuterJoins() throws Exception {
        try {
            this.delegate.supportsFullOuterJoins();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsFullOuterJoins();
    }

    @Test
    void testSupportsGetGeneratedKeys() throws Exception {
        try {
            this.delegate.supportsGetGeneratedKeys();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsGetGeneratedKeys();
    }

    @Test
    void testSupportsGroupBy() throws Exception {
        try {
            this.delegate.supportsGroupBy();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsGroupBy();
    }

    @Test
    void testSupportsGroupByBeyondSelect() throws Exception {
        try {
            this.delegate.supportsGroupByBeyondSelect();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsGroupByBeyondSelect();
    }

    @Test
    void testSupportsGroupByUnrelated() throws Exception {
        try {
            this.delegate.supportsGroupByUnrelated();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsGroupByUnrelated();
    }

    @Test
    void testSupportsIntegrityEnhancementFacility() throws Exception {
        try {
            this.delegate.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsIntegrityEnhancementFacility();
    }

    @Test
    void testSupportsLikeEscapeClause() throws Exception {
        try {
            this.delegate.supportsLikeEscapeClause();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsLikeEscapeClause();
    }

    @Test
    void testSupportsLimitedOuterJoins() throws Exception {
        try {
            this.delegate.supportsLimitedOuterJoins();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsLimitedOuterJoins();
    }

    @Test
    void testSupportsMinimumSQLGrammar() throws Exception {
        try {
            this.delegate.supportsMinimumSQLGrammar();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMinimumSQLGrammar();
    }

    @Test
    void testSupportsMixedCaseIdentifiers() throws Exception {
        try {
            this.delegate.supportsMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMixedCaseIdentifiers();
    }

    @Test
    void testSupportsMixedCaseQuotedIdentifiers() throws Exception {
        try {
            this.delegate.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMixedCaseQuotedIdentifiers();
    }

    @Test
    void testSupportsMultipleOpenResults() throws Exception {
        try {
            this.delegate.supportsMultipleOpenResults();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMultipleOpenResults();
    }

    @Test
    void testSupportsMultipleResultSets() throws Exception {
        try {
            this.delegate.supportsMultipleResultSets();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMultipleResultSets();
    }

    @Test
    void testSupportsMultipleTransactions() throws Exception {
        try {
            this.delegate.supportsMultipleTransactions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsMultipleTransactions();
    }

    @Test
    void testSupportsNamedParameters() throws Exception {
        try {
            this.delegate.supportsNamedParameters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsNamedParameters();
    }

    @Test
    void testSupportsNonNullableColumns() throws Exception {
        try {
            this.delegate.supportsNonNullableColumns();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsNonNullableColumns();
    }

    @Test
    void testSupportsOpenCursorsAcrossCommit() throws Exception {
        try {
            this.delegate.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOpenCursorsAcrossCommit();
    }

    @Test
    void testSupportsOpenCursorsAcrossRollback() throws Exception {
        try {
            this.delegate.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOpenCursorsAcrossRollback();
    }

    @Test
    void testSupportsOpenStatementsAcrossCommit() throws Exception {
        try {
            this.delegate.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOpenStatementsAcrossCommit();
    }

    @Test
    void testSupportsOpenStatementsAcrossRollback() throws Exception {
        try {
            this.delegate.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOpenStatementsAcrossRollback();
    }

    @Test
    void testSupportsOrderByUnrelated() throws Exception {
        try {
            this.delegate.supportsOrderByUnrelated();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOrderByUnrelated();
    }

    @Test
    void testSupportsOuterJoins() throws Exception {
        try {
            this.delegate.supportsOuterJoins();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsOuterJoins();
    }

    @Test
    void testSupportsPositionedDelete() throws Exception {
        try {
            this.delegate.supportsPositionedDelete();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsPositionedDelete();
    }

    @Test
    void testSupportsPositionedUpdate() throws Exception {
        try {
            this.delegate.supportsPositionedUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsPositionedUpdate();
    }

    @Test
    void testSupportsRefCursors() throws Exception {
        try {
            this.delegate.supportsRefCursors();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsRefCursors();
    }

    @Test
    void testSupportsResultSetConcurrencyIntegerInteger() throws Exception {
        try {
            this.delegate.supportsResultSetConcurrency(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsResultSetConcurrency(1, 1);
    }

    @Test
    void testSupportsResultSetHoldabilityInteger() throws Exception {
        try {
            this.delegate.supportsResultSetHoldability(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsResultSetHoldability(1);
    }

    @Test
    void testSupportsResultSetTypeInteger() throws Exception {
        try {
            this.delegate.supportsResultSetType(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsResultSetType(1);
    }

    @Test
    void testSupportsSavepoints() throws Exception {
        try {
            this.delegate.supportsSavepoints();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSavepoints();
    }

    @Test
    void testSupportsSchemasInDataManipulation() throws Exception {
        try {
            this.delegate.supportsSchemasInDataManipulation();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInDataManipulation();
    }

    @Test
    void testSupportsSchemasInIndexDefinitions() throws Exception {
        try {
            this.delegate.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInIndexDefinitions();
    }

    @Test
    void testSupportsSchemasInPrivilegeDefinitions() throws Exception {
        try {
            this.delegate.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInPrivilegeDefinitions();
    }

    @Test
    void testSupportsSchemasInProcedureCalls() throws Exception {
        try {
            this.delegate.supportsSchemasInProcedureCalls();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInProcedureCalls();
    }

    @Test
    void testSupportsSchemasInTableDefinitions() throws Exception {
        try {
            this.delegate.supportsSchemasInTableDefinitions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSchemasInTableDefinitions();
    }

    @Test
    void testSupportsSelectForUpdate() throws Exception {
        try {
            this.delegate.supportsSelectForUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSelectForUpdate();
    }

    @Test
    void testSupportsStatementPooling() throws Exception {
        try {
            this.delegate.supportsStatementPooling();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsStatementPooling();
    }

    @Test
    void testSupportsStoredFunctionsUsingCallSyntax() throws Exception {
        try {
            this.delegate.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsStoredFunctionsUsingCallSyntax();
    }

    @Test
    void testSupportsStoredProcedures() throws Exception {
        try {
            this.delegate.supportsStoredProcedures();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsStoredProcedures();
    }

    @Test
    void testSupportsSubqueriesInComparisons() throws Exception {
        try {
            this.delegate.supportsSubqueriesInComparisons();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSubqueriesInComparisons();
    }

    @Test
    void testSupportsSubqueriesInExists() throws Exception {
        try {
            this.delegate.supportsSubqueriesInExists();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSubqueriesInExists();
    }

    @Test
    void testSupportsSubqueriesInIns() throws Exception {
        try {
            this.delegate.supportsSubqueriesInIns();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSubqueriesInIns();
    }

    @Test
    void testSupportsSubqueriesInQuantifieds() throws Exception {
        try {
            this.delegate.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsSubqueriesInQuantifieds();
    }

    @Test
    void testSupportsTableCorrelationNames() throws Exception {
        try {
            this.delegate.supportsTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsTableCorrelationNames();
    }

    @Test
    void testSupportsTransactionIsolationLevelInteger() throws Exception {
        try {
            this.delegate.supportsTransactionIsolationLevel(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsTransactionIsolationLevel(1);
    }

    @Test
    void testSupportsTransactions() throws Exception {
        try {
            this.delegate.supportsTransactions();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsTransactions();
    }

    @Test
    void testSupportsUnion() throws Exception {
        try {
            this.delegate.supportsUnion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsUnion();
    }

    @Test
    void testSupportsUnionAll() throws Exception {
        try {
            this.delegate.supportsUnionAll();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).supportsUnionAll();
    }

    @Test
    void testUpdatesAreDetectedInteger() throws Exception {
        try {
            this.delegate.updatesAreDetected(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).updatesAreDetected(1);
    }

    @Test
    void testUsesLocalFilePerTable() throws Exception {
        try {
            this.delegate.usesLocalFilePerTable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).usesLocalFilePerTable();
    }

    @Test
    void testUsesLocalFiles() throws Exception {
        try {
            this.delegate.usesLocalFiles();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((DatabaseMetaData)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).usesLocalFiles();
    }

    @Test
    void testWrap() throws SQLException {
        Assertions.assertEquals((Object)this.delegate, (Object)this.delegate.unwrap(DatabaseMetaData.class));
        Assertions.assertEquals((Object)this.delegate, (Object)this.delegate.unwrap(DelegatingDatabaseMetaData.class));
        Assertions.assertEquals((Object)this.obj, (Object)this.delegate.unwrap(this.obj.getClass()));
        Assertions.assertNull((Object)this.delegate.unwrap(String.class));
        Assertions.assertTrue((boolean)this.delegate.isWrapperFor(DatabaseMetaData.class));
        Assertions.assertTrue((boolean)this.delegate.isWrapperFor(DelegatingDatabaseMetaData.class));
        Assertions.assertTrue((boolean)this.delegate.isWrapperFor(this.obj.getClass()));
        Assertions.assertFalse((boolean)this.delegate.isWrapperFor(String.class));
    }
}

