/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class CountingInputStreamTest {
    CountingInputStreamTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    void testAvailableAfterClose(int len) throws Exception {
        CloseShieldInputStream shadow;
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[len]);
        try (CloseShieldInputStream in = CloseShieldInputStream.wrap((InputStream)bais);){
            Assertions.assertEquals((int)len, (int)in.available());
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)shadow.available());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    void testAvailableAfterOpen(int len) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[len]);
        try (CloseShieldInputStream in = CloseShieldInputStream.wrap((InputStream)bais);){
            Assertions.assertEquals((int)len, (int)in.available());
        }
    }

    @Test
    void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException((ProxyInputStream)new CountingInputStream((InputStream)new BrokenInputStream((Throwable)new IOException())));
    }

    @Test
    void testCounting() throws Exception {
        String text = "A piece of text";
        try (CountingInputStream cis = new CountingInputStream((InputStream)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)"A piece of text")).get());){
            byte[] result = new byte[21];
            byte[] ba = new byte[5];
            int found = cis.read(ba);
            System.arraycopy(ba, 0, result, 0, 5);
            Assertions.assertEquals((int)found, (int)cis.getCount());
            int value = cis.read();
            result[5] = (byte)value;
            Assertions.assertEquals((int)(++found), (int)cis.getCount());
            Assertions.assertEquals((int)(found += cis.read(result, 6, 5)), (int)cis.getCount());
            Assertions.assertEquals((int)(found += cis.read(result, 11, 10)), (int)cis.getCount());
            String textResult = new String(result).trim();
            Assertions.assertEquals((Object)textResult, (Object)"A piece of text");
        }
    }

    @Test
    void testEOF1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            int found = cis.read();
            Assertions.assertEquals((int)0, (int)found);
            Assertions.assertEquals((int)1, (int)cis.getCount());
            found = cis.read();
            Assertions.assertEquals((int)0, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
            found = cis.read();
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
        }
    }

    @Test
    void testEOF2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[10];
            int found = cis.read(result);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
        }
    }

    @Test
    void testEOF3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[10];
            int found = cis.read(result, 0, 5);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
        }
    }

    @Test
    void testLargeFiles_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream mock = new NullInputStream(0x80000000L);
        CountingInputStream cis = new CountingInputStream((InputStream)mock);
        IOUtils.consume((InputStream)cis);
        Assertions.assertThrows(ArithmeticException.class, () -> cis.getCount());
        Assertions.assertThrows(ArithmeticException.class, () -> cis.resetCount());
        mock.init();
        IOUtils.consume((InputStream)cis);
        Assertions.assertEquals((long)0x80000000L, (long)cis.getByteCount(), (String)"getByteCount()");
        Assertions.assertEquals((long)0x80000000L, (long)cis.resetByteCount(), (String)"resetByteCount()");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    void testReadAfterClose(int len) throws Exception {
        CloseShieldInputStream shadow;
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[len]);
        try (CloseShieldInputStream in = CloseShieldInputStream.wrap((InputStream)bais);){
            Assertions.assertEquals((int)len, (int)in.available());
            shadow = in;
        }
        Assertions.assertEquals((int)-1, (int)shadow.read());
    }

    @Test
    void testResetting() throws Exception {
        String text = "A piece of text";
        byte[] bytes = "A piece of text".getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[bytes.length];
            int found = cis.read(result, 0, 5);
            Assertions.assertEquals((int)found, (int)cis.getCount());
            int count = cis.resetCount();
            found = cis.read(result, 6, 5);
            Assertions.assertEquals((int)found, (int)count);
        }
    }

    @Test
    void testSkipping() throws IOException {
        String text = "Hello World!";
        try (CountingInputStream cis = new CountingInputStream((InputStream)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)"Hello World!")).get());){
            Assertions.assertEquals((long)6L, (long)cis.skip(6L));
            Assertions.assertEquals((int)6, (int)cis.getCount());
            byte[] result = new byte[6];
            Assertions.assertEquals((int)result.length, (int)cis.read(result));
            Assertions.assertEquals((Object)"World!", (Object)new String(result));
            Assertions.assertEquals((int)12, (int)cis.getCount());
        }
    }

    @Test
    void testZeroLength1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(IOUtils.EMPTY_BYTE_ARRAY);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            int found = cis.read();
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)0, (int)cis.getCount());
        }
    }

    @Test
    void testZeroLength2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(IOUtils.EMPTY_BYTE_ARRAY);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[10];
            int found = cis.read(result);
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)0, (int)cis.getCount());
        }
    }

    @Test
    void testZeroLength3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(IOUtils.EMPTY_BYTE_ARRAY);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[10];
            int found = cis.read(result, 0, 5);
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)0, (int)cis.getCount());
        }
    }
}

