/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import org.apache.commons.io.output.ClosedWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClosedWriterTest {
    ClosedWriterTest() {
    }

    @Test
    void testFlush() throws IOException {
        try (ClosedWriter cw = new ClosedWriter();){
            Assertions.assertThrows(IOException.class, () -> cw.flush());
        }
    }

    @Test
    void testWrite() throws IOException {
        try (ClosedWriter cw = new ClosedWriter();){
            char[] cbuf = new char[1];
            Assertions.assertThrows(IOException.class, () -> cw.write(new char[0], 0, 1));
            Assertions.assertThrows(IOException.class, () -> cw.write(cbuf, -1, 0));
            Assertions.assertThrows(IOException.class, () -> cw.write(cbuf, 0, -1));
            Assertions.assertThrows(IOException.class, () -> cw.write(cbuf, 0, 2));
            Assertions.assertThrows(IOException.class, () -> cw.write((char[])null, 0, 0));
        }
    }
}

