/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DoWhileTest
extends JexlTestCase {
    public DoWhileTest() {
        super("DoWhileTest");
    }

    @Test
    void testEmptyBody() throws Exception {
        JexlScript e = this.JEXL.createScript("var i = 0; do ; while((i+=1) < 10); i");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testEmptyStmtBody() throws Exception {
        JexlScript e = this.JEXL.createScript("var i = 0; do {} while((i+=1) < 10); i");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testForEachBreakInsideFunction() throws Exception {
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createScript("for (i : 1..2) {  y = function() { break; } }"), (String)"break is out of loop!");
        String str = xparse.detailedMessage();
        Assertions.assertTrue((boolean)str.contains("break"));
    }

    @Test
    void testForEachContinueInsideFunction() throws Exception {
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createScript("for (i : 1..2) {  y = function() { continue; } }"), (String)"break is out of loop!");
        String str = xparse.detailedMessage();
        Assertions.assertTrue((boolean)str.contains("continue"));
    }

    @Test
    void testForEachLambda() throws Exception {
        JexlScript e = this.JEXL.createScript("(x)->{ for (i : 1..2) {  continue; var y = function() { 42; } break; } }");
        Assertions.assertNotNull((Object)e);
    }

    @Test
    void testForLoop0() {
        String src = "(l)->{ for(let x = 0; x < 4; ++x) { l.add(x); } }";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("(l)->{ for(let x = 0; x < 4; ++x) { l.add(x); } }");
        ArrayList l = new ArrayList();
        Object result = script.execute(null, new Object[]{l});
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3), l);
    }

    @Test
    void testForLoop1() {
        String src = "(l)->{ for(var x = 0; x < 4; ++x) { l.add(x); } }";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("(l)->{ for(var x = 0; x < 4; ++x) { l.add(x); } }");
        ArrayList l = new ArrayList();
        Object result = script.execute(null, new Object[]{l});
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3), l);
    }

    @Test
    void testForLoop2() {
        String src = "(l)->{ for(x = 0; x < 4; ++x) { l.add(x); } }";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("(l)->{ for(x = 0; x < 4; ++x) { l.add(x); } }");
        ArrayList l = new ArrayList();
        MapContext ctxt = new MapContext();
        Object result = script.execute((JexlContext)ctxt, new Object[]{l});
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3), l);
    }

    @Test
    void testSimpleWhileFalse() throws Exception {
        JexlScript e = this.JEXL.createScript("do {} while (false)");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertNull((Object)o);
        e = this.JEXL.createScript("do {} while (false); 23");
        o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)23, (Object)o);
    }

    @Test
    void testWhileEmptyBody() throws Exception {
        JexlScript e = this.JEXL.createScript("var i = 0; while((i+=1) < 10); i");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testWhileEmptyStmtBody() throws Exception {
        JexlScript e = this.JEXL.createScript("var i = 0; while((i+=1) < 10) {}; i");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testWhileExecutesExpressionWhenLooping() throws Exception {
        JexlScript e = this.JEXL.createScript("do x = x + 1 while (x < 10)");
        MapContext jc = new MapContext();
        jc.set("x", (Object)1);
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
        Assertions.assertEquals((Object)10, (Object)jc.get("x"));
        e = this.JEXL.createScript("var x = 0; do x += 1; while (x < 23)");
        o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)23, (Object)o);
        jc.set("x", (Object)1);
        e = this.JEXL.createScript("do x += 1; while (x < 23); return 42;");
        o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)23, (Object)jc.get("x"));
        Assertions.assertEquals((Object)42, (Object)o);
    }

    @Test
    void testWhileWithBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("do { x = x + 1; y = y * 2; } while (x < 10)");
        MapContext jc = new MapContext();
        jc.set("x", (Object)1);
        jc.set("y", (Object)1);
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)512, (Object)o, (String)"Result is wrong");
        Assertions.assertEquals((Object)10, (Object)jc.get("x"), (String)"x is wrong");
        Assertions.assertEquals((Object)512, (Object)jc.get("y"), (String)"y is wrong");
    }
}

