/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.function.Supplier;
import org.apache.commons.jexl3.CaptureLog;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.ObjectContext;
import org.apache.commons.logging.Log;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ExceptionTest
extends JexlTestCase {
    public ExceptionTest() {
        super("ExceptionTest");
    }

    private void doTest206(String src, boolean strict, boolean silent) {
        Object r;
        CaptureLog l;
        block7: {
            l = new CaptureLog();
            MapContext jc = new MapContext();
            JexlEngine jexl = new JexlBuilder().logger((Log)l).strict(strict).silent(silent).create();
            r = -1;
            JexlScript e = jexl.createScript(src);
            try {
                r = e.execute((JexlContext)jc);
                if (strict && !silent) {
                    Assertions.fail((String)"should have thrown an exception");
                }
            }
            catch (JexlException xjexl) {
                if (strict && !silent) break block7;
                Assertions.fail((String)(src + ": should not have thrown an exception"));
            }
        }
        if (strict) {
            if (silent && l.count("warn") == 0) {
                Assertions.fail((String)(src + ": should have generated a warning"));
            }
        } else {
            if (l.count("debug") == 0) {
                Assertions.fail((String)(src + ": should have generated a debug"));
            }
            Assertions.assertEquals((Object)42, (Object)r);
        }
    }

    @Test
    void test206() throws Exception {
        String src = "null.1 = 2; return 42";
        this.doTest206(src, false, false);
        this.doTest206(src, false, true);
        this.doTest206(src, true, false);
        this.doTest206(src, true, true);
        src = "x = null.1; return 42";
        this.doTest206(src, false, false);
        this.doTest206(src, false, true);
        this.doTest206(src, true, false);
        this.doTest206(src, true, true);
        src = "x = y.1; return 42";
        this.doTest206(src, false, false);
        this.doTest206(src, false, true);
        this.doTest206(src, true, false);
        this.doTest206(src, true, true);
    }

    @Test
    void testEx() {
        JexlEngine jexl = ExceptionTest.createEngine(false);
        JexlExpression e = jexl.createExpression("c.e * 6");
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        options.setStrict(true);
        JexlException.Variable xjexl = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> e.evaluate((JexlContext)ctxt), (String)"c not defined as variable should throw");
        String msg = xjexl.getMessage();
        Assertions.assertTrue((msg.indexOf("variable 'c.e'") > 0 ? 1 : 0) != 0);
        options.setStrictArithmetic(true);
        ctxt.set("c.e", null);
        xjexl = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> e.evaluate((JexlContext)ctxt), (String)"c.e as null operand should throw");
        msg = xjexl.getMessage();
        Assertions.assertTrue((msg.indexOf("variable 'c.e'") > 0 ? 1 : 0) != 0);
        options.setStrictArithmetic(false);
        e.evaluate((JexlContext)ctxt);
        ctxt.set("c", "{ 'a' : 3, 'b' : 5}");
        ctxt.set("e", 2);
        JexlException.Property ep = (JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> e.evaluate((JexlContext)ctxt));
        msg = ep.getMessage();
        Assertions.assertTrue((msg.indexOf("property 'e") > 0 ? 1 : 0) != 0);
    }

    @Test
    void testExMethod() {
        JexlEngine jexl = ExceptionTest.createEngine(false);
        JexlExpression e = jexl.createExpression("c.e.foo()");
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        options.setStrict(true);
        JexlException xjexl = (JexlException)Assertions.assertThrows(JexlException.class, () -> e.evaluate((JexlContext)ctxt), (String)"c not declared as variable should throw");
        String msg = xjexl.getMessage();
        Assertions.assertTrue((msg.indexOf("variable 'c.e'") > 0 ? 1 : 0) != 0);
        options.setStrictArithmetic(true);
        ctxt.set("c.e", null);
        xjexl = (JexlException)Assertions.assertThrows(JexlException.class, () -> e.evaluate((JexlContext)ctxt));
        msg = xjexl.getMessage();
        Assertions.assertTrue((msg.indexOf("variable 'c.e'") > 0 ? 1 : 0) != 0);
    }

    @Test
    void testExVar() {
        JexlEngine jexl = ExceptionTest.createEngine(false);
        JexlScript e = jexl.createScript("(x)->{ x * 6 }");
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        options.setStrict(true);
        options.setStrictArithmetic(true);
        JexlException xjexl = (JexlException)Assertions.assertThrows(JexlException.class, () -> e.execute((JexlContext)ctxt));
        String msg = xjexl.getMessage();
        Assertions.assertTrue((msg.indexOf("null") > 0 ? 1 : 0) != 0);
        options.setStrictArithmetic(false);
        Assertions.assertEquals((Object)0, (Object)e.execute((JexlContext)ctxt, new Object[]{null}));
    }

    @Test
    void testWrappedEx() {
        ExceptionTest.runWrappedEx(true, true);
        ExceptionTest.runWrappedEx(false, true);
        ExceptionTest.runWrappedEx(true, false);
        ExceptionTest.runWrappedEx(false, false);
    }

    private static void runWrappedEx(boolean debug, boolean silent) {
        CaptureLog log = new CaptureLog();
        JexlBuilder builder = new JexlBuilder().safe(false).strict(true).logger((Log)log).debug(debug).silent(silent);
        JexlEngine jexl = builder.create();
        ObjectContext jc = new ObjectContext(jexl, (Object)new ThrowNPE());
        ExceptionTest.callWrappedEx(debug, silent, log, () -> ExceptionTest.lambda$runWrappedEx$6(jexl, (JexlContext)jc));
        ExceptionTest.callWrappedEx(debug, silent, log, () -> jexl.newInstance(ConstructNPE.class, new Object[0]));
        ThrowNPE npe = new ThrowNPE();
        ExceptionTest.callWrappedEx(debug, silent, log, () -> jexl.invokeMethod((Object)npe, "npe", new Object[0]));
        ExceptionTest.callWrappedEx(debug, silent, log, () -> {
            jexl.setProperty((Object)npe, "fail", (Object)true);
            return null;
        });
        ExceptionTest.callWrappedEx(debug, silent, log, () -> jexl.getProperty((Object)npe, "fail"));
    }

    private static void callWrappedEx(boolean debug, boolean silent, CaptureLog log, Supplier<Object> npeCall) {
        try {
            npeCall.get();
            if (!silent) {
                Assertions.fail((String)"should have thrown");
            } else {
                Assertions.assertEquals((int)1, (int)log.count("warn"), (String)"should have 1 warn log");
                String msg = log.getCapturedMessages().get(0);
                Assertions.assertEquals((Object)debug, (Object)msg.contains("runWrappedEx"), (String)"class/method/line?");
                log.clear();
            }
        }
        catch (JexlException exception) {
            if (silent) {
                Assertions.fail((String)"should not have throw, should be silent");
            }
            Assertions.assertEquals((Object)debug, (Object)exception.getMessage().contains("runWrappedEx"), (String)"class/method/line?");
            Throwable xth = exception.getCause();
            Assertions.assertEquals(NullPointerException.class, xth.getClass(), (String)"Should have thrown NPE");
        }
    }

    @Test
    void testWrappedExmore() {
        JexlEngine jexl = new JexlBuilder().debug(true).safe(false).create();
        ThrowNPE npe = new ThrowNPE();
        Assertions.assertNull((Object)((JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> jexl.getProperty((Object)npe, "foo"))).getCause());
        Assertions.assertNull((Object)((JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> jexl.setProperty((Object)npe, "foo", (Object)42))).getCause());
        boolean b = (Boolean)jexl.getProperty((Object)npe, "fail");
        Assertions.assertFalse((boolean)b);
        jexl.setProperty((Object)npe, "fail", (Object)false);
        Assertions.assertEquals(NullPointerException.class, ((JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> jexl.setProperty((Object)npe, "fail", (Object)true))).getCause().getClass());
        Assertions.assertEquals(NullPointerException.class, ((JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> jexl.getProperty((Object)npe, "fail"))).getCause().getClass());
        Assertions.assertNull((Object)((JexlException.Method)Assertions.assertThrows(JexlException.Method.class, () -> jexl.invokeMethod((Object)npe, "foo", new Object[]{42}))).getCause());
        Assertions.assertEquals(NullPointerException.class, ((JexlException.Method)Assertions.assertThrows(JexlException.Method.class, () -> jexl.invokeMethod((Object)npe, "npe", new Object[0]))).getCause().getClass());
    }

    private static /* synthetic */ Object lambda$runWrappedEx$6(JexlEngine jexl, JexlContext jc) {
        return jexl.createExpression("npe()").evaluate(jc);
    }

    public static class ThrowNPE {
        boolean doThrow;

        public boolean getFail() {
            if (this.doThrow) {
                throw new NullPointerException("ThrowNPE/get");
            }
            return this.doThrow;
        }

        public String npe() {
            throw new NullPointerException("ThrowNPE");
        }

        public void setFail(boolean f) {
            this.doThrow = f;
            if (f) {
                throw new NullPointerException("ThrowNPE/set");
            }
        }
    }

    public static class ConstructNPE {
        public ConstructNPE() {
            throw new NullPointerException("ConstructNPE");
        }
    }
}

