/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Script;
import org.apache.commons.lang3.ThreadUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ScriptCallableTest
extends JexlTestCase {
    public ScriptCallableTest() {
        super("ScriptCallableTest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInterrupt(JexlEngine jexl) throws Exception {
        List<Runnable> lr = null;
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            TestContext ctxt = new TestContext();
            JexlScript sint = jexl.createScript("interrupt(); return 42");
            Object t = null;
            Script.Callable c = (Script.Callable)sint.callable((JexlContext)ctxt);
            try {
                t = c.call();
                Assertions.assertFalse((boolean)c.isCancellable(), (String)"should have thrown a Cancel");
            }
            catch (JexlException.Cancel xjexl) {
                Assertions.assertTrue((boolean)c.isCancellable(), () -> "should not have thrown " + xjexl);
            }
            Assertions.assertTrue((boolean)c.isCancelled());
            Assertions.assertNotEquals((Object)42, (Object)t);
            c = (Script.Callable)sint.callable((JexlContext)ctxt);
            Future f = executorService.submit(c);
            try {
                t = f.get();
                Assertions.assertFalse((boolean)c.isCancellable(), (String)"should have thrown a Cancel");
            }
            catch (ExecutionException xexec) {
                Assertions.assertTrue((boolean)c.isCancellable(), () -> "should not have thrown " + xexec);
            }
            Assertions.assertTrue((boolean)c.isCancelled());
            Assertions.assertNotEquals((Object)42, (Object)t);
            JexlScript ssleep = jexl.createScript("sleep(30000); return 42");
            Future f0 = executorService.submit(ssleep.callable((JexlContext)ctxt));
            Assertions.assertThrows(TimeoutException.class, () -> f0.get(100L, TimeUnit.MILLISECONDS));
            f0.cancel(true);
            Assertions.assertNotEquals((Object)42, (Object)t);
            Future fc0 = executorService.submit(ssleep.callable((JexlContext)ctxt));
            Runnable cancels0 = () -> {
                ThreadUtils.sleepQuietly((Duration)Duration.ofMillis(200L));
                fc0.cancel(true);
            };
            executorService.submit(cancels0);
            Assertions.assertThrows(CancellationException.class, () -> f0.get(100L, TimeUnit.MILLISECONDS));
            JexlScript swhile = jexl.createScript("while(true); return 42");
            Future f1 = executorService.submit(swhile.callable((JexlContext)ctxt));
            Assertions.assertThrows(TimeoutException.class, () -> f1.get(100L, TimeUnit.MILLISECONDS));
            f1.cancel(true);
            Assertions.assertNotEquals((Object)42, (Object)t);
            Future fc = executorService.submit(swhile.callable((JexlContext)ctxt));
            Runnable cancels = () -> {
                ThreadUtils.sleepQuietly((Duration)Duration.ofMillis(200L));
                fc.cancel(true);
            };
            executorService.submit(cancels);
            Assertions.assertThrows(CancellationException.class, fc::get);
            Assertions.assertNotEquals((Object)42, (Object)t);
        }
        finally {
            lr = executorService.shutdownNow();
        }
        Assertions.assertTrue((boolean)lr.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCallableCancel() throws Exception {
        List<Runnable> list;
        Semaphore latch = new Semaphore(0);
        MapContext ctxt = new MapContext();
        ctxt.set("latch", (Object)latch);
        JexlScript e = this.JEXL.createScript("latch.release(); while(true);");
        Script.Callable c = (Script.Callable)e.callable((JexlContext)ctxt);
        Callable<Object> kc = () -> {
            latch.acquire();
            return c.cancel();
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Future future = executor.submit(c);
            Future<Object> kfc = executor.submit(kc);
            Assertions.assertTrue((boolean)((Boolean)kfc.get()));
            ExecutionException xexec = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
            Assertions.assertTrue((boolean)(xexec.getCause() instanceof JexlException.Cancel));
        }
        finally {
            list = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)c.isCancelled());
        Assertions.assertTrue((list == null || list.isEmpty() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCallableCancellation() throws Exception {
        List<Runnable> list;
        Semaphore latch = new Semaphore(0);
        AtomicBoolean cancel = new AtomicBoolean();
        CancellationContext ctxt = new CancellationContext(cancel);
        ctxt.set("latch", latch);
        JexlScript e = this.JEXL.createScript("latch.release(); while(true);");
        Script.Callable c = (Script.Callable)e.callable((JexlContext)ctxt);
        Callable<Object> kc = () -> {
            latch.acquire();
            return cancel.compareAndSet(false, true);
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Future future = executor.submit(c);
            Future<Object> kfc = executor.submit(kc);
            Assertions.assertTrue((boolean)((Boolean)kfc.get()));
            ExecutionException xexec = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
            Assertions.assertTrue((boolean)(xexec.getCause() instanceof JexlException.Cancel));
        }
        finally {
            list = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)c.isCancelled());
        Assertions.assertTrue((list == null || list.isEmpty() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCallableClosure() throws Exception {
        List<Runnable> list;
        Future future;
        JexlScript e = this.JEXL.createScript("function(t) {while(t);}");
        Callable c = e.callable(null, new Object[]{Boolean.TRUE});
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            future = executor.submit(c);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
            future.cancel(true);
        }
        finally {
            list = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCallableTimeout() throws Exception {
        List<Runnable> list;
        Future future;
        Semaphore latch = new Semaphore(0);
        MapContext ctxt = new MapContext();
        ctxt.set("latch", (Object)latch);
        JexlScript e = this.JEXL.createScript("latch.release(); while(true);");
        Callable c = e.callable((JexlContext)ctxt);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            future = executor.submit(c);
            latch.acquire();
            Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
            future.cancel(true);
        }
        finally {
            list = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCancelForever() throws Exception {
        List<Runnable> list;
        Future future;
        Semaphore latch = new Semaphore(0);
        TestContext ctxt = new TestContext();
        ctxt.set("latch", latch);
        JexlScript e = this.JEXL.createScript("latch.release(); runForever()");
        Callable c = e.callable((JexlContext)ctxt);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            future = executor.submit(c);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
            future.cancel(true);
        }
        finally {
            list = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCancelLoopWait() throws Exception {
        List<Runnable> list;
        Future future;
        JexlScript e = this.JEXL.createScript("while (true) { wait(10) }");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            future = executor.submit(c);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
            future.cancel(true);
        }
        finally {
            list = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCancelWait() throws Exception {
        List<Runnable> list;
        JexlScript e = this.JEXL.createScript("wait(10)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            Future future = executor.submit(c);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
            future.cancel(true);
            Assertions.assertTrue((boolean)future.isCancelled());
        }
        finally {
            list = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCancelWaitInterrupt() throws Exception {
        List<Runnable> list;
        Future future;
        JexlScript e = this.JEXL.createScript("waitInterrupt(42)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            future = executor.submit(c);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
            future.cancel(true);
        }
        finally {
            list = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)future.isCancelled());
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testFuture() throws Exception {
        JexlScript e = this.JEXL.createScript("while(true);");
        FutureTask future = new FutureTask(e.callable(null));
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            executor.submit(future);
            Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
            future.cancel(true);
        }
        finally {
            executor.shutdown();
        }
        Assertions.assertTrue((boolean)future.isCancelled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testHangs() throws Exception {
        JexlScript e = this.JEXL.createScript("hangs()");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            Future future = executor.submit(c);
            ExecutionException xexec = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get(1L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)(xexec.getCause() instanceof JexlException.Method));
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    void testInterruptCancellable() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(true).strict(true).cancellable(true).create());
    }

    @Test
    void testInterruptSilentLenient() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(true).strict(false).create());
    }

    @Test
    void testInterruptSilentStrict() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(true).strict(true).create());
    }

    @Test
    void testInterruptVerboseLenient() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(false).strict(false).create());
    }

    @Test
    void testInterruptVerboseStrict() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(false).strict(true).create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testNoWait() throws Exception {
        List<Runnable> lr = null;
        JexlScript e = this.JEXL.createScript("wait(0)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            Future future = executor.submit(c);
            Object t = future.get(2L, TimeUnit.SECONDS);
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertEquals((Object)0, t);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)lr.isEmpty());
    }

    @Test
    void testTimeout() throws Exception {
        JexlScript script = this.JEXL.createScript("(flag)->{ @timeout(100) { while(flag); return 42 }; 'cancelled' }");
        AnnotationContext ctxt = new AnnotationContext();
        Object result = script.execute((JexlContext)ctxt, new Object[]{true});
        Assertions.assertEquals((Object)"cancelled", (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{false});
        Assertions.assertEquals((Object)42, (Object)result);
        script = this.JEXL.createScript("(flag)->{ @timeout(100, 'cancelled') { while(flag); 42; } }");
        result = script.execute((JexlContext)ctxt, new Object[]{true});
        Assertions.assertEquals((Object)"cancelled", (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{false});
        Assertions.assertEquals((Object)42, (Object)result);
        script = this.JEXL.createScript("@timeout(100) {sleep(1000); 42; } -42;");
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)-42, (Object)result);
        script = this.JEXL.createScript("@timeout(100) {sleep(1000); return 42; } return -42;");
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)-42, (Object)result);
        script = this.JEXL.createScript("@timeout(1000) {sleep(100); return 42; } return -42;");
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testWait() throws Exception {
        List<Runnable> lr = null;
        JexlScript e = this.JEXL.createScript("wait(1)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            Future future = executor.submit(c);
            Object t = future.get(2L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)1, t);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assertions.assertTrue((boolean)lr.isEmpty());
    }

    public static class TestContext
    extends MapContext
    implements JexlContext.NamespaceResolver {
        public int hangs(Object t) {
            return 1;
        }

        public int interrupt() {
            Thread.currentThread().interrupt();
            return 42;
        }

        public Object resolveNamespace(String name) {
            return name == null ? this : null;
        }

        public int runForever() {
            while (!Thread.currentThread().isInterrupted()) {
            }
            return 1;
        }

        public void sleep(long millis) throws InterruptedException {
            Thread.sleep(millis);
        }

        public int wait(int s) throws InterruptedException {
            Thread.sleep(1000 * s);
            return s;
        }

        public int waitInterrupt(int s) {
            try {
                Thread.sleep(1000 * s);
                return s;
            }
            catch (InterruptedException xint) {
                Thread.currentThread().interrupt();
                return -1;
            }
        }
    }

    public static class CancellationContext
    extends MapContext
    implements JexlContext.CancellationHandle {
        private final AtomicBoolean cancellation;

        CancellationContext(AtomicBoolean c) {
            this.cancellation = c;
        }

        public AtomicBoolean getCancellation() {
            return this.cancellation;
        }
    }

    public static class AnnotationContext
    extends MapContext
    implements JexlContext.AnnotationProcessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processAnnotation(String name, Object[] args, Callable<Object> statement) throws Exception {
            if ("timeout".equals(name) && args != null && args.length > 0) {
                Object def;
                long ms = args[0] instanceof Number ? ((Number)args[0]).longValue() : Long.parseLong(args[0].toString());
                Object object = def = args.length > 1 ? args[1] : null;
                if (ms > 0L) {
                    ExecutorService executor = Executors.newFixedThreadPool(1);
                    Future<Object> future = null;
                    try {
                        future = executor.submit(statement);
                        Object object2 = future.get(ms, TimeUnit.MILLISECONDS);
                        return object2;
                    }
                    catch (TimeoutException xtimeout) {
                        future.cancel(true);
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                return def;
            }
            return statement.call();
        }

        public void sleep(long ms) throws InterruptedException {
            Thread.sleep(ms);
        }
    }
}

