/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerTest;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LazyInitializerFailableCloserTest
extends AbstractConcurrentInitializerTest<Object> {
    private final AtomicBoolean closed = new AtomicBoolean();

    LazyInitializerFailableCloserTest() {
    }

    @Override
    protected LazyInitializer<Object> createInitializer() {
        return ((LazyInitializer.Builder)((LazyInitializer.Builder)LazyInitializer.builder().setInitializer(this::makeObject)).setCloser(e -> this.throwingCloser())).get();
    }

    private Object makeObject() throws ConcurrentException {
        if (this.closed.get()) {
            throw new ConcurrentException("test", (Throwable)new IOException());
        }
        return new Object();
    }

    @Test
    void testIsInitialized() throws ConcurrentException {
        LazyInitializer<Object> initializer = this.createInitializer();
        Assertions.assertFalse((boolean)initializer.isInitialized());
        initializer.get();
        Assertions.assertTrue((boolean)initializer.isInitialized());
        Assertions.assertFalse((boolean)this.closed.get());
        initializer.close();
        Assertions.assertTrue((boolean)this.closed.get());
    }

    private void throwingCloser() throws ConcurrentException {
        this.closed.set(true);
        if (!this.closed.get()) {
            throw new ConcurrentException("test", (Throwable)new IOException());
        }
    }
}

