/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.FileStringLookup;
import org.apache.commons.text.lookup.InterpolatorStringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileStringLookupTest {
    private static final Path DOCUEMENT_PATH = Paths.get("src/test/resources/org/apache/commons/text/document.properties", new String[0]);
    private static final Path CURRENT_PATH = Paths.get("", new String[0]);

    public static String readDocumentFixtureString() throws IOException {
        return new String(Files.readAllBytes(DOCUEMENT_PATH), StandardCharsets.UTF_8);
    }

    public static void testFence(String expectedString, FileStringLookup fileStringLookup) {
        Assertions.assertEquals((Object)expectedString, (Object)fileStringLookup.apply("UTF-8:src/test/resources/org/apache/commons/text/document.properties"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> fileStringLookup.apply("UTF-8:/src/test/resources/org/apache/commons/text/document.properties"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> fileStringLookup.apply("UTF-8:../src/test/resources/org/apache/commons/text/document.properties"));
    }

    public static void testFence(StringSubstitutor stringSubstitutor) throws IOException {
        Assertions.assertEquals((Object)FileStringLookupTest.readDocumentFixtureString(), (Object)stringSubstitutor.replace("${file:UTF-8:" + DOCUEMENT_PATH + "}"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${file:UTF-8:/foo.txt}"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${file:UTF-8:../foo.txt}"));
    }

    @Test
    void testDefaultInstanceBadCharsetName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileStringLookup.INSTANCE.apply("BAD_CHARSET_NAME:src/test/resources/org/apache/commons/text/document.properties"));
    }

    @Test
    void testDefaultInstanceBadDocumentPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileStringLookup.INSTANCE.apply("BAD_CHARSET_NAME:src/test/resources/DOCUMENT_NOT_FOUND.TXT"));
    }

    @Test
    void testDefaultInstanceMissingFilePart() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileStringLookup.INSTANCE.apply(StandardCharsets.UTF_8.name()));
    }

    @Test
    void testDefaultInstanceNull() {
        Assertions.assertNull((Object)FileStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testDefaultInstanceOne() throws Exception {
        String expectedString = FileStringLookupTest.readDocumentFixtureString();
        Assertions.assertEquals((Object)expectedString, (Object)FileStringLookup.INSTANCE.apply("UTF-8:src/test/resources/org/apache/commons/text/document.properties"));
    }

    @Test
    void testDefaultInstanceToString() {
        Assertions.assertFalse((boolean)FileStringLookup.INSTANCE.toString().isEmpty());
    }

    @Test
    void testFenceBadDirOne() throws Exception {
        FileStringLookup fileStringLookup = new FileStringLookup(new Path[]{Paths.get("dir does not exist at all", new String[0])});
        Assertions.assertThrows(IllegalArgumentException.class, () -> fileStringLookup.apply("UTF-8:src/test/resources/org/apache/commons/text/document.properties"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> fileStringLookup.apply("UTF-8:/src/test/resources/org/apache/commons/text/document.properties"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> fileStringLookup.apply("UTF-8:../src/test/resources/org/apache/commons/text/document.properties"));
    }

    @Test
    void testFenceBadDirPlusGoodOne() throws Exception {
        String expectedString = FileStringLookupTest.readDocumentFixtureString();
        FileStringLookup fileStringLookup = new FileStringLookup(new Path[]{Paths.get("dir does not exist at all", new String[0]), CURRENT_PATH});
        FileStringLookupTest.testFence(expectedString, fileStringLookup);
    }

    @Test
    void testFenceCurrentDirOne() throws Exception {
        String expectedString = FileStringLookupTest.readDocumentFixtureString();
        FileStringLookup fileStringLookup = new FileStringLookup(new Path[]{CURRENT_PATH});
        FileStringLookupTest.testFence(expectedString, fileStringLookup);
    }

    @Test
    void testFenceCurrentDirPlusOne() throws Exception {
        String expectedString = FileStringLookupTest.readDocumentFixtureString();
        FileStringLookup fileStringLookup = new FileStringLookup(new Path[]{Paths.get("target", new String[0]), CURRENT_PATH});
        FileStringLookupTest.testFence(expectedString, fileStringLookup);
    }

    @Test
    void testFenceEmptyOne() throws Exception {
        String expectedString = FileStringLookupTest.readDocumentFixtureString();
        Assertions.assertEquals((Object)expectedString, (Object)new FileStringLookup(new Path[0]).apply("UTF-8:src/test/resources/org/apache/commons/text/document.properties"));
    }

    @Test
    void testFenceNullOne() throws Exception {
        String expectedString = FileStringLookupTest.readDocumentFixtureString();
        Assertions.assertEquals((Object)expectedString, (Object)new FileStringLookup((Path[])null).apply("UTF-8:src/test/resources/org/apache/commons/text/document.properties"));
    }

    @Test
    void testInterpolatorReplace() throws IOException {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)FileStringLookupTest.readDocumentFixtureString(), (Object)stringSubstitutor.replace("${file:UTF-8:" + DOCUEMENT_PATH + "}"));
        InterpolatorStringLookup stringLookup = (InterpolatorStringLookup)stringSubstitutor.getStringLookup();
        stringLookup.getStringLookupMap().replace("file", StringLookupFactory.INSTANCE.fileStringLookup(new Path[]{CURRENT_PATH}));
        FileStringLookupTest.testFence(stringSubstitutor);
    }
}

