<!--
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#  KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
-->

# cordova-coho Usage / Cordova Committer Documentation

This is a collection of documentation on processes using `cordova-coho`:

## Release Processes

Follow these processes to release...

* [Tools](tools-release-process.md) (CLI etc.)
* [Platforms](platforms-release-process.md) (iOS, Android, Windows etc.)
* [Plugins](plugins-release-process.md)
* [Hello world app](app-hello-world-release-process.md)
* [`cordova-coho` itself](coho-release-process.md)

### About Releases

* [Versioning and release strategy](versioning-and-release-strategy.md)
* [Release Voting](release-voting.md)
* [Setting up GPG](setting-up-gpg.md)

## Committer Workflow

Things a committer frequently does:

* [Committer workflow](committer-workflow.md)
* [Code Reviews](code-reviews.md)
* [Processing Pull Requests](processing-pull-requests.md)
* [Triaging JIRA issues](jira-triage.md)

## Misc

* [Storing Repo Versions Design](storing-repo-versions-design.md)
* [Access to Apache's jenkins CI setup (deprecated)](jenkins-access.md)
