/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.daffodil.section10.representation_properties

import org.apache.daffodil.junit.tdml.TdmlSuite
import org.apache.daffodil.junit.tdml.TdmlTests

import org.junit.Test

object TestRepProps extends TdmlSuite {
  val tdmlResource = "/org/apache/daffodil/section10/representation_properties/RepProps.tdml"
}

class TestRepProps extends TdmlTests {
  val tdmlSuite = TestRepProps

  @Test def repPropMissing = test
  @Test def repPropMissing2 = test
  @Test def repPropMissing3 = test

  @Test def hexBinary_01 = test

  // These tests are temporary - see DFDL-994
  @Test def temporaryDefaultProps_01 = test
  @Test def temporaryDefaultProps_02 = test
}
